/*
 * Decompiled with CFR 0.152.
 */
package axolootl.network;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.data.aquarium_tab.WorldlyMenuProvider;
import axolootl.menu.AbstractControllerMenu;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class ServerBoundControllerCyclePacket {
    private int cycle;

    public ServerBoundControllerCyclePacket(int cycle) {
        this.cycle = cycle;
    }

    public static ServerBoundControllerCyclePacket fromBytes(FriendlyByteBuf buf) {
        int tab = buf.readInt();
        return new ServerBoundControllerCyclePacket(tab);
    }

    public static void toBytes(ServerBoundControllerCyclePacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.cycle);
    }

    public static void handlePacket(ServerBoundControllerCyclePacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER && context.getSender() != null) {
            context.enqueueWork(() -> {
                AbstractControllerMenu menu;
                ServerPlayer player = context.getSender();
                AbstractContainerMenu patt2395$temp = player.f_36096_;
                if (!(patt2395$temp instanceof AbstractControllerMenu) || (menu = (AbstractControllerMenu)patt2395$temp).getController().isEmpty()) {
                    return;
                }
                BlockPos controllerPos = menu.getController().get().m_58899_();
                ControllerBlockEntity controller = (ControllerBlockEntity)player.f_19853_.m_7702_(controllerPos);
                if (null == controller) {
                    return;
                }
                IAquariumTab tab = AxRegistry.AquariumTabsReg.getSortedTabs().get(menu.validateTab(menu.getTab()));
                if (!tab.isAvailable(controller)) {
                    return;
                }
                if (message.cycle < 0 || message.cycle >= menu.getSortedCycleList().size()) {
                    return;
                }
                BlockPos pos = menu.getSortedCycleList().get(message.cycle);
                Optional<WorldlyMenuProvider> oProvider = tab.getMenuProvider(controller, pos);
                if (oProvider.isEmpty()) {
                    return;
                }
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)oProvider.get().getProvider(), AxRegistry.MenuReg.writeControllerMenu(controllerPos, oProvider.get().getPos(), menu.getTab(), message.cycle));
            });
        }
        context.setPacketHandled(true);
    }
}

