/*
 * Decompiled with CFR 0.152.
 */
package axolootl.util;

import axolootl.util.MatchingStatePredicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.registries.ForgeRegistries;

public final class AxCodecUtils {
    public static final Codec<ItemStack> ITEM_OR_STACK_CODEC = Codec.either((Codec)ForgeRegistries.ITEMS.getCodec(), (Codec)ItemStack.f_41582_).xmap(either -> (ItemStack)either.map(ItemStack::new, Function.identity()), stack -> stack.m_41613_() == 1 && !stack.m_41782_() ? Either.left((Object)stack.m_41720_()) : Either.right((Object)stack));
    public static final Codec<Integer> HEX_INT_CODEC = AxCodecUtils.hexIntCodec();
    public static final Codec<Integer> HEX_OR_INT_CODEC = Codec.either(HEX_INT_CODEC, (Codec)Codec.INT).xmap(either -> (Integer)either.map(Function.identity(), Function.identity()), i -> Either.right((Object)i));
    public static final Codec<HolderSet<Item>> ITEM_HOLDER_SET_CODEC = RegistryCodecs.m_206279_((ResourceKey)ForgeRegistries.Keys.ITEMS, (Codec)ForgeRegistries.ITEMS.getCodec());
    public static final Codec<Rarity> RARITY_CODEC = Codec.STRING.xmap(AxCodecUtils::getRarityByName, r -> r.toString().toLowerCase(Locale.ENGLISH));
    public static final Codec<Vec3i> NON_NEGATIVE_VEC3I_CODEC = AxCodecUtils.vec3Codec(0);
    public static final Codec<Vec3i> POSITIVE_VEC3I_CODEC = AxCodecUtils.vec3Codec(1);
    public static final Codec<MinMaxBounds.Ints> INTS_DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min").forGetter(o -> Optional.ofNullable((Integer)o.m_55305_())), (App)Codec.INT.optionalFieldOf("max").forGetter(o -> Optional.ofNullable((Integer)o.m_55326_()))).apply((Applicative)instance, (p1, p2) -> {
        if (p1.isPresent() && p2.isEmpty()) {
            return MinMaxBounds.Ints.m_55386_((int)((Integer)p1.get()));
        }
        if (p1.isEmpty() && p2.isPresent()) {
            return MinMaxBounds.Ints.m_154819_((int)((Integer)p2.get()));
        }
        if (p1.isEmpty() && p2.isEmpty()) {
            return MinMaxBounds.Ints.f_55364_;
        }
        return MinMaxBounds.Ints.m_154814_((int)((Integer)p1.get()), (int)((Integer)p2.get()));
    }));
    public static final Codec<MinMaxBounds.Ints> INTS_CODEC = Codec.either((Codec)Codec.INT, INTS_DIRECT_CODEC).xmap(either -> (MinMaxBounds.Ints)either.map(MinMaxBounds.Ints::m_55371_, Function.identity()), o -> o.m_55305_() != null && o.m_55326_() != null && ((Integer)o.m_55305_()).equals(o.m_55326_()) ? Either.left((Object)((Integer)o.m_55305_())) : Either.right((Object)o));
    public static final Codec<MinMaxBounds.Ints> NON_NEGATIVE_INTS_CODEC = AxCodecUtils.boundedIntCodec(0, Integer.MAX_VALUE);
    public static final Codec<MinMaxBounds.Ints> POSITIVE_INTS_CODEC = AxCodecUtils.boundedIntCodec(1, Integer.MAX_VALUE);
    public static final Codec<LightPredicate> LIGHT_PREDICATE_CODEC = INTS_CODEC.xmap(composite -> new LightPredicate.Builder().m_153104_(composite).m_153106_(), o -> o.f_51336_);
    public static final Codec<FluidPredicate> FLUID_PREDICATE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)ForgeRegistries.Keys.FLUIDS).optionalFieldOf("tag").forGetter(o -> Optional.ofNullable(o.f_41095_)), (App)ForgeRegistries.FLUIDS.getCodec().optionalFieldOf("fluid").forGetter(o -> Optional.ofNullable(o.f_41096_)), (App)MatchingStatePredicate.STATE_PROPERTIES_PREDICATE_CODEC.optionalFieldOf("state").forGetter(o -> Optional.of(o.f_41097_))).apply((Applicative)instance, (tag, fluid, state) -> {
        FluidPredicate.Builder builder = FluidPredicate.Builder.m_151166_();
        tag.ifPresent(arg_0 -> ((FluidPredicate.Builder)builder).m_204105_(arg_0));
        fluid.ifPresent(arg_0 -> ((FluidPredicate.Builder)builder).m_151171_(arg_0));
        state.ifPresent(arg_0 -> ((FluidPredicate.Builder)builder).m_151169_(arg_0));
        return builder.m_151173_();
    }));
    public static final Pattern RESOURCE_LOCATION_PATTERN = Pattern.compile("(?:[a-z0-9_.]+:)?[a-z0-9_./-]+");

    public static <T> Codec<List<T>> listOrElementCodec(Codec<T> codec) {
        return Codec.either(codec, (Codec)codec.listOf()).xmap(either -> (List)either.map(ImmutableList::of, Function.identity()), list -> list.size() == 1 ? Either.left(list.get(0)) : Either.right((Object)list));
    }

    public static <T> Codec<Set<T>> setOrElementCodec(Codec<T> codec) {
        return Codec.either(codec, (Codec)codec.listOf().xmap(o -> ImmutableSet.copyOf((Collection)o), ImmutableList::copyOf)).xmap(either -> (Set)either.map(ImmutableSet::of, Function.identity()), set -> set.size() == 1 ? Either.left(set.iterator().next()) : Either.right((Object)set));
    }

    public static <T> Codec<SimpleWeightedRandomList<T>> weightedListOrElementCodec(Codec<T> codec) {
        return Codec.either(codec, (Codec)SimpleWeightedRandomList.m_146264_(codec)).xmap(either -> (SimpleWeightedRandomList)either.map(SimpleWeightedRandomList::m_185862_, Function.identity()), list -> list.m_146338_().size() == 1 ? Either.left((Object)((WeightedEntry.Wrapper)list.m_146338_().get(0)).m_146310_()) : Either.right((Object)list));
    }

    private static Codec<Integer> hexIntCodec() {
        Pattern pattern = Pattern.compile("[0-9a-fA-F]+");
        Function<String, DataResult> function = s -> {
            if (s.isEmpty()) {
                return DataResult.error((String)"Failed to parse hex int from empty string");
            }
            if (!pattern.matcher((CharSequence)s).matches()) {
                return DataResult.error((String)("Invalid hex int " + s));
            }
            return DataResult.success((Object)s);
        };
        return Codec.STRING.flatXmap(function, function).xmap(s -> Integer.valueOf(s, 16), Integer::toHexString);
    }

    private static Rarity getRarityByName(String name) {
        for (Rarity rarity : Rarity.values()) {
            if (!rarity.toString().toLowerCase(Locale.ENGLISH).equals(name)) continue;
            return rarity;
        }
        return Rarity.COMMON;
    }

    public static Codec<Vec3i> vec3Codec(int min) {
        Function<Vec3i, DataResult> function = instance -> {
            if (instance.m_123341_() < min || instance.m_123342_() < min || instance.m_123343_() < min) {
                return DataResult.error((String)("Vec3i too low. minimum " + min + "; provided [" + instance.m_123344_() + "]"));
            }
            return DataResult.success((Object)instance);
        };
        return Vec3i.f_123287_.flatXmap(function, function);
    }

    public static Codec<MinMaxBounds.Ints> boundedIntCodec(int min, int max) {
        Function<MinMaxBounds.Ints, DataResult> function = instance -> {
            if (instance.m_55305_() != null && (Integer)instance.m_55305_() < min) {
                return DataResult.error((String)("Value too low. minimum " + min + "; provided [" + instance + "]"));
            }
            if (instance.m_55326_() != null && (Integer)instance.m_55326_() > max) {
                return DataResult.error((String)("Value too high. maximum " + max + "; provided [" + instance + "]"));
            }
            return DataResult.success((Object)instance);
        };
        return INTS_CODEC.flatXmap(function, function);
    }
}

