/*
 * Decompiled with CFR 0.152.
 */
package axolootl;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.block.AquariumGlassBlock;
import axolootl.block.BlockConverter;
import axolootl.command.AxolootlResearchCommand;
import axolootl.data.aquarium_modifier.AquariumModifier;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.data.breeding.AxolootlBreeding;
import axolootl.data.resource_generator.ResourceGenerator;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class AxEvents {
    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register(ModHandler.class);
        MinecraftForge.EVENT_BUS.register(ForgeHandler.class);
    }

    public static final class ModHandler {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(ModHandler::registerDispenserBehavior);
            event.enqueueWork(ModHandler::registerAquariumGlassConverters);
        }

        private static void registerDispenserBehavior() {
            DispenseItemBehavior axolotlBucketBehavior = (DispenseItemBehavior)DispenserBlock.f_52661_.get(Items.f_151057_);
            if (axolotlBucketBehavior != null) {
                DispenserBlock.m_52672_((ItemLike)((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get()), (DispenseItemBehavior)axolotlBucketBehavior);
            }
        }

        private static void registerAquariumGlassConverters() {
            ModHandler.registerAquariumGlassConverter(AxRegistry.BlockReg.AQUARIUM_CONTROLLER);
            ModHandler.registerAquariumGlassConverter(AxRegistry.BlockReg.AQUARIUM_AXOLOOTL_INSPECTOR);
            ModHandler.registerAquariumGlassConverter(AxRegistry.BlockReg.AQUARIUM_AXOLOOTL_INTERFACE);
            ModHandler.registerAquariumGlassConverter(AxRegistry.BlockReg.AQUARIUM_ENERGY_INTERFACE);
            ModHandler.registerAquariumGlassConverter(AxRegistry.BlockReg.AQUARIUM_WATER_INTERFACE);
            ModHandler.registerAquariumGlassConverter(AxRegistry.BlockReg.AQUARIUM_OUTPUT);
            ModHandler.registerAquariumGlassConverter(AxRegistry.BlockReg.LARGE_AQUARIUM_OUTPUT);
        }

        private static void registerAquariumGlassConverter(RegistryObject<Block> block) {
            AquariumGlassBlock.registerItemConverter(BlockConverter.itemConverter((Supplier<Item>)RegistryObject.create((ResourceLocation)block.getId(), (IForgeRegistry)ForgeRegistries.ITEMS), block));
        }
    }

    public static final class ForgeHandler {
        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            AxolootlResearchCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        public static void onDatapackSync(OnDatapackSyncEvent event) {
            RegistryAccess.Frozen registryAccess = event.getPlayerList().m_7873_().m_206579_();
            AxRegistry.refreshCaches((RegistryAccess)registryAccess);
            Axolootl.LOGGER.debug("Axolootl loaded " + AxolootlVariant.getRegistry((RegistryAccess)registryAccess).m_13562_() + " axolootl variants");
            Axolootl.LOGGER.debug("Axolootl loaded " + ResourceGenerator.getRegistry((RegistryAccess)registryAccess).m_13562_() + " resource generators");
            Axolootl.LOGGER.debug("Axolootl loaded " + AxolootlBreeding.getRegistry((RegistryAccess)registryAccess).m_13562_() + " axolootl breeding recipes");
            Axolootl.LOGGER.debug("Axolootl loaded " + AquariumModifier.getRegistry((RegistryAccess)registryAccess).m_13562_() + " aquarium modifiers");
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
            if (event.getEntity().f_19853_.m_5776_()) {
                AxRegistry.clearCaches();
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onTagsUpdated(TagsUpdatedEvent event) {
            RegistryAccess registryAccess = event.getRegistryAccess();
            AxRegistry.AxolootlVariantsReg.validate(registryAccess);
            Axolootl.LOGGER.debug("Axolootl validated " + (AxolootlVariant.getRegistry(registryAccess).m_13562_() - AxRegistry.AxolootlVariantsReg.getInvalidEntries().size()) + " axolootl variants");
        }
    }
}

