/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block;

import axolootl.AxRegistry;
import axolootl.block.entity.InterfaceBlockEntity;
import axolootl.block.entity.MonsteriumBlockEntity;
import axolootl.data.aquarium_tab.IAquariumTab;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class MonsteriumBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public MonsteriumBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)AxRegistry.BlockEntityReg.MONSTERIUM.get()).m_155264_(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof MonsteriumBlockEntity) {
                MonsteriumBlockEntity blockEntity2 = (MonsteriumBlockEntity)blockEntity;
                if (blockEntity2.hasTank() && blockEntity2.validateController(pLevel)) {
                    blockEntity2.m_6596_();
                }
                BlockPos controllerPos = blockEntity2.getController().isPresent() ? blockEntity2.getController().get().m_58899_() : pPos;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)blockEntity2, AxRegistry.MenuReg.writeControllerMenu(controllerPos, pPos, ((IAquariumTab)AxRegistry.AquariumTabsReg.FOOD_INTERFACE.get()).getSortedIndex(), -1));
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof InterfaceBlockEntity) {
                InterfaceBlockEntity blockEntity2 = (InterfaceBlockEntity)blockEntity;
                blockEntity2.dropAllItems();
            }
            level.m_46717_(pos, (Block)this);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean waterlogged = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            return AbstractContainerMenu.m_38938_((Container)container);
        }
        return 0;
    }
}

