/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block.entity;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.block.entity.InterfaceBlockEntity;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.item.AxolootlBucketItem;
import axolootl.menu.AxolootlInspectorMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AxolootlInspectorBlockEntity
extends InterfaceBlockEntity {
    protected static final int MAX_PROGRESS = 310;
    protected int progress;
    protected int maxProgress = 310;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int pIndex) {
            switch (pIndex) {
                case 0: {
                    return AxolootlInspectorBlockEntity.this.progress;
                }
                case 1: {
                    return AxolootlInspectorBlockEntity.this.maxProgress;
                }
            }
            return 0;
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    AxolootlInspectorBlockEntity.this.progress = pValue;
                    break;
                }
                case 1: {
                    AxolootlInspectorBlockEntity.this.maxProgress = pValue;
                    break;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public AxolootlInspectorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)AxRegistry.BlockEntityReg.AXOLOOTL_INSPECTOR.get(), pPos, pBlockState);
    }

    public AxolootlInspectorBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState, 1, 2);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AxolootlInspectorBlockEntity self) {
        Optional<ControllerBlockEntity> oController = self.getController();
        if (oController.isEmpty() || !oController.get().hasTank() || !oController.get().getTankStatus().isActive()) {
            return;
        }
        boolean markDirty = false;
        markDirty |= self.validateController(level);
        if (markDirty |= self.tickInspector(level)) {
            self.m_6596_();
            level.m_7260_(pos, state, state, 2);
        }
    }

    private boolean tickInspector(Level level) {
        int oldProgress = this.progress;
        int oldMaxProgress = this.maxProgress;
        boolean hasItems = this.hasInspectorItems(level);
        if (!hasItems) {
            this.progress = 0;
        } else if (this.progress <= 0) {
            this.progress = 1;
        } else if (++this.progress >= this.maxProgress) {
            this.progress = 0;
            ItemStack input = this.m_8016_(0);
            this.m_6836_(1, input);
        }
        return this.progress != oldProgress || this.maxProgress != oldMaxProgress;
    }

    public boolean hasInspectorItems(Level level) {
        ItemStack input = this.m_8020_(0);
        if (input.m_41619_() || AxolootlBucketItem.getVariant(level.m_5962_(), input).isEmpty()) {
            return false;
        }
        return this.m_8020_(1).m_41619_();
    }

    public boolean isInspectorComplete() {
        return !this.m_8020_(1).m_41619_();
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public boolean isMenuAvailable(Player player, ControllerBlockEntity controller) {
        return ((IAquariumTab)AxRegistry.AquariumTabsReg.AXOLOOTL_INSPECTOR.get()).isAvailable(controller);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new AxolootlInspectorMenu(pContainerId, pPlayerInventory, this.controllerPos, this.getController().get(), this.m_58899_(), ((IAquariumTab)AxRegistry.AquariumTabsReg.AXOLOOTL_INSPECTOR.get()).getSortedIndex(), -1);
    }

    public int m_6893_() {
        return 1;
    }

    @Override
    protected IItemHandler createItemHandler() {
        return new InvWrapper(this){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_41782_() && stack.m_41783_().m_128425_("Axolootl", 8);
            }
        };
    }
}

