/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block.entity;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.block.entity.IAquariumControllerProvider;
import axolootl.block.entity.VoidEnergyStorage;
import axolootl.data.aquarium_modifier.AquariumModifier;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.data.resource_generator.ResourceTypes;
import axolootl.entity.IAxolootl;
import axolootl.menu.ControllerMenu;
import axolootl.util.BreedStatus;
import axolootl.util.FeedStatus;
import axolootl.util.TankMultiblock;
import axolootl.util.TankStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ControllerBlockEntity
extends BlockEntity
implements MenuProvider,
IAquariumControllerProvider {
    public static final double BASE_GENERATION_SPEED = 0.1;
    public static final double BASE_BREED_SPEED = 0.0;
    public static final double BASE_FEED_SPEED = 0.0;
    public static final long BASE_SPEED_DECREMENT = 100L;
    public static final long AXOLOOTL_SEARCH_INTERVAL = 150L;
    public static final long AXOLOOTL_VALIDATE_INTERVAL = 30L;
    public static final long MODIFIER_VALIDATE_INTERVAL = 51L;
    public static final double OUTSIDE_ITERATOR_SCAN = 0.4;
    public static final double INSIDE_ITERATOR_SCAN = 0.6;
    private double generationSpeed;
    private double breedSpeed;
    private double feedSpeed;
    private boolean enableMobResources;
    private boolean enableMobBreeding;
    private boolean isOutputFull;
    private boolean isInsufficientPower;
    private boolean isFeedInputEmpty;
    private boolean isBreedInputEmpty;
    private boolean isDuplicateFound;
    private long resourceGenerationTime = 1L;
    private long breedTime = 1L;
    private long feedTime = 1L;
    private boolean forceCalculateBonuses = true;
    private boolean forceCalculateAxolootls;
    private TankStatus tankStatus;
    private BreedStatus breedStatus;
    private FeedStatus feedStatus;
    @Nullable
    private Iterator<BlockPos> outsideIterator;
    @Nullable
    private Iterator<BlockPos> insideIterator;
    @Nullable
    private TankMultiblock.Size size;
    private final Map<ResourceLocation, Set<BlockPos>> trackedBlocks = new HashMap<ResourceLocation, Set<BlockPos>>();
    private final Map<BlockPos, ResourceLocation> aquariumModifiers = new HashMap<BlockPos, ResourceLocation>();
    private final Set<BlockPos> activeAquariumModifiers = new HashSet<BlockPos>();
    private final Map<UUID, ResourceLocation> trackedAxolootls = new HashMap<UUID, ResourceLocation>();
    public final BiPredicate<BlockPos, AquariumModifier> activePredicate = (p, o) -> this.activeAquariumModifiers.contains(p);
    private static final String KEY_TANK_STATUS = "Status";
    private static final String KEY_FEED_STATUS = "Feed";
    private static final String KEY_BREED_STATUS = "Breed";
    private static final String KEY_SIZE = "Size";
    private static final String KEY_MODIFIERS = "Modifiers";
    private static final String KEY_MODIFIER = "Modifier";
    private static final String KEY_POS = "Pos";
    private static final String KEY_ACTIVE = "Active";
    private static final String KEY_CATEGORY = "Category";
    private static final String KEY_TRACKED_BLOCKS = "TrackedBlocks";
    private static final String KEY_POSITIONS = "Positions";
    private static final String KEY_AXOLOOTLS = "Axolootls";
    private static final String KEY_UUID = "UUID";
    private static final String KEY_VARIANT = "Variant";
    private static final String KEY_GENERATION_TIME = "GenerationTime";
    private static final String KEY_BREED_TIME = "BreedTime";
    private static final String KEY_FEED_TIME = "FeedTime";
    private static final String KEY_GENERATION_SPEED = "GenerationSpeed";
    private static final String KEY_FEED_SPEED = "FeedSpeed";
    private static final String KEY_BREED_SPEED = "BreedSpeed";

    public ControllerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this((BlockEntityType)AxRegistry.BlockEntityReg.CONTROLLER.get(), pPos, pBlockState);
    }

    public ControllerBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.tankStatus = TankStatus.INCOMPLETE;
        this.feedStatus = FeedStatus.INACTIVE;
        this.breedStatus = BreedStatus.INACTIVE;
    }

    public static void tick(Level levelAccessor, BlockPos pos, BlockState state, ControllerBlockEntity self) {
        ServerLevel level;
        block8: {
            block7: {
                if (!(levelAccessor instanceof ServerLevel)) break block7;
                level = (ServerLevel)levelAccessor;
                if (self.hasTank() && self.size.isAreaLoaded((LevelAccessor)level)) break block8;
            }
            return;
        }
        boolean markDirty = false;
        level.m_46473_().m_6180_("axolootlStatus");
        markDirty |= self.updateStatus(level);
        level.m_46473_().m_7238_();
        if (self.hasTank()) {
            level.m_46473_().m_6180_("aquariumTankSize");
            int blocksToScan = (Integer)Axolootl.CONFIG.TANK_MULTIBLOCK_UPDATE_CAP.get();
            markDirty |= self.iterateOutside(level, Mth.m_14165_((double)((double)blocksToScan * 0.4)));
            markDirty |= self.validateTrackedBlocks(level);
            level.m_46473_().m_6182_("aquariumModifiers");
            markDirty |= self.iterateInside(level, Mth.m_14165_((double)((double)blocksToScan * 0.6)));
            markDirty |= self.validateUpdateModifiers(level);
            level.m_46473_().m_7238_();
        }
        if (self.getTankStatus().isActive()) {
            level.m_46473_().m_6180_("aquariumEnergy");
            markDirty |= self.distributeEnergyToModifiers((Level)level);
            level.m_46473_().m_6182_("aquariumEntities");
            markDirty |= self.validateAxolootls(level);
            markDirty |= self.findAxolootls(level);
            level.m_46473_().m_6182_("aquariumBonuses");
            if (self.forceCalculateBonuses) {
                markDirty |= self.applyActiveModifiers(level);
                self.forceCalculateBonuses = false;
            }
            level.m_46473_().m_6182_("aquariumTickers");
            markDirty |= self.updateTickers(level);
            level.m_46473_().m_6182_("aquariumFeed");
            markDirty |= self.feed(level);
            level.m_46473_().m_6182_("aquariumBreed");
            markDirty |= self.breed(level);
            level.m_46473_().m_6182_("aquariumResources");
            markDirty |= self.generateResources(level);
            level.m_46473_().m_7238_();
        }
        if (markDirty) {
            self.m_6596_();
            level.m_7260_(pos, state, state, 2);
        }
    }

    public static int calculateMaxCapacity(TankMultiblock.Size size) {
        double volumeFactor = (Double)Axolootl.CONFIG.TANK_CAPACITY_VOLUME_FACTOR.get();
        if (!(volumeFactor > 0.0)) {
            return Integer.MAX_VALUE;
        }
        return Mth.m_14107_((double)((double)size.getInnerVolume() / volumeFactor));
    }

    private static boolean notEquals(double d1, double d2) {
        return Math.abs(d1 - d2) > 1.0E-8;
    }

    @Override
    public boolean hasTank() {
        return this.size != null;
    }

    private boolean updateTickers(ServerLevel level) {
        long tickAmount;
        boolean flag = false;
        if (this.resourceGenerationTime > 0L && this.generationSpeed > 0.0) {
            tickAmount = this.getResourceGenerationTickAmount();
            this.resourceGenerationTime = Math.max(0L, this.resourceGenerationTime - tickAmount);
            flag = true;
        }
        if (this.breedTime > 0L && this.breedSpeed > 0.0) {
            tickAmount = this.getBreedTickAmount();
            this.breedTime = Math.max(0L, this.breedTime - tickAmount);
            flag = true;
        }
        if (this.feedTime > 0L && this.feedSpeed > 0.0) {
            tickAmount = this.getFeedTickAmount();
            this.feedTime = Math.max(0L, this.feedTime - tickAmount);
            flag = true;
        }
        return flag;
    }

    private boolean applyActiveModifiers(ServerLevel level) {
        double generationSpeed = 0.1;
        double feedSpeed = 0.0;
        double breedSpeed = 0.0;
        boolean enableMobResources = false;
        boolean enableMobBreeding = false;
        for (AquariumModifier aquariumModifier : this.resolveModifiers(level.m_5962_(), this.activePredicate).values()) {
            if (this.tankStatus.isActive()) {
                generationSpeed += aquariumModifier.getSettings().getGenerationSpeed();
                enableMobResources |= aquariumModifier.getSettings().isEnableMobResources();
            }
            if (this.feedStatus.isActive()) {
                feedSpeed += aquariumModifier.getSettings().getFeedSpeed();
            }
            if (!this.breedStatus.isActive()) continue;
            breedSpeed += aquariumModifier.getSettings().getBreedSpeed();
            enableMobBreeding |= aquariumModifier.getSettings().isEnableMobBreeding();
        }
        for (IAxolootl iAxolootl : this.resolveAxolootls(level)) {
            if (this.tankStatus.isActive()) {
                generationSpeed += iAxolootl.getGenerationSpeed();
            }
            if (this.feedStatus.isActive()) {
                feedSpeed += iAxolootl.getFeedSpeed();
            }
            if (!this.breedStatus.isActive()) continue;
            breedSpeed += iAxolootl.getBreedSpeed();
        }
        boolean isDirty = ControllerBlockEntity.notEquals(this.generationSpeed, generationSpeed) || ControllerBlockEntity.notEquals(this.feedSpeed, feedSpeed) || ControllerBlockEntity.notEquals(this.breedSpeed, breedSpeed) || this.enableMobResources != enableMobResources || this.enableMobBreeding != enableMobBreeding;
        this.generationSpeed = generationSpeed;
        this.feedSpeed = feedSpeed;
        this.breedSpeed = breedSpeed;
        this.enableMobResources = enableMobResources;
        this.enableMobBreeding = enableMobBreeding;
        return isDirty;
    }

    private boolean hasMandatoryModifiers(RegistryAccess registryAccess, boolean requireActive) {
        Set<TagKey<AquariumModifier>> mandatoryModifiers = AxRegistry.AquariumModifiersReg.getMandatoryAquariumModifiers(registryAccess);
        if (!mandatoryModifiers.isEmpty() && this.activeAquariumModifiers.isEmpty()) {
            return false;
        }
        for (TagKey tagKey : mandatoryModifiers) {
            if (this.hasAnyModifier(registryAccess, (TagKey<AquariumModifier>)tagKey, requireActive)) continue;
            return false;
        }
        return true;
    }

    private boolean hasAnyModifier(RegistryAccess registryAccess, TagKey<AquariumModifier> modifierTagId, boolean requireActive) {
        for (Map.Entry<BlockPos, ResourceLocation> entry : this.aquariumModifiers.entrySet()) {
            AquariumModifier modifier = (AquariumModifier)AquariumModifier.getRegistry(registryAccess).m_7745_(entry.getValue());
            if (modifier == null || !modifier.is(registryAccess, modifierTagId) || requireActive && !this.activeAquariumModifiers.contains(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private boolean generateResources(ServerLevel level) {
        if (this.resourceGenerationTime > 0L || !(this.generationSpeed > 0.0)) {
            return false;
        }
        ArrayList<ItemStack> resources = new ArrayList<ItemStack>();
        HashSet<UUID> invalid = new HashSet<UUID>();
        Collection<IAxolootl> axolootls = this.resolveAxolootls(level, i -> !i.getEntity().m_6162_());
        for (IAxolootl entry : axolootls) {
            if (!entry.isResourceGenerationCandidate(level)) continue;
            Optional<AxolootlVariant> oVariant = entry.getAxolootlVariant(level.m_5962_());
            if (oVariant.isEmpty()) {
                invalid.add(entry.getEntity().m_20148_());
                continue;
            }
            int cost = oVariant.get().getEnergyCost();
            ResourceGenerator gen = (ResourceGenerator)oVariant.get().getResourceGenerator().m_203334_();
            if (gen.is(ResourceTypes.MOB) && !this.enableMobResources) continue;
            Collection<ItemStack> generatedResources = gen.getRandomEntries(entry.getEntity(), entry.getEntity().m_217043_());
            if (!generatedResources.isEmpty() && cost > 0 && this.transferEnergy((Level)level, this.m_58899_(), cost, true) < cost) break;
            resources.addAll(generatedResources);
        }
        invalid.forEach(uuid -> this.trackedAxolootls.remove(uuid));
        this.resourceGenerationTime = resources.isEmpty() ? 10000L : (Long)Axolootl.CONFIG.BASE_GENERATION_PERIOD.get() * 100L;
        Collection<ItemStack> remainder = this.insertItems(resources, false);
        return !invalid.isEmpty();
    }

    public ItemStack insertItem(ItemStack itemStack, boolean simulate) {
        Collection<ItemStack> remainder = this.insertItems((Collection<ItemStack>)ImmutableList.of((Object)itemStack), simulate);
        if (remainder.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return remainder.iterator().next();
    }

    public Collection<ItemStack> insertItems(Collection<ItemStack> itemStacks, boolean simulate) {
        Collection<ItemStack> remainder = this.insertResources(itemStacks, simulate);
        if (!simulate) {
            this.isOutputFull = !remainder.isEmpty();
        }
        return remainder;
    }

    private ItemStack insertResource(ItemStack itemStack, boolean simulate) {
        Collection<ItemStack> remainder = this.insertResources((Collection<ItemStack>)ImmutableList.of((Object)itemStack), simulate);
        if (remainder.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return remainder.iterator().next();
    }

    private Collection<ItemStack> insertResources(Collection<ItemStack> itemStacks, boolean simulate) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(itemStacks);
        for (BlockPos pos : this.getResourceOutputs()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (blockEntity == null) continue;
            Optional capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
            capability.ifPresent(c -> {
                int n = itemStackList.size();
                for (int i = 0; i < n; ++i) {
                    ItemStack itemStack = (ItemStack)itemStackList.get(i);
                    if (itemStack.m_41619_()) continue;
                    itemStackList.set(i, ItemHandlerHelper.insertItemStacked((IItemHandler)c, (ItemStack)itemStack, (boolean)simulate));
                }
            });
            itemStackList.removeIf(ItemStack::m_41619_);
            if (!itemStackList.isEmpty()) continue;
            return itemStackList;
        }
        return itemStackList;
    }

    private boolean feed(ServerLevel level) {
        if (this.feedTime > 0L || !(this.feedSpeed > 0.0)) {
            return false;
        }
        if (this.trackedAxolootls.size() < 1) {
            return false;
        }
        Collection<IAxolootl> axolootls = this.resolveAxolootls(level);
        Map<BlockPos, AquariumModifier> modifiers = this.resolveModifiers(level.m_5962_(), this.activePredicate.and((b, a) -> a.getSettings().getFeedSpeed() > 0.0));
        ImmutableMap.Builder itemHandlerBuilder = ImmutableMap.builder();
        for (BlockPos entry : modifiers.keySet()) {
            BlockEntity blockEntity = level.m_7702_(entry);
            if (blockEntity == null) continue;
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> itemHandlerBuilder.put((Object)entry, handler));
        }
        ImmutableMap itemHandlers = itemHandlerBuilder.build();
        if (itemHandlers.isEmpty()) {
            this.setFeedInputEmpty(true);
            return true;
        }
        boolean hasFed = false;
        boolean nonEmpty = false;
        int feedCandidates = 0;
        for (IAxolootl axolootl : axolootls) {
            if (!axolootl.isFeedCandidate(level)) continue;
            for (IItemHandler handler2 : itemHandlers.values()) {
                InteractionResultHolder<Boolean> result = this.feed(level, handler2, axolootl);
                nonEmpty |= ((Boolean)result.m_19095_()).booleanValue();
                if (!result.m_19089_().m_19077_()) continue;
                hasFed = true;
                break;
            }
            ++feedCandidates;
        }
        this.setFeedInputEmpty(feedCandidates > 0 && !nonEmpty);
        this.feedTime = hasFed ? (Long)Axolootl.CONFIG.BASE_FEEDING_PERIOD.get() * 100L : 20000L;
        return true;
    }

    private InteractionResultHolder<Boolean> feed(ServerLevel level, IItemHandler handler, IAxolootl axolootl) {
        int emptySlots = 0;
        int n = handler.getSlots();
        for (int i = 0; i < n; ++i) {
            if (handler.extractItem(i, 1, true).m_41619_()) {
                ++emptySlots;
                continue;
            }
            ItemStack food = handler.getStackInSlot(i).m_41777_().m_41620_(1);
            InteractionResult result = axolootl.feed(level, food);
            if (!result.m_19077_()) continue;
            axolootl.getEntity().m_5496_(SoundEvents.f_11912_, 2.0f, axolootl.getEntity().m_6100_());
            handler.extractItem(i, 1, false);
            return new InteractionResultHolder(result, (Object)true);
        }
        return InteractionResultHolder.m_19098_((Object)(emptySlots < handler.getSlots() ? 1 : 0));
    }

    private boolean breed(ServerLevel level) {
        if (this.breedTime > 0L || !(this.breedSpeed > 0.0)) {
            return false;
        }
        int capacity = ControllerBlockEntity.calculateMaxCapacity(this.size);
        if (this.trackedAxolootls.size() < 2 || this.trackedAxolootls.size() + 1 > capacity) {
            return false;
        }
        List axolootls = Util.m_214661_(this.resolveAxolootls(level, a -> this.enableMobBreeding || !a.getAxolootlVariant(level.m_5962_()).orElse(AxolootlVariant.EMPTY).hasMobResources()).stream(), (RandomSource)level.m_213780_());
        Map<BlockPos, AquariumModifier> modifiers = this.resolveModifiers(level.m_5962_(), this.activePredicate.and((b, a) -> a.getSettings().getBreedSpeed() > 0.0 || a.getSettings().isEnableMobBreeding()));
        ImmutableMap.Builder itemHandlerBuilder = ImmutableMap.builder();
        for (BlockPos entry : modifiers.keySet()) {
            BlockEntity blockEntity = level.m_7702_(entry);
            if (blockEntity == null) continue;
            blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> itemHandlerBuilder.put((Object)entry, handler));
        }
        ImmutableMap itemHandlers = itemHandlerBuilder.build();
        if (itemHandlers.isEmpty()) {
            this.setBreedInputEmpty(true);
            return true;
        }
        int breedCount = 0;
        boolean nonEmpty = false;
        int breedCandidates = 0;
        int n = axolootls.size();
        for (int i = 0; i < n && breedCount + n < capacity; ++i) {
            IAxolootl axolootl = (IAxolootl)axolootls.get(i);
            Optional<IAxolootl> oAxolootl = Optional.of(axolootl);
            if (!axolootl.isBreedCandidate(level, Optional.empty())) continue;
            for (int j = i + 1; j < n; ++j) {
                IAxolootl other = (IAxolootl)axolootls.get(j);
                if (axolootl == other || !other.isBreedCandidate(level, oAxolootl)) continue;
                InteractionResultHolder<Boolean> result = this.breed(level, (Map<BlockPos, IItemHandler>)itemHandlers, axolootl, other);
                nonEmpty |= ((Boolean)result.m_19095_()).booleanValue();
                if (!result.m_19089_().m_19077_()) continue;
                ++breedCount;
                break;
            }
            ++breedCandidates;
        }
        this.setBreedInputEmpty(breedCandidates > 0 && !nonEmpty);
        this.breedTime = breedCount > 0 ? (Long)Axolootl.CONFIG.BASE_BREEDING_PERIOD.get() * 100L : 40000L;
        return true;
    }

    private InteractionResultHolder<Boolean> breed(ServerLevel level, Map<BlockPos, IItemHandler> handlers, IAxolootl axolootl, IAxolootl other) {
        Optional<IAxolootl> oChild;
        ItemStack food2;
        AxolootlVariant variant1 = axolootl.getAxolootlVariant(level.m_5962_()).orElse(AxolootlVariant.EMPTY);
        AxolootlVariant variant2 = other.getAxolootlVariant(level.m_5962_()).orElse(AxolootlVariant.EMPTY);
        HolderSet<Item> breedFood1 = variant1.getBreedFood().get((Registry<Item>)Registry.f_122827_);
        HolderSet<Item> breedFood2 = variant2.getBreedFood().get((Registry<Item>)Registry.f_122827_);
        IItemHandler handler1 = null;
        IItemHandler handler2 = null;
        int slot1 = -1;
        int slot2 = -1;
        for (IItemHandler handler : handlers.values()) {
            Tuple<Integer, Integer> result = this.findItems(level, handler, breedFood1, breedFood2);
            if (slot1 < 0 && (Integer)result.m_14418_() >= 0) {
                handler1 = handler;
                slot1 = (Integer)result.m_14418_();
            }
            if (slot2 < 0 && (Integer)result.m_14419_() >= 0) {
                handler2 = handler;
                slot2 = (Integer)result.m_14419_();
            }
            if (slot1 < 0 || slot2 < 0) continue;
            break;
        }
        if (null == handler1 || null == handler2) {
            return InteractionResultHolder.m_19098_((Object)true);
        }
        ItemStack food1 = handler1.extractItem(slot1, 1, false);
        if (food1.m_41619_() || (food2 = handler2.extractItem(slot2, 1, false)).m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)false);
        }
        ItemStack remainder1 = food1.getCraftingRemainingItem();
        ItemStack remainder2 = food2.getCraftingRemainingItem();
        if (!remainder1.m_41619_()) {
            this.insertItem(remainder1, false);
        }
        if (!remainder2.m_41619_()) {
            this.insertItem(remainder2, false);
        }
        if ((oChild = axolootl.breed(level, other, this.enableMobBreeding)).isEmpty() || oChild.get().getAxolootlVariantId().isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)(slot1 < 0 && slot2 < 0 ? 1 : 0));
        }
        this.trackedAxolootls.put(oChild.get().getEntity().m_20148_(), oChild.get().getAxolootlVariantId().get());
        this.forceCalculateBonuses();
        return InteractionResultHolder.m_19090_((Object)true);
    }

    private Tuple<Integer, Integer> findItems(ServerLevel level, IItemHandler handler, HolderSet<Item> left, HolderSet<Item> right) {
        int slotLeft = -1;
        int slotRight = -1;
        int n = handler.getSlots();
        for (int i = 0; i < n; ++i) {
            if (handler.extractItem(i, 1, true).m_41619_()) continue;
            ItemStack food = handler.getStackInSlot(i).m_41777_().m_41620_(1);
            if (slotLeft < 0 && left.m_203333_(food.m_220173_())) {
                slotLeft = i;
            }
            if (slotRight < 0 && right.m_203333_(food.m_220173_())) {
                slotRight = i;
            }
            if (slotLeft >= 0 && slotRight >= 0) break;
        }
        return new Tuple((Object)slotLeft, (Object)slotRight);
    }

    private boolean iterateOutside(ServerLevel level, int blocksToCheck) {
        if (null == this.outsideIterator || null == this.size) {
            return false;
        }
        int blocksChecked = 0;
        boolean isDirty = false;
        while (this.outsideIterator.hasNext() && blocksChecked++ < blocksToCheck) {
            BlockPos pos = this.outsideIterator.next();
            if (!this.m_58899_().equals((Object)pos) && level.m_7702_(pos) instanceof ControllerBlockEntity) {
                this.isDuplicateFound = true;
                this.setSize(null);
                return true;
            }
            if (!TankMultiblock.AQUARIUM.isTankBlock((LevelAccessor)level, pos)) {
                this.setSize(null);
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            Optional<IAquariumTab> oTab = IAquariumTab.forBlock((LevelAccessor)level, pos, blockState);
            if (!oTab.isPresent()) continue;
            isDirty |= this.startTrackingBlock(level, AxRegistry.AQUARIUM_TABS_SUPPLIER.get().getKey((Object)oTab.get()), pos);
        }
        if (!this.outsideIterator.hasNext() && this.size != null) {
            this.outsideIterator = this.size.outerPositions().iterator();
        }
        return isDirty;
    }

    private boolean iterateInside(ServerLevel level, int blocksToCheck) {
        if (null == this.insideIterator || null == this.size) {
            return false;
        }
        int blocksChecked = 0;
        boolean isDirty = false;
        while (this.insideIterator.hasNext() && blocksChecked++ < blocksToCheck) {
            BlockState blockState;
            Optional<IAquariumTab> oTab;
            BlockPos pos = this.insideIterator.next();
            Optional<AquariumModifier> oModifier = AquariumModifier.forBlock((LevelAccessor)level, pos);
            if (oModifier.isPresent()) {
                ResourceLocation name = oModifier.get().getRegistryName(level.m_5962_());
                isDirty |= !this.aquariumModifiers.containsKey(pos) || !this.aquariumModifiers.get(pos).equals((Object)name);
                this.aquariumModifiers.put(pos.m_7949_(), name);
                IAquariumControllerProvider.trySetController((Level)level, pos, this);
            }
            if (!(oTab = IAquariumTab.forBlock((LevelAccessor)level, pos, blockState = level.m_8055_(pos))).isPresent()) continue;
            isDirty |= this.startTrackingBlock(level, AxRegistry.AQUARIUM_TABS_SUPPLIER.get().getKey((Object)oTab.get()), pos);
        }
        if (!this.insideIterator.hasNext() && this.size != null) {
            this.insideIterator = this.size.innerPositions().iterator();
        }
        if (isDirty) {
            this.forceCalculateBonuses = true;
            return true;
        }
        return false;
    }

    public boolean findAxolootls(ServerLevel level) {
        if (null == this.size) {
            return false;
        }
        if (!this.forceCalculateAxolootls && level.m_46467_() % 150L != 0L) {
            return false;
        }
        this.forceCalculateAxolootls = false;
        AABB aabb = this.size.aabb();
        List list = level.m_6443_(LivingEntity.class, aabb, entity -> {
            if (!(entity instanceof IAxolootl)) return false;
            IAxolootl iAxolootl = (IAxolootl)entity;
            if (this.trackedAxolootls.containsKey(entity.m_20148_())) return false;
            if (!iAxolootl.getAxolootlVariantId().isPresent()) return false;
            if (!AxRegistry.AxolootlVariantsReg.isValid(iAxolootl.getAxolootlVariantId().get())) return false;
            return true;
        });
        list.forEach(e -> {
            this.trackedAxolootls.put(e.m_20148_(), ((IAxolootl)e).getAxolootlVariantId().get());
            IAquariumControllerProvider.trySetController((Entity)e, (Level)level, this);
        });
        if (!list.isEmpty()) {
            this.forceCalculateBonuses = true;
            return true;
        }
        return false;
    }

    private boolean validateAxolootls(ServerLevel level) {
        if (null == this.size) {
            return false;
        }
        if (level.m_46467_() % 30L != 0L) {
            return false;
        }
        HashSet<UUID> invalid = new HashSet<UUID>();
        AABB bounds = this.size.aabb();
        for (UUID uuid2 : this.trackedAxolootls.keySet()) {
            Entity entity = level.m_8791_(uuid2);
            if (null != entity && bounds.m_82381_(entity.m_20191_())) continue;
            invalid.add(uuid2);
            IAquariumControllerProvider.tryClearController(entity);
        }
        invalid.forEach(uuid -> this.trackedAxolootls.remove(uuid));
        if (!invalid.isEmpty()) {
            this.forceCalculateBonuses = true;
            return true;
        }
        return false;
    }

    private boolean validateTrackedBlocks(ServerLevel level) {
        ArrayList<ResourceLocation> keySet = new ArrayList<ResourceLocation>(this.trackedBlocks.keySet());
        keySet.sort(ResourceLocation::compareNamespaced);
        int index = (int)(level.m_46467_() % (long)Math.max(this.trackedBlocks.size() + 1, 40));
        if (index < 0 || index >= keySet.size()) {
            return false;
        }
        ResourceLocation category = (ResourceLocation)keySet.get(index);
        IAquariumTab tab = (IAquariumTab)AxRegistry.AQUARIUM_TABS_SUPPLIER.get().getValue(category);
        if (null == tab) {
            return false;
        }
        Set<BlockPos> invalid = this.invalidateBlocks(level, this.getTrackedBlocksRaw((ResourceLocation)keySet.get(index)), p -> tab.isFor((LevelAccessor)level, (BlockPos)p, level.m_8055_(p)));
        invalid.forEach(p -> this.stopTrackingBlock(level, category, (BlockPos)p));
        return !invalid.isEmpty();
    }

    private Set<BlockPos> invalidateBlocks(ServerLevel level, Set<BlockPos> positions, Predicate<BlockPos> predicate) {
        HashSet<BlockPos> invalid = new HashSet<BlockPos>();
        for (BlockPos p : positions) {
            if (predicate.test(p)) continue;
            invalid.add(p);
        }
        return invalid;
    }

    private boolean validateUpdateModifiers(ServerLevel level) {
        boolean isDirty;
        if (level.m_46467_() % 51L != 0L) {
            return false;
        }
        HashSet<BlockPos> invalid = new HashSet<BlockPos>();
        HashSet<BlockPos> active = new HashSet<BlockPos>();
        Set<BlockPos> wasActive = this.getActiveAquariumModifiers();
        Collection<IAxolootl> axolootls = this.resolveAxolootls(level);
        ImmutableMap modifierMap = ImmutableMap.copyOf(this.resolveModifiers(level.m_5962_()));
        for (Map.Entry entry : modifierMap.entrySet()) {
            if (((AquariumModifier)entry.getValue()).isApplicable(level, (BlockPos)entry.getKey())) {
                AquariumModifierContext context = new AquariumModifierContext((LevelAccessor)level, (BlockPos)entry.getKey(), this.size, axolootls, (Map<BlockPos, AquariumModifier>)modifierMap, wasActive);
                if (!((AquariumModifier)entry.getValue()).isActive(context)) continue;
                active.add((BlockPos)entry.getKey());
                ((AquariumModifier)entry.getValue()).checkAndSpread(context);
                continue;
            }
            invalid.add((BlockPos)entry.getKey());
            IAquariumControllerProvider.tryClearController((Level)level, (BlockPos)entry.getKey());
        }
        invalid.forEach(p -> this.aquariumModifiers.remove(p));
        boolean bl = isDirty = !invalid.isEmpty();
        if (!this.activeAquariumModifiers.equals(active)) {
            this.activeAquariumModifiers.clear();
            this.activeAquariumModifiers.addAll(active);
            this.forceCalculateBonuses();
            isDirty = true;
        }
        return isDirty;
    }

    private boolean distributeEnergyToModifiers(Level level) {
        ArrayList<Map.Entry<BlockPos, AquariumModifier>> modifiers = new ArrayList<Map.Entry<BlockPos, AquariumModifier>>(this.resolveModifiers(level.m_5962_(), this.activePredicate.and((b, a) -> a.getSettings().getEnergyCost() > 0)).entrySet());
        Comparator<Map.Entry> comparator = Comparator.comparingInt(e -> ((AquariumModifier)e.getValue()).getSettings().getEnergyCost());
        modifiers.sort(comparator.reversed());
        if (modifiers.isEmpty()) {
            return false;
        }
        Map<BlockPos, IEnergyStorage> energyHandlers = this.resolveEnergyStorage(IEnergyStorage::canExtract);
        boolean hasPowered = false;
        for (Map.Entry entry : modifiers) {
            int cost = ((AquariumModifier)entry.getValue()).getSettings().getEnergyCost();
            int depleted = 0;
            boolean isVoid = ((AquariumModifier)entry.getValue()).getSettings().isGreedyEnergy();
            for (IEnergyStorage energyStorage : energyHandlers.values()) {
                if ((depleted += this.transferEnergy(level, energyStorage, (BlockPos)entry.getKey(), cost, isVoid)) < cost) continue;
                hasPowered = true;
                break;
            }
            if (depleted >= cost) continue;
            this.setInsufficientPower(true);
            this.aquariumModifiers.remove(entry.getKey());
            this.activeAquariumModifiers.remove(entry.getKey());
            IAquariumControllerProvider.tryClearController(level, (BlockPos)entry.getKey());
            this.forceCalculateBonuses();
            return true;
        }
        this.setInsufficientPower(false);
        return false;
    }

    private int transferEnergy(Level level, BlockPos targetPos, int maxAmount, boolean useVoidStorage) {
        IEnergyStorage energyStorage;
        HashMap<BlockPos, IEnergyStorage> energyHandlers = new HashMap<BlockPos, IEnergyStorage>();
        for (BlockPos entry : this.getEnergyInputs()) {
            IEnergyStorage storage = this.resolveEnergyStorageOrVoid(level, entry, false);
            if (!storage.canExtract()) continue;
            energyHandlers.put(entry, storage);
        }
        int depleted = 0;
        Iterator iterator = energyHandlers.values().iterator();
        while (iterator.hasNext() && (depleted += this.transferEnergy(level, energyStorage = (IEnergyStorage)iterator.next(), targetPos, maxAmount - depleted, useVoidStorage)) < maxAmount) {
        }
        if (depleted < maxAmount) {
            this.setInsufficientPower(true);
            this.forceCalculateBonuses();
        }
        return depleted;
    }

    private int transferEnergy(Level level, IEnergyStorage energyStorage, BlockPos receiverPos, int maxAmount, boolean useVoidStorage) {
        int amount = Math.min(maxAmount, energyStorage.extractEnergy(maxAmount, true));
        if (amount <= 0) {
            return 0;
        }
        IEnergyStorage receiverStorage = this.resolveEnergyStorageOrVoid(level, receiverPos, useVoidStorage);
        if (!receiverStorage.canReceive() || receiverStorage.receiveEnergy(amount, true) <= 0) {
            return 0;
        }
        return energyStorage.extractEnergy(receiverStorage.receiveEnergy(amount, false), false);
    }

    private IEnergyStorage resolveEnergyStorageOrVoid(Level level, BlockPos pos, boolean useVoidStorage) {
        BlockEntity blockEntity;
        if (useVoidStorage || null == (blockEntity = level.m_7702_(pos))) {
            return VoidEnergyStorage.INSTANCE;
        }
        Optional oStorage = blockEntity.getCapability(ForgeCapabilities.ENERGY).resolve();
        if (oStorage.isPresent() && ((IEnergyStorage)oStorage.get()).canReceive()) {
            return (IEnergyStorage)oStorage.get();
        }
        return VoidEnergyStorage.INSTANCE;
    }

    public void onRemoved() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.clearAllData(level2);
        }
    }

    private void clearAllData(ServerLevel level) {
        for (BlockPos blockPos : this.aquariumModifiers.keySet()) {
            IAquariumControllerProvider.tryClearController((Level)level, blockPos);
        }
        for (Set set : this.trackedBlocks.values()) {
            for (BlockPos p : set) {
                IAquariumControllerProvider.tryClearController((Level)level, p);
            }
        }
        for (IAxolootl iAxolootl : this.resolveAxolootls(level)) {
            IAquariumControllerProvider.tryClearController((Entity)iAxolootl.getEntity());
        }
        this.tankStatus = TankStatus.INCOMPLETE;
        this.trackedBlocks.clear();
        this.trackedAxolootls.clear();
        this.aquariumModifiers.clear();
        this.activeAquariumModifiers.clear();
        this.insideIterator = null;
        this.outsideIterator = null;
    }

    private boolean updateStatus(ServerLevel level) {
        FeedStatus feedStatus;
        BreedStatus breedStatus;
        TankStatus tankStatus = this.updateTankStatus(level);
        if (!tankStatus.isActive()) {
            breedStatus = BreedStatus.INACTIVE;
            feedStatus = FeedStatus.INACTIVE;
        } else {
            Map<BlockPos, AquariumModifier> modifiers = this.resolveModifiers(level.m_5962_(), this.activePredicate);
            breedStatus = this.updateBreedStatus(level, modifiers);
            feedStatus = this.updateFeedStatus(level, modifiers);
        }
        boolean isDirty = tankStatus != this.tankStatus || breedStatus != this.breedStatus || feedStatus != this.feedStatus;
        this.tankStatus = tankStatus;
        this.breedStatus = breedStatus;
        this.feedStatus = feedStatus;
        this.forceCalculateBonuses |= isDirty;
        return isDirty;
    }

    private TankStatus updateTankStatus(ServerLevel level) {
        if (this.isDuplicateFound) {
            return TankStatus.DUPLICATE_CONTROLLERS;
        }
        if (null == this.size) {
            return TankStatus.INCOMPLETE;
        }
        if (!this.hasMandatoryModifiers(level.m_5962_(), true)) {
            return TankStatus.MISSING_MODIFIERS;
        }
        if (this.generationSpeed < 0.0 || this.feedSpeed < 0.0 || this.breedSpeed < 0.0) {
            return TankStatus.POOR_CONDITIONS;
        }
        if (this.isInsufficientPower()) {
            return TankStatus.LOW_ENERGY;
        }
        if (this.trackedAxolootls.size() > ControllerBlockEntity.calculateMaxCapacity(this.size)) {
            return TankStatus.OVERCROWDED;
        }
        if (this.getResourceOutputs().isEmpty() || this.isOutputFull()) {
            return TankStatus.STORAGE_FULL;
        }
        return TankStatus.ACTIVE;
    }

    private FeedStatus updateFeedStatus(ServerLevel level, Map<BlockPos, AquariumModifier> activeModifiers) {
        if (this.isFeedInputEmpty()) {
            return FeedStatus.MISSING_RESOURCES;
        }
        double feedSpeed = 0.0;
        for (AquariumModifier modifier : activeModifiers.values()) {
            feedSpeed += modifier.getSettings().getFeedSpeed();
        }
        if (feedSpeed > 0.0) {
            if (this.isFeedInputEmpty()) {
                return FeedStatus.MISSING_RESOURCES;
            }
            return FeedStatus.ACTIVE;
        }
        return FeedStatus.INACTIVE;
    }

    private BreedStatus updateBreedStatus(ServerLevel level, Map<BlockPos, AquariumModifier> activeModifiers) {
        double breedSpeed = 0.0;
        boolean mobBreeding = false;
        for (AquariumModifier modifier : activeModifiers.values()) {
            breedSpeed += modifier.getSettings().getBreedSpeed();
            mobBreeding |= modifier.getSettings().isEnableMobBreeding();
        }
        if (breedSpeed > 0.0) {
            if (this.isBreedInputEmpty()) {
                return BreedStatus.MISSING_RESOURCES;
            }
            if (this.trackedAxolootls.size() >= ControllerBlockEntity.calculateMaxCapacity(this.size)) {
                return BreedStatus.MAX_COUNT;
            }
            int mobVariants = (int)this.resolveAxolootlVariants(level.m_5962_()).values().stream().filter(AxolootlVariant::hasMobResources).count();
            int resourceVariants = this.trackedAxolootls.size() - mobVariants;
            if (mobBreeding) {
                if (this.trackedAxolootls.size() < 2) {
                    return BreedStatus.MIN_COUNT;
                }
                return BreedStatus.ACTIVE;
            }
            if (resourceVariants < 2) {
                return BreedStatus.MIN_COUNT;
            }
            return BreedStatus.RESOURCE_MOB_ONLY;
        }
        return BreedStatus.INACTIVE;
    }

    public void setSize(@Nullable TankMultiblock.Size size) {
        if (Objects.equals(this.size, size)) {
            return;
        }
        this.size = size;
        if (size != null) {
            this.isDuplicateFound = false;
            this.insideIterator = size.innerPositions().iterator();
            this.outsideIterator = size.outerPositions().iterator();
            this.forceCalculateBonuses = true;
            this.forceCalculateAxolootls = true;
        } else {
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                this.clearAllData(level2);
            }
        }
        if (this.f_58857_ != null) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public Optional<TankMultiblock.Size> getSize() {
        return Optional.ofNullable(this.size);
    }

    public void forceCalculateBonuses() {
        this.forceCalculateBonuses = true;
    }

    public void forceCalculateAxolootls() {
        this.forceCalculateAxolootls = true;
    }

    public boolean isOutputFull() {
        return this.isOutputFull;
    }

    public boolean isInsufficientPower() {
        return this.isInsufficientPower;
    }

    public void setInsufficientPower(boolean insufficientPower) {
        if (this.isInsufficientPower != insufficientPower) {
            this.m_6596_();
        }
        this.isInsufficientPower = insufficientPower;
    }

    public boolean isFeedInputEmpty() {
        return this.isFeedInputEmpty;
    }

    public boolean isBreedInputEmpty() {
        return this.isBreedInputEmpty;
    }

    public void setFeedInputEmpty(boolean feedInputEmpty) {
        if (this.isFeedInputEmpty != feedInputEmpty) {
            this.m_6596_();
        }
        this.isFeedInputEmpty = feedInputEmpty;
    }

    public void setBreedInputEmpty(boolean breedInputEmpty) {
        if (this.isBreedInputEmpty != breedInputEmpty) {
            this.m_6596_();
        }
        this.isBreedInputEmpty = breedInputEmpty;
    }

    public TankStatus getTankStatus() {
        return this.tankStatus;
    }

    public BreedStatus getBreedStatus() {
        return this.breedStatus;
    }

    public FeedStatus getFeedStatus() {
        return this.feedStatus;
    }

    public double getGenerationSpeed() {
        return this.generationSpeed;
    }

    public double getBreedSpeed() {
        return this.breedSpeed;
    }

    public double getFeedSpeed() {
        return this.feedSpeed;
    }

    public boolean enableMobResources() {
        return this.enableMobResources;
    }

    public boolean enableMobBreeding() {
        return this.enableMobBreeding;
    }

    public long getResourceGenerationTime() {
        return this.resourceGenerationTime;
    }

    public long getBreedTime() {
        return this.breedTime;
    }

    public long getFeedTime() {
        return this.feedTime;
    }

    public long estimateRemainingFeedTime() {
        if (!this.feedStatus.isActive() || !(this.feedSpeed > 0.0)) {
            return -1L;
        }
        return (long)Math.floor((double)this.feedTime / (this.feedSpeed * 100.0));
    }

    public long estimateRemainingBreedTime() {
        if (!this.breedStatus.isActive() || !(this.breedSpeed > 0.0)) {
            return -1L;
        }
        return (long)Math.floor((double)this.breedTime / (this.breedSpeed * 100.0));
    }

    public long estimateRemainingResourceGenerationTime() {
        if (!this.tankStatus.isActive() || !(this.generationSpeed > 0.0)) {
            return -1L;
        }
        return (long)Math.floor((double)this.resourceGenerationTime / (this.generationSpeed * 100.0));
    }

    public Set<BlockPos> getAxolootlInputs() {
        return Collections.unmodifiableSet(this.getTrackedBlocks(AxRegistry.AquariumTabsReg.AXOLOOTL_INTERFACE.getId()));
    }

    public Set<BlockPos> getFluidInputs() {
        return this.getTrackedBlocks(AxRegistry.AquariumTabsReg.FLUID_INTERFACE.getId());
    }

    public Set<BlockPos> getTrackedBlocks(IAquariumTab category) {
        return this.getTrackedBlocks(AxRegistry.AQUARIUM_TABS_SUPPLIER.get().getKey((Object)category));
    }

    public Set<BlockPos> getTrackedBlocks(ResourceLocation category) {
        return Collections.unmodifiableSet(this.trackedBlocks.getOrDefault(category, (Set<BlockPos>)ImmutableSet.of()));
    }

    private Set<BlockPos> getTrackedBlocksRaw(ResourceLocation category) {
        if (!this.trackedBlocks.containsKey(category)) {
            this.trackedBlocks.put(category, new HashSet());
        }
        return this.trackedBlocks.get(category);
    }

    public boolean startTrackingBlock(ServerLevel level, ResourceLocation category, BlockPos pos) {
        if (null == category) {
            return false;
        }
        Set<BlockPos> set = this.getTrackedBlocksRaw(category);
        if (set.contains(pos)) {
            return false;
        }
        set.add(pos.m_7949_());
        IAquariumControllerProvider.trySetController((Level)level, pos, this);
        return true;
    }

    public boolean stopTrackingBlock(ServerLevel level, ResourceLocation category, BlockPos pos) {
        if (null == category) {
            return false;
        }
        Set<BlockPos> set = this.getTrackedBlocksRaw(category);
        if (!set.remove(pos)) {
            return false;
        }
        IAquariumControllerProvider.tryClearController((Level)level, pos);
        return true;
    }

    public Set<BlockPos> getEnergyInputs() {
        return this.getTrackedBlocks(AxRegistry.AquariumTabsReg.ENERGY_INTERFACE.getId());
    }

    public Set<BlockPos> getResourceOutputs() {
        return this.getTrackedBlocks(AxRegistry.AquariumTabsReg.OUTPUT.getId());
    }

    public Map<BlockPos, ResourceLocation> getAquariumModifiers() {
        return ImmutableMap.copyOf(this.aquariumModifiers);
    }

    public Set<BlockPos> getActiveAquariumModifiers() {
        return ImmutableSet.copyOf(this.activeAquariumModifiers);
    }

    public Map<UUID, ResourceLocation> getTrackedAxolootls() {
        return ImmutableMap.copyOf(this.trackedAxolootls);
    }

    public long getResourceGenerationTickAmount() {
        return Mth.m_14107_((double)(100.0 * this.generationSpeed));
    }

    public long getBreedTickAmount() {
        return Mth.m_14107_((double)(100.0 * this.breedSpeed));
    }

    public long getFeedTickAmount() {
        return Mth.m_14107_((double)(100.0 * this.feedSpeed));
    }

    public ItemStack removeAxolootl(ServerLevel level, UUID uuid) {
        IAxolootl iprovider;
        ResourceLocation id = this.trackedAxolootls.remove(uuid);
        if (null == id) {
            return ItemStack.f_41583_;
        }
        Entity entity = level.m_8791_(uuid);
        if (!(entity instanceof IAxolootl) || (iprovider = (IAxolootl)entity).getEntity().m_21224_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = iprovider.asItemStack();
        iprovider.getEntity().m_146870_();
        this.forceCalculateBonuses();
        this.m_6596_();
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        return itemStack;
    }

    public boolean addAxolootl(ServerLevel level, IAxolootl iaxolootl) {
        UUID uuid = iaxolootl.getEntity().m_20148_();
        Optional<ResourceLocation> oId = iaxolootl.getAxolootlVariantId();
        if (oId.isEmpty() || !AxRegistry.AxolootlVariantsReg.isValid(oId.get())) {
            return false;
        }
        this.trackedAxolootls.put(uuid, oId.get());
        this.forceCalculateBonuses();
        this.m_6596_();
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        return true;
    }

    public Optional<BlockPos> findSpawnablePosition(ServerLevel level, RandomSource random) {
        if (!this.hasTank()) {
            return Optional.empty();
        }
        Vec3i dimensions = this.size.getDimensions();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int attempts = Math.max(1, (int)(this.size.getInnerVolume() / 10L));
        while (attempts-- > 0) {
            pos.m_122154_((Vec3i)this.size.getOrigin(), 1 + random.m_188503_(dimensions.m_123341_() - 2), 1 + random.m_188503_(dimensions.m_123342_() - 2), 1 + random.m_188503_(dimensions.m_123343_() - 2));
            if (!level.m_6425_((BlockPos)pos).m_205070_(FluidTags.f_13131_) || !level.m_45772_(((EntityType)AxRegistry.EntityReg.AXOLOOTL.get()).m_20585_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.05, (double)pos.m_123343_() + 0.5))) continue;
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public Collection<IAxolootl> resolveAxolootls(ServerLevel level) {
        return this.resolveAxolootls(level, o -> true);
    }

    public Collection<IAxolootl> resolveAxolootls(ServerLevel level, Predicate<IAxolootl> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        HashSet<UUID> invalid = new HashSet<UUID>();
        for (UUID uuid : this.trackedAxolootls.keySet()) {
            IAxolootl iprovider;
            Entity entity = level.m_8791_(uuid);
            if (entity instanceof IAxolootl && !(iprovider = (IAxolootl)entity).getEntity().m_21224_()) {
                if (!predicate.test(iprovider)) continue;
                builder.add((Object)iprovider);
                continue;
            }
            invalid.add(uuid);
        }
        invalid.forEach(o -> this.trackedAxolootls.remove(o));
        return builder.build();
    }

    public Map<UUID, AxolootlVariant> resolveAxolootlVariants(RegistryAccess registryAccess) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<UUID> invalid = new HashSet<UUID>();
        Registry<AxolootlVariant> registry = AxolootlVariant.getRegistry(registryAccess);
        for (Map.Entry<UUID, ResourceLocation> entry : this.trackedAxolootls.entrySet()) {
            if (!AxRegistry.AxolootlVariantsReg.isValid(entry.getValue())) {
                invalid.add(entry.getKey());
                continue;
            }
            Optional oVariant = registry.m_6612_(entry.getValue());
            oVariant.ifPresentOrElse(m -> builder.put((Object)((UUID)entry.getKey()), m), () -> invalid.add((UUID)entry.getKey()));
        }
        invalid.forEach(o -> this.trackedAxolootls.remove(o));
        return builder.build();
    }

    public Map<BlockPos, IEnergyStorage> resolveEnergyStorage() {
        return this.resolveEnergyStorage(i -> true);
    }

    public Map<BlockPos, IEnergyStorage> resolveEnergyStorage(Predicate<IEnergyStorage> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockPos entry : this.getEnergyInputs()) {
            IEnergyStorage storage = this.resolveEnergyStorageOrVoid(this.f_58857_, entry, false);
            if (!predicate.test(storage)) continue;
            builder.put((Object)entry, (Object)storage);
        }
        return builder.build();
    }

    public Map<BlockPos, AquariumModifier> resolveModifiers(RegistryAccess registryAccess) {
        return this.resolveModifiers(registryAccess, (p, o) -> true);
    }

    public Map<BlockPos, AquariumModifier> resolveModifiers(RegistryAccess registryAccess, BiPredicate<BlockPos, AquariumModifier> predicate) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet invalid = new HashSet();
        Registry<AquariumModifier> registry = AquariumModifier.getRegistry(registryAccess);
        for (Map.Entry<BlockPos, ResourceLocation> entry : this.aquariumModifiers.entrySet()) {
            Optional oModifier = registry.m_6612_(entry.getValue());
            oModifier.ifPresentOrElse(m -> {
                if (predicate.test((BlockPos)entry.getKey(), (AquariumModifier)m)) {
                    builder.put((Object)((BlockPos)entry.getKey()), m);
                }
            }, () -> invalid.add((BlockPos)entry.getKey()));
        }
        for (BlockPos p : invalid) {
            Axolootl.LOGGER.warn("Unknown aquarium modifier " + this.aquariumModifiers.get(p) + " at (" + p.m_123344_() + ")");
            this.aquariumModifiers.remove(p);
        }
        return builder.build();
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (!((IAquariumTab)AxRegistry.AquariumTabsReg.CONTROLLER.get()).isAvailable(this)) {
            return null;
        }
        return new ControllerMenu(pContainerId, pPlayerInventory, this.m_58899_(), this, this.m_58899_(), ((IAquariumTab)AxRegistry.AquariumTabsReg.CONTROLLER.get()).getSortedIndex(), 0);
    }

    @Override
    public void setController(Level level, BlockPos pos, ControllerBlockEntity blockEntity) {
    }

    @Override
    public void clearController() {
    }

    @Override
    public Optional<ControllerBlockEntity> getController() {
        return Optional.of(this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        tag.m_128347_(KEY_GENERATION_SPEED, this.generationSpeed);
        tag.m_128347_(KEY_FEED_SPEED, this.feedSpeed);
        tag.m_128347_(KEY_BREED_SPEED, this.breedSpeed);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(KEY_SIZE)) {
            this.setSize(ControllerBlockEntity.readFromTag(tag, KEY_SIZE, TankMultiblock.Size.CODEC));
        } else {
            this.setSize(null);
        }
        this.tankStatus = (TankStatus)TankStatus.CODEC.m_216455_(tag.m_128461_(KEY_TANK_STATUS));
        this.feedStatus = (FeedStatus)FeedStatus.CODEC.m_216455_(tag.m_128461_(KEY_FEED_STATUS));
        this.breedStatus = (BreedStatus)BreedStatus.CODEC.m_216455_(tag.m_128461_(KEY_BREED_STATUS));
        if (tag.m_128441_(KEY_GENERATION_SPEED) && tag.m_128441_(KEY_FEED_SPEED) && tag.m_128441_(KEY_BREED_SPEED)) {
            this.generationSpeed = tag.m_128459_(KEY_GENERATION_SPEED);
            this.feedSpeed = tag.m_128459_(KEY_FEED_SPEED);
            this.breedSpeed = tag.m_128459_(KEY_BREED_SPEED);
            this.forceCalculateBonuses();
        }
        this.resourceGenerationTime = tag.m_128454_(KEY_GENERATION_TIME);
        this.breedTime = tag.m_128454_(KEY_BREED_TIME);
        this.feedTime = tag.m_128454_(KEY_FEED_TIME);
        this.trackedAxolootls.clear();
        ListTag axolootlList = tag.m_128437_(KEY_AXOLOOTLS, 10);
        int n = axolootlList.size();
        for (int i = 0; i < n; ++i) {
            CompoundTag entryTag = axolootlList.m_128728_(i);
            UUID uuid = entryTag.m_128342_(KEY_UUID);
            ResourceLocation variant = new ResourceLocation(entryTag.m_128461_(KEY_VARIANT));
            this.trackedAxolootls.put(uuid, variant);
        }
        this.aquariumModifiers.clear();
        this.activeAquariumModifiers.clear();
        ListTag modifierList = tag.m_128437_(KEY_MODIFIERS, 10);
        int n2 = modifierList.size();
        for (int i = 0; i < n2; ++i) {
            CompoundTag entryTag = modifierList.m_128728_(i);
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)entryTag.m_128469_(KEY_POS));
            boolean isActive = entryTag.m_128471_(KEY_ACTIVE);
            ResourceLocation modifier = new ResourceLocation(entryTag.m_128461_(KEY_MODIFIER));
            this.aquariumModifiers.put(pos, modifier);
            if (!isActive) continue;
            this.activeAquariumModifiers.add(pos);
        }
        this.trackedBlocks.clear();
        ListTag blockList = tag.m_128437_(KEY_TRACKED_BLOCKS, 10);
        int n3 = blockList.size();
        for (int i = 0; i < n3; ++i) {
            CompoundTag entryTag = blockList.m_128728_(i);
            ResourceLocation category = new ResourceLocation(entryTag.m_128461_(KEY_CATEGORY));
            HashSet<BlockPos> set = new HashSet<BlockPos>(ControllerBlockEntity.readBlockPosSet(entryTag, KEY_POSITIONS));
            this.trackedBlocks.put(category, set);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.hasTank()) {
            ControllerBlockEntity.writeToTag(tag, KEY_SIZE, this.size, TankMultiblock.Size.CODEC);
        }
        tag.m_128359_(KEY_TANK_STATUS, this.tankStatus.m_7912_());
        tag.m_128359_(KEY_FEED_STATUS, this.feedStatus.m_7912_());
        tag.m_128359_(KEY_BREED_STATUS, this.breedStatus.m_7912_());
        tag.m_128356_(KEY_GENERATION_TIME, this.resourceGenerationTime);
        tag.m_128356_(KEY_BREED_TIME, this.breedTime);
        tag.m_128356_(KEY_FEED_TIME, this.feedTime);
        ListTag axolootlList = new ListTag();
        for (Map.Entry<UUID, ResourceLocation> entry : this.trackedAxolootls.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_(KEY_UUID, entry.getKey());
            compoundTag.m_128359_(KEY_VARIANT, entry.getValue().toString());
            axolootlList.add((Object)compoundTag);
        }
        tag.m_128365_(KEY_AXOLOOTLS, (Tag)axolootlList);
        ListTag modifierList = new ListTag();
        for (Map.Entry<BlockPos, ResourceLocation> entry : this.aquariumModifiers.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128365_(KEY_POS, (Tag)NbtUtils.m_129224_((BlockPos)entry.getKey()));
            entryTag.m_128379_(KEY_ACTIVE, this.activeAquariumModifiers.contains(entry.getKey()));
            entryTag.m_128359_(KEY_MODIFIER, entry.getValue().toString());
            modifierList.add((Object)entryTag);
        }
        tag.m_128365_(KEY_MODIFIERS, (Tag)modifierList);
        ListTag listTag = new ListTag();
        for (Map.Entry<ResourceLocation, Set<BlockPos>> entry : this.trackedBlocks.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128359_(KEY_CATEGORY, entry.getKey().toString());
            ControllerBlockEntity.writeBlockPosSet(entryTag, KEY_POSITIONS, entry.getValue());
            listTag.add((Object)entryTag);
        }
        tag.m_128365_(KEY_TRACKED_BLOCKS, (Tag)listTag);
    }

    private static Set<BlockPos> readBlockPosSet(CompoundTag tag, String key) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        ListTag listTag = tag.m_128437_(key, 11);
        int n = listTag.size();
        for (int i = 0; i < n; ++i) {
            int[] array = listTag.m_128767_(i);
            assert (array.length == 3);
            set.add(new BlockPos(array[0], array[1], array[2]));
        }
        return set;
    }

    private static void writeBlockPosSet(CompoundTag tag, String key, Set<BlockPos> set) {
        ListTag listTag = new ListTag();
        for (BlockPos pos : set) {
            listTag.add((Object)new IntArrayTag(new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
        }
        tag.m_128365_(key, (Tag)listTag);
    }

    private static <T> T readFromTag(CompoundTag tag, String key, Codec<T> codec) {
        return codec.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(key)).resultOrPartial(s -> Axolootl.LOGGER.error("[ControllerBlockEntity#readFromTag] Failed to deserialize " + tag.m_128423_(key) + " with key \"" + key + "\"\n" + s)).orElseThrow();
    }

    private static <T> void writeToTag(CompoundTag tag, String key, T object, Codec<T> codec) {
        tag.m_128365_(key, (Tag)codec.encodeStart((DynamicOps)NbtOps.f_128958_, object).resultOrPartial(s -> Axolootl.LOGGER.error("[ControllerBlockEntity#writeToTag] Failed to serialize " + object.toString() + " with key \"" + key + "\"\n" + s)).orElseThrow());
    }
}

