/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block.entity;

import axolootl.block.entity.ControllerBlockEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface IAquariumControllerProvider {
    public static final String KEY_CONTROLLER = "Controller";

    public static boolean trySetController(Level level, BlockPos pos, ControllerBlockEntity blockEntity) {
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (blockEntity2 instanceof IAquariumControllerProvider) {
            IAquariumControllerProvider provider = (IAquariumControllerProvider)blockEntity2;
            provider.setController(level, blockEntity.m_58899_(), blockEntity);
            return true;
        }
        return false;
    }

    public static boolean trySetController(Entity entity, Level level, ControllerBlockEntity blockEntity) {
        if (entity instanceof IAquariumControllerProvider) {
            IAquariumControllerProvider provider = (IAquariumControllerProvider)entity;
            provider.setController(level, blockEntity.m_58899_(), blockEntity);
            return true;
        }
        return false;
    }

    public static boolean tryClearController(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IAquariumControllerProvider) {
            IAquariumControllerProvider provider = (IAquariumControllerProvider)blockEntity;
            provider.clearController();
            return true;
        }
        return false;
    }

    public static boolean tryClearController(Entity entity) {
        if (entity instanceof IAquariumControllerProvider) {
            IAquariumControllerProvider provider = (IAquariumControllerProvider)entity;
            provider.clearController();
            return true;
        }
        return false;
    }

    public void setController(Level var1, BlockPos var2, ControllerBlockEntity var3);

    public void clearController();

    public Optional<ControllerBlockEntity> getController();

    default public boolean hasTank() {
        Optional<ControllerBlockEntity> oController = this.getController();
        return oController.isPresent() && oController.get().hasTank();
    }

    default public void writeControllerPos(@Nullable BlockPos pos, CompoundTag tag) {
        if (pos != null) {
            tag.m_128365_(KEY_CONTROLLER, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        }
    }

    @Nullable
    default public BlockPos readControllerPos(CompoundTag tag) {
        if (tag.m_128441_(KEY_CONTROLLER)) {
            return NbtUtils.m_129239_((CompoundTag)tag.m_128469_(KEY_CONTROLLER));
        }
        return null;
    }
}

