/*
 * Decompiled with CFR 0.152.
 */
package axolootl.block.entity;

import axolootl.block.entity.ControllerBlockEntity;
import axolootl.block.entity.IAquariumControllerProvider;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InterfaceBlockEntity
extends BlockEntity
implements Container,
MenuProvider,
IAquariumControllerProvider {
    protected final NonNullList<ItemStack> inventory;
    protected LazyOptional<IItemHandler> holder = LazyOptional.of(this::createItemHandler);
    protected final int rows;
    protected final int slots;
    protected BlockPos controllerPos;
    protected ControllerBlockEntity controller;

    protected InterfaceBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int rows) {
        this(pType, pPos, pBlockState, rows, rows * 9);
    }

    protected InterfaceBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int rows, int slots) {
        super(pType, pPos, pBlockState);
        this.rows = rows;
        this.slots = slots;
        this.inventory = NonNullList.m_122780_((int)slots, (Object)ItemStack.f_41583_);
    }

    @Override
    public void setController(Level level, BlockPos pos, ControllerBlockEntity blockEntity) {
        boolean isChanged = this.controllerPos != pos || this.controller != blockEntity;
        this.controllerPos = pos;
        this.controller = blockEntity;
        if (isChanged) {
            this.m_6596_();
        }
    }

    @Override
    public void clearController() {
        this.controllerPos = null;
        this.controller = null;
        this.m_6596_();
    }

    @Override
    public Optional<ControllerBlockEntity> getController() {
        if (this.controllerPos != null && null == this.controller && this.f_58857_ != null) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.controllerPos);
            if (blockEntity instanceof ControllerBlockEntity) {
                ControllerBlockEntity controller = (ControllerBlockEntity)blockEntity;
                this.setController(this.f_58857_, this.controllerPos, controller);
            } else {
                this.clearController();
            }
        }
        return Optional.ofNullable(this.controller);
    }

    public boolean validateController(Level level) {
        ControllerBlockEntity controllerBlockEntity;
        if (null == this.controllerPos) {
            this.controller = null;
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(this.controllerPos);
        if (blockEntity instanceof ControllerBlockEntity && (controllerBlockEntity = (ControllerBlockEntity)blockEntity) != this.controller) {
            this.controller = controllerBlockEntity;
            return true;
        }
        return false;
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        switch (this.rows) {
            case 1: {
                return new ChestMenu(MenuType.f_39957_, pContainerId, pPlayerInventory, (Container)this, this.rows);
            }
            case 2: {
                return new ChestMenu(MenuType.f_39958_, pContainerId, pPlayerInventory, (Container)this, this.rows);
            }
            case 3: {
                return ChestMenu.m_39237_((int)pContainerId, (Inventory)pPlayerInventory, (Container)this);
            }
            case 4: {
                return new ChestMenu(MenuType.f_39960_, pContainerId, pPlayerInventory, (Container)this, this.rows);
            }
            case 5: {
                return new ChestMenu(MenuType.f_39961_, pContainerId, pPlayerInventory, (Container)this, this.rows);
            }
            case 6: {
                return ChestMenu.m_39246_((int)pContainerId, (Inventory)pPlayerInventory, (Container)this);
            }
        }
        return null;
    }

    public abstract boolean isMenuAvailable(Player var1, @Nullable ControllerBlockEntity var2);

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public void dropAllItems() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.m_58899_(), this.getInventory());
            this.m_6211_();
        }
        this.m_6596_();
    }

    public int m_6643_() {
        return this.slots;
    }

    public boolean m_7983_() {
        return this.inventory.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.inventory.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.inventory, (int)pSlot, (int)pAmount);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int pSlot) {
        return ContainerHelper.m_18966_(this.inventory, (int)pSlot);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.inventory.set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        if (this.getController().isPresent() && this.controller.hasTank()) {
            return true;
        }
        return pPlayer.m_20182_().m_82509_((Position)Vec3.m_82512_((Vec3i)this.f_58858_), 8.0);
    }

    public void m_6211_() {
        this.inventory.clear();
        this.m_6596_();
    }

    protected IItemHandler createItemHandler() {
        return new InvWrapper((Container)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && (null == facing || this.exposeItemCapability())) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    protected boolean exposeItemCapability() {
        return true;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.holder = LazyOptional.of(this::createItemHandler);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        this.controllerPos = this.readControllerPos(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        this.writeControllerPos(this.controllerPos, tag);
    }
}

