/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client;

import axolootl.Axolootl;
import axolootl.client.item.AxolootlBucketItemSettings;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class AxolootlBucketItemModelLoader {
    private static final ResourceLocation AXOLOOTL_BUCKET_ITEM_FALLBACK = new ResourceLocation("axolootl", "item/axolootl_bucket_template");
    private static AxolootlBucketItemSettings instance = new AxolootlBucketItemSettings();
    private static final String PATH = "models/item/axolootl_bucket/";

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AxolootlBucketItemModelLoader::onRegisterReloadListeners);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(AxolootlBucketItemModelLoader::onRegisterExtraModels);
    }

    public static AxolootlBucketItemSettings instance() {
        if (!instance.isLoaded()) {
            instance.merge(AxolootlBucketItemModelLoader.reload(Minecraft.m_91087_().m_91098_()));
            instance.setLoaded();
        }
        return instance;
    }

    public static ResourceLocation getModelForVariant(ResourceLocation variant) {
        return AxolootlBucketItemModelLoader.instance().getVariantToModelMap().getOrDefault(variant, AXOLOOTL_BUCKET_ITEM_FALLBACK);
    }

    private static void onRegisterReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new SimplePreparableReloadListener<AxolootlBucketItemSettings>(){

            protected AxolootlBucketItemSettings prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                return AxolootlBucketItemModelLoader.reload(pResourceManager);
            }

            protected void apply(AxolootlBucketItemSettings pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                instance.clear();
                instance.merge(pObject);
                instance.setLoaded();
            }
        });
    }

    private static void onRegisterExtraModels(ModelEvent.RegisterAdditional event) {
        event.register(AXOLOOTL_BUCKET_ITEM_FALLBACK);
        for (ResourceLocation model : AxolootlBucketItemModelLoader.instance().getVariantToModelMap().values()) {
            event.register(model);
        }
    }

    private static AxolootlBucketItemSettings reload(ResourceManager manager) {
        AxolootlBucketItemSettings settings = new AxolootlBucketItemSettings();
        try {
            Map resources = manager.m_214159_(PATH, id -> id.m_135815_().endsWith(".json"));
            if (resources.isEmpty()) {
                Axolootl.LOGGER.warn("No axolootl bucket item settings found at models/item/axolootl_bucket/");
            }
            for (ResourceLocation entry : resources.keySet()) {
                ResourceLocation variantId = new ResourceLocation(entry.m_135827_(), entry.m_135815_().replaceFirst(PATH, "").replaceFirst("\\.json", ""));
                ResourceLocation modelId = new ResourceLocation(entry.m_135827_(), entry.m_135815_().replaceFirst("models/", "").replaceFirst("\\.json", ""));
                settings.put(variantId, modelId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settings;
    }
}

