/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.entity;

import axolootl.AxRegistry;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.entity.IAxolootl;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class AKxolotlLayer<T extends LivingEntity & IAxolootl>
extends GeoLayerRenderer<T> {
    private static final TagKey<AxolootlVariant> BLACKLIST = TagKey.m_203882_(AxRegistry.Keys.AXOLOOTL_VARIANTS, (ResourceLocation)new ResourceLocation("axolootl", "special_blacklist"));
    private final AnimatedGeoModel<T> model;
    private final Pattern namePattern = Pattern.compile("(?i)ak(?:-| )?xolo(?:o)?tl");

    public AKxolotlLayer(IGeoRenderer<T> parent, AnimatedGeoModel<T> model) {
        super(parent);
        this.model = model;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (null == minecraft.f_91073_ || null == minecraft.f_91074_ || entity.m_20177_((Player)minecraft.f_91074_)) {
            return;
        }
        RegistryAccess access = minecraft.f_91073_.m_5962_();
        if (!this.namePattern.matcher(entity.m_7755_().getString().toLowerCase(Locale.ENGLISH)).matches()) {
            return;
        }
        Optional<AxolootlVariant> oVariant = ((IAxolootl)entity).getAxolootlVariant(access);
        if (oVariant.isEmpty()) {
            return;
        }
        if (oVariant.get().is(access, BLACKLIST)) {
            return;
        }
        this.renderModel((GeoModelProvider)this.model, this.model.getTextureResource(entity), poseStack, multiBufferSource, 0xF000F0, (Entity)entity, partialTick, 1.0f, 1.0f, 1.0f);
    }

    public RenderType getRenderType(ResourceLocation textureLocation) {
        return RenderType.m_110458_((ResourceLocation)textureLocation);
    }
}

