/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.entity;

import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.entity.IAxolootl;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LerpingModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class AxolootlGeoModel<T extends LivingEntity & IAxolootl>
extends AnimatedGeoModel<T> {
    private static final ResourceLocation EMPTY_ANIMATIONS = new ResourceLocation("axolootl", "animations/entity/axolootl/axolootl.animation.json");
    private static final String TAIL = "tail";
    private static final String LEFT_HIND_LEG = "left_hind_leg";
    private static final String RIGHT_HIND_LEG = "right_hind_leg";
    private static final String LEFT_FRONT_LEG = "left_front_leg";
    private static final String RIGHT_FRONT_LEG = "right_front_leg";
    private static final String BODY = "body";
    private static final String HEAD = "head";
    private static final String TOP_GILLS = "top_gills";
    private static final String LEFT_GILLS = "left_gills";
    private static final String RIGHT_GILLS = "right_gills";
    private IBone tail;
    private IBone leftHindLeg;
    private IBone rightHindLeg;
    private IBone leftFrontLeg;
    private IBone rightFrontLeg;
    private IBone body;
    private IBone head;
    private IBone topGills;
    private IBone leftGills;
    private IBone rightGills;

    public ResourceLocation getModelResource(T entity) {
        return ((IAxolootl)entity).getAxolootlVariant(((LivingEntity)entity).f_19853_.m_5962_()).orElse(AxolootlVariant.EMPTY).getModelSettings().getEntityGeoModel();
    }

    public ResourceLocation getTextureResource(T entity) {
        return ((IAxolootl)entity).getAxolootlVariant(((LivingEntity)entity).f_19853_.m_5962_()).orElse(AxolootlVariant.EMPTY).getModelSettings().getEntityTexture();
    }

    public ResourceLocation getAnimationResource(T entity) {
        return ((IAxolootl)entity).getAxolootlVariant(((LivingEntity)entity).f_19853_.m_5962_()).orElse(AxolootlVariant.EMPTY).getModelSettings().getOptionalEntityGeoAnimations().orElse(EMPTY_ANIMATIONS);
    }

    public void setCustomAnimations(T entity, int instanceId, AnimationEvent animationEvent) {
        super.setCustomAnimations(entity, instanceId, animationEvent);
        if (EMPTY_ANIMATIONS.equals((Object)this.getAnimationResource(entity))) {
            this.setAxolotlAnimations(entity, instanceId, animationEvent);
        }
    }

    public void setAxolotlAnimations(T entity, Integer uniqueID, AnimationEvent<?> event) {
        float partialTick = event.getPartialTick();
        float ageInTicks = (float)((LivingEntity)entity).f_19797_ + partialTick;
        Vec2 headRotations = this.getHeadRotations(entity, uniqueID, event);
        float headPitch = headRotations.f_82470_;
        float netHeadYaw = headRotations.f_82471_;
        try {
            this.tail = this.getBone(TAIL);
            this.leftHindLeg = this.getBone(LEFT_HIND_LEG);
            this.rightHindLeg = this.getBone(RIGHT_HIND_LEG);
            this.leftFrontLeg = this.getBone(LEFT_FRONT_LEG);
            this.rightFrontLeg = this.getBone(RIGHT_FRONT_LEG);
            this.body = this.getBone(BODY);
            this.head = this.getBone(HEAD);
            this.topGills = this.getBone(TOP_GILLS);
            this.leftGills = this.getBone(LEFT_GILLS);
            this.rightGills = this.getBone(RIGHT_GILLS);
        }
        catch (RuntimeException e) {
            return;
        }
        this.setupInitialAnimationValues(entity, netHeadYaw, headPitch);
        if (((IAxolootl)entity).isEntityPlayingDead()) {
            this.setupPlayDeadAnimation(netHeadYaw);
            this.saveAnimationValues(entity);
        } else {
            boolean flag;
            boolean bl = flag = entity.m_20184_().m_165925_() > 1.0E-7 || entity.m_146909_() != ((LivingEntity)entity).f_19860_ || entity.m_146908_() != ((LivingEntity)entity).f_19859_ || ((LivingEntity)entity).f_19790_ != entity.m_20185_() || ((LivingEntity)entity).f_19792_ != entity.m_20189_();
            if (entity.m_20072_()) {
                if (flag) {
                    this.setupSwimmingAnimation(ageInTicks, headPitch);
                } else {
                    this.setupWaterHoveringAnimation(ageInTicks);
                }
                this.saveAnimationValues(entity);
            } else {
                if (entity.m_20096_()) {
                    if (flag) {
                        this.setupGroundCrawlingAnimation(ageInTicks, netHeadYaw);
                    } else {
                        this.setupLayStillOnGroundAnimation(ageInTicks, netHeadYaw);
                    }
                }
                this.saveAnimationValues(entity);
            }
        }
    }

    protected void setupInitialAnimationValues(T entity, float netHeadYaw, float headPitch) {
        this.body.setPositionX(0.0f);
        this.head.setPositionY(0.0f);
        this.body.setPositionY(0.0f);
        Map map = ((LerpingModel)entity).m_142115_();
        if (map.isEmpty()) {
            this.setRotations(this.body, headPitch * ((float)Math.PI / 180), netHeadYaw * ((float)Math.PI / 180), 0.0f);
            this.setRotations(this.head, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.leftHindLeg, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.rightHindLeg, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.leftFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.rightFrontLeg, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.leftGills, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.rightGills, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.topGills, 0.0f, 0.0f, 0.0f);
            this.setRotations(this.tail, 0.0f, 0.0f, 0.0f);
        } else {
            this.setRotationFromVector(this.body, (Vector3f)map.get(BODY));
            this.setRotationFromVector(this.head, (Vector3f)map.get(HEAD));
            this.setRotationFromVector(this.leftHindLeg, (Vector3f)map.get(LEFT_HIND_LEG));
            this.setRotationFromVector(this.rightHindLeg, (Vector3f)map.get(RIGHT_HIND_LEG));
            this.setRotationFromVector(this.leftFrontLeg, (Vector3f)map.get(LEFT_FRONT_LEG));
            this.setRotationFromVector(this.rightFrontLeg, (Vector3f)map.get(RIGHT_FRONT_LEG));
            this.setRotationFromVector(this.leftGills, (Vector3f)map.get(LEFT_GILLS));
            this.setRotationFromVector(this.rightGills, (Vector3f)map.get(RIGHT_GILLS));
            this.setRotationFromVector(this.topGills, (Vector3f)map.get(TOP_GILLS));
            this.setRotationFromVector(this.tail, (Vector3f)map.get(TAIL));
        }
    }

    protected Vector3f getRotationVector(IBone bone) {
        return new Vector3f(bone.getRotationX(), bone.getRotationY(), bone.getRotationZ());
    }

    protected void setRotationFromVector(IBone bone, Vector3f vec) {
        this.setRotations(bone, vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
    }

    protected float lerpTo(float start, float end) {
        return this.lerpTo(0.05f, start, end);
    }

    protected float lerpTo(float delta, float start, float end) {
        return Mth.m_14189_((float)delta, (float)start, (float)end);
    }

    protected void lerpPart(IBone bone, float deltaX, float deltaY, float deltaZ) {
        this.setRotations(bone, this.lerpTo(bone.getRotationX(), deltaX), this.lerpTo(bone.getRotationY(), deltaY), this.lerpTo(bone.getRotationZ(), deltaZ));
    }

    protected void saveAnimationValues(T entity) {
        Map map = ((LerpingModel)entity).m_142115_();
        map.put(BODY, this.getRotationVector(this.body));
        map.put(HEAD, this.getRotationVector(this.head));
        map.put(RIGHT_HIND_LEG, this.getRotationVector(this.rightHindLeg));
        map.put(LEFT_HIND_LEG, this.getRotationVector(this.leftHindLeg));
        map.put(RIGHT_FRONT_LEG, this.getRotationVector(this.rightFrontLeg));
        map.put(LEFT_FRONT_LEG, this.getRotationVector(this.leftFrontLeg));
        map.put(TAIL, this.getRotationVector(this.tail));
        map.put(TOP_GILLS, this.getRotationVector(this.topGills));
        map.put(LEFT_GILLS, this.getRotationVector(this.leftGills));
        map.put(RIGHT_GILLS, this.getRotationVector(this.rightGills));
    }

    protected void setRotations(IBone bone, float x, float y, float z) {
        bone.setRotationX(x);
        bone.setRotationY(y);
        bone.setRotationZ(z);
    }

    protected Vec2 getHeadRotations(T entity, int instanceId, AnimationEvent<?> event) {
        EntityModelData extraData = (EntityModelData)event.getExtraDataOfType(EntityModelData.class).get(0);
        AnimationData manager = ((IAnimatable)entity).getFactory().getOrCreateAnimationData(instanceId);
        boolean unpausedMultiplier = !Minecraft.m_91087_().m_91104_() || manager.shouldPlayWhilePaused;
        return new Vec2(extraData.headPitch, extraData.netHeadYaw).m_165903_((float)Math.PI / 180 * (float)unpausedMultiplier);
    }

    protected void setupLayStillOnGroundAnimation(float ageInTicks, float netHeadYaw) {
        float scaledAgeInTicks = ageInTicks * 0.09f;
        float sinAgeInTicks = Mth.m_14031_((float)scaledAgeInTicks);
        float cosAgeInTicks = Mth.m_14089_((float)scaledAgeInTicks);
        float f3 = sinAgeInTicks * sinAgeInTicks - 2.0f * sinAgeInTicks;
        float f4 = cosAgeInTicks * cosAgeInTicks - 3.0f * sinAgeInTicks;
        this.head.setRotationX(this.lerpTo(this.head.getRotationX(), -0.09f * f3));
        this.head.setRotationY(this.lerpTo(this.head.getRotationY(), 0.0f));
        this.head.setRotationZ(this.lerpTo(this.head.getRotationZ(), -0.2f));
        this.tail.setRotationY(this.lerpTo(this.tail.getRotationY(), -0.1f + 0.1f * f3));
        this.topGills.setRotationX(this.lerpTo(this.topGills.getRotationX(), 0.6f + 0.05f * f4));
        this.leftGills.setRotationY(this.lerpTo(this.leftGills.getRotationY(), -this.topGills.getRotationX()));
        this.rightGills.setRotationY(this.lerpTo(this.rightGills.getRotationY(), -this.leftGills.getRotationY()));
        this.lerpPart(this.leftHindLeg, 1.1f, 1.0f, 0.0f);
        this.lerpPart(this.leftFrontLeg, 0.8f, 2.3f, -0.5f);
        this.applyMirrorLegRotations();
        this.body.setRotationX(this.lerpTo(0.2f, this.body.getRotationX(), 0.0f));
        this.body.setRotationY(this.lerpTo(this.body.getRotationY(), netHeadYaw * ((float)Math.PI / 180)));
        this.body.setRotationZ(this.lerpTo(this.body.getRotationZ(), 0.0f));
    }

    protected void setupGroundCrawlingAnimation(float ageInTicks, float netHeadYaw) {
        float scaledAgeInTicks = ageInTicks * 0.11f;
        float cosAgeInTicks = Mth.m_14089_((float)scaledAgeInTicks);
        float f2 = (cosAgeInTicks * cosAgeInTicks - 2.0f * cosAgeInTicks) / 5.0f;
        float scaledCosAgeInTicks = 0.7f * cosAgeInTicks;
        this.head.setRotationX(this.lerpTo(this.head.getRotationX(), 0.0f));
        this.head.setRotationY(this.lerpTo(this.head.getRotationY(), 0.09f * cosAgeInTicks));
        this.head.setRotationZ(this.lerpTo(this.head.getRotationZ(), 0.0f));
        this.tail.setRotationY(this.lerpTo(this.tail.getRotationY(), this.head.getRotationY()));
        this.topGills.setRotationX(this.lerpTo(this.topGills.getRotationX(), 0.6f - 0.08f * (cosAgeInTicks * cosAgeInTicks + 2.0f * Mth.m_14031_((float)scaledAgeInTicks))));
        this.leftGills.setRotationY(this.lerpTo(this.leftGills.getRotationY(), -this.topGills.getRotationX()));
        this.rightGills.setRotationY(this.lerpTo(this.rightGills.getRotationY(), -this.leftGills.getRotationY()));
        this.lerpPart(this.leftHindLeg, 0.9424779f, 1.5f - f2, 0.1f);
        this.lerpPart(this.leftFrontLeg, 1.0995574f, 1.5707964f - scaledCosAgeInTicks, 0.0f);
        this.lerpPart(this.rightHindLeg, this.leftHindLeg.getRotationX(), -1.0f - f2, 0.0f);
        this.lerpPart(this.rightFrontLeg, this.leftFrontLeg.getRotationX(), -1.5707964f - scaledCosAgeInTicks, 0.0f);
        this.body.setRotationX(this.lerpTo(0.2f, this.body.getRotationX(), 0.0f));
        this.body.setRotationY(this.lerpTo(this.body.getRotationY(), netHeadYaw * ((float)Math.PI / 180)));
        this.body.setRotationZ(this.lerpTo(this.body.getRotationZ(), 0.0f));
    }

    protected void setupWaterHoveringAnimation(float ageInTicks) {
        float scaledAgeInTicks = ageInTicks * 0.075f;
        float cosAgeInTicks = Mth.m_14089_((float)scaledAgeInTicks);
        float sinAgeInTicks = Mth.m_14031_((float)scaledAgeInTicks) * 0.15f;
        this.body.setRotationX(this.lerpTo(this.body.getRotationX(), -0.15f + 0.075f * cosAgeInTicks));
        this.body.setPositionY(this.body.getPositionY() - sinAgeInTicks);
        this.head.setRotationX(this.lerpTo(this.head.getRotationX(), -this.body.getRotationX()));
        this.topGills.setRotationX(this.lerpTo(this.topGills.getRotationX(), 0.2f * cosAgeInTicks));
        this.leftGills.setRotationY(this.lerpTo(this.leftGills.getRotationY(), -0.3f * cosAgeInTicks - 0.19f));
        this.rightGills.setRotationY(this.lerpTo(this.rightGills.getRotationY(), -this.leftGills.getRotationY()));
        this.lerpPart(this.leftHindLeg, -(2.3561945f - cosAgeInTicks * 0.11f), -0.47123894f, 1.7278761f);
        this.lerpPart(this.leftFrontLeg, -(0.7853982f - cosAgeInTicks * 0.2f), -2.042035f, 0.0f);
        this.applyMirrorLegRotations();
        this.tail.setRotationY(this.lerpTo(this.tail.getRotationY(), 0.5f * cosAgeInTicks));
        this.head.setRotationY(this.lerpTo(this.head.getRotationY(), 0.0f));
        this.head.setRotationZ(this.lerpTo(this.head.getRotationZ(), 0.0f));
    }

    protected void setupSwimmingAnimation(float ageInTicks, float headPitch) {
        float scaledAgeInTicks = ageInTicks * 0.33f;
        float sinAgeInTicks = Mth.m_14031_((float)scaledAgeInTicks);
        float coseAgeInTicks = Mth.m_14089_((float)scaledAgeInTicks);
        float scaledSinAgeInTicks = 0.13f * sinAgeInTicks;
        this.body.setRotationX(this.lerpTo(0.1f, this.body.getRotationX(), headPitch * ((float)Math.PI / 180) + scaledSinAgeInTicks));
        this.head.setRotationX(-scaledSinAgeInTicks * 1.8f);
        this.body.setPositionY(this.body.getPositionY() - 0.45f * coseAgeInTicks);
        this.topGills.setRotationX(this.lerpTo(this.topGills.getRotationX(), -0.5f * sinAgeInTicks - 0.8f));
        this.leftGills.setRotationY(this.lerpTo(this.leftGills.getRotationY(), 0.3f * sinAgeInTicks + 0.9f));
        this.rightGills.setRotationY(this.lerpTo(this.rightGills.getRotationY(), -this.leftGills.getRotationY()));
        this.tail.setRotationY(this.lerpTo(this.tail.getRotationY(), 0.3f * Mth.m_14089_((float)(scaledAgeInTicks * 0.9f))));
        this.lerpPart(this.leftHindLeg, -1.8849558f, -0.4f * sinAgeInTicks, 1.5707964f);
        this.lerpPart(this.leftFrontLeg, -1.8849558f, -0.2f * coseAgeInTicks - 0.1f, 1.5707964f);
        this.applyMirrorLegRotations();
        this.head.setRotationY(this.lerpTo(this.head.getRotationY(), 0.0f));
        this.head.setRotationZ(this.lerpTo(this.head.getRotationZ(), 0.0f));
    }

    protected void setupPlayDeadAnimation(float netHeadYaw) {
        this.lerpPart(this.leftHindLeg, 1.4137167f, 1.0995574f, 0.7853982f);
        this.lerpPart(this.leftFrontLeg, 0.7853982f, 2.042035f, 0.0f);
        this.body.setRotationX(this.lerpTo(this.body.getRotationX(), -0.15f));
        this.body.setRotationZ(this.lerpTo(this.body.getRotationZ(), 0.35f));
        this.applyMirrorLegRotations();
        this.body.setRotationY(this.lerpTo(this.body.getRotationY(), netHeadYaw * ((float)Math.PI / 180)));
        this.head.setRotationX(this.lerpTo(this.head.getRotationX(), 0.0f));
        this.head.setRotationY(this.lerpTo(this.head.getRotationY(), 0.0f));
        this.head.setRotationZ(this.lerpTo(this.head.getRotationZ(), 0.0f));
        this.tail.setRotationY(this.lerpTo(this.tail.getRotationY(), 0.0f));
        this.lerpPart(this.topGills, 0.0f, 0.0f, 0.0f);
        this.lerpPart(this.leftGills, 0.0f, 0.0f, 0.0f);
        this.lerpPart(this.rightGills, 0.0f, 0.0f, 0.0f);
    }

    protected void applyMirrorLegRotations() {
        this.lerpPart(this.rightHindLeg, this.leftHindLeg.getRotationX(), -this.leftHindLeg.getRotationY(), -this.leftHindLeg.getRotationZ());
        this.lerpPart(this.rightFrontLeg, this.leftFrontLeg.getRotationX(), -this.leftFrontLeg.getRotationY(), -this.leftFrontLeg.getRotationZ());
    }
}

