/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.item;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public class AxolootlBucketItemSettings {
    public static final Codec<AxolootlBucketItemSettings> CODEC = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)ResourceLocation.f_135803_).xmap(AxolootlBucketItemSettings::new, AxolootlBucketItemSettings::getVariantToModelMap).fieldOf("values").codec();
    private boolean isLoaded;
    private final Map<ResourceLocation, ResourceLocation> variantToModelMap;
    private final Map<ResourceLocation, ResourceLocation> variantToModelMapView;

    public AxolootlBucketItemSettings() {
        this(Map.of());
        this.isLoaded = false;
    }

    public AxolootlBucketItemSettings(Map<ResourceLocation, ResourceLocation> variantToModelMap) {
        this.variantToModelMap = new HashMap<ResourceLocation, ResourceLocation>(variantToModelMap);
        this.variantToModelMapView = Collections.unmodifiableMap(this.variantToModelMap);
    }

    public AxolootlBucketItemSettings merge(AxolootlBucketItemSettings other) {
        if (!other.isEmpty()) {
            this.putAll(other.getVariantToModelMap());
        }
        return this;
    }

    public void clear() {
        this.variantToModelMap.clear();
        this.isLoaded = false;
    }

    public void put(ResourceLocation variant, ResourceLocation model) {
        this.variantToModelMap.put(variant, model);
    }

    public void putAll(Map<ResourceLocation, ResourceLocation> map) {
        this.variantToModelMap.putAll(map);
    }

    public boolean isEmpty() {
        return this.variantToModelMap.isEmpty();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded() {
        this.isLoaded = true;
    }

    public Map<ResourceLocation, ResourceLocation> getVariantToModelMap() {
        return this.variantToModelMapView;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AxolootlBucketItemSettings)) {
            return false;
        }
        AxolootlBucketItemSettings that = (AxolootlBucketItemSettings)o;
        return this.variantToModelMap.equals(that.variantToModelMap);
    }

    public int hashCode() {
        return Objects.hash(this.variantToModelMap);
    }

    public String toString() {
        return this.variantToModelMap.entrySet().toString();
    }
}

