/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.capability.AxolootlResearchCapability;
import axolootl.client.menu.AbstractTabScreen;
import axolootl.client.menu.ControllerScreen;
import axolootl.client.menu.widget.ComponentButton;
import axolootl.client.menu.widget.ItemButton;
import axolootl.client.menu.widget.ScrollButton;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.data.axolootl_variant.Bonuses;
import axolootl.data.axolootl_variant.BonusesProvider;
import axolootl.data.breeding.AxolootlBreeding;
import axolootl.data.breeding.AxolootlBreedingWrapper;
import axolootl.data.resource_generator.ResourceDescription;
import axolootl.data.resource_generator.ResourceDescriptionGroup;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.item.AxolootlBucketItem;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class AxolootlDetailsScreen
extends Screen
implements ScrollButton.IScrollListener {
    public static final ResourceLocation TEXTURE = new ResourceLocation("axolootl", "textures/gui/aquarium/axolootl_details.png");
    public static final ResourceLocation WIDGETS = AbstractTabScreen.WIDGETS;
    public static final int WIDTH = 250;
    public static final int HEIGHT = 176;
    public static final int DETAILS_X = 8;
    public static final int DETAILS_Y = 8;
    public static final int DETAILS_LINE_SPACING = 4;
    public static final int RESOURCE_DESCRIPTION_X = 128;
    public static final int RESOURCE_DESCRIPTION_Y = 32;
    public static final int RESOURCE_DESCRIPTION_WIDTH = 100;
    public static final int RESOURCE_DESCRIPTION_HEIGHT = 135;
    public static final int RESOURCE_DESCRIPTION_MARGIN_X = 6;
    public static final int RESOURCE_DESCRIPTION_MARGIN_Y = 6;
    public static final int FOOD_MAX_COUNT = 6;
    public static final int BREED_FOOD_MAX_COUNT = 6;
    private final List<DetailsComponentButton> componentButtons;
    private final List<CyclingItemButton> foodButtons;
    private final List<CyclingItemButton> breedFoodButtons;
    private final List<ParentDataButton> parentButtons;
    private final List<ResourceDescriptionGroupButton> resourceDescriptionGroupButtons;
    private final List<ResourceDescriptionButton> resourceDescriptionButtons;
    private ScrollButton scrollButton;
    private int scrollOffset;
    private int resourceDescriptionHeight;
    private int leftPos;
    private int topPos;
    private long ticksOpen;
    private final ResourceLocation id;
    private final AxolootlVariant variant;
    private final ItemStack itemStack;
    private final List<List<ItemStack>> foods;
    private final List<List<ItemStack>> breedFoods;
    private final List<ParentData> parentData;
    private final List<ResourceDescriptionGroup> resourceDescriptionGroups;
    public static final String PREFIX = "gui.controller_tab.axolootl.axolootl_details.";
    private final Component resourceTitleText;
    private final Component tierText;
    private final Component foodText;
    private final Component breedFoodText;
    private final Component parentsTitleText;

    public AxolootlDetailsScreen(ResourceLocation id, AxolootlVariant variant, ItemStack icon, RegistryAccess access) {
        super(AxolootlDetailsScreen.createAxolootlName(variant, id));
        this.id = id;
        this.variant = variant;
        this.itemStack = icon;
        this.componentButtons = new ArrayList<DetailsComponentButton>();
        this.foodButtons = new ArrayList<CyclingItemButton>();
        this.parentButtons = new ArrayList<ParentDataButton>();
        this.breedFoodButtons = new ArrayList<CyclingItemButton>();
        this.resourceDescriptionGroupButtons = new ArrayList<ResourceDescriptionGroupButton>();
        this.resourceDescriptionButtons = new ArrayList<ResourceDescriptionButton>();
        this.resourceDescriptionGroups = new ArrayList<ResourceDescriptionGroup>(((ResourceGenerator)variant.getResourceGenerator().m_203334_()).getDescription());
        this.parentData = AxolootlDetailsScreen.calculateParentData(this.variant, access);
        this.ticksOpen = 0L;
        ArrayList<HolderSet<Item>> foods = new ArrayList<HolderSet<Item>>();
        for (BonusesProvider provider : this.variant.getFoods()) {
            foods.add(provider.getFoods().get((Registry<Item>)Registry.f_122827_));
        }
        this.foods = AxolootlDetailsScreen.distributeEqually(AxolootlDetailsScreen.resolveHolderSets(foods), 6);
        this.breedFoods = AxolootlDetailsScreen.distributeEqually(AxolootlDetailsScreen.resolveHolderSet(this.variant.getBreedFood().get((Registry<Item>)Registry.f_122827_)), 6);
        this.resourceTitleText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.loot").m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.loot.description"))));
        this.foodText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.food").m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.food.description"))));
        this.breedFoodText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.breed_food").m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.breed_food.description"))));
        this.parentsTitleText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.parents").m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.parents.description"))));
        this.tierText = Component.m_237110_((String)"entity.axolootl.axolootl.tier", (Object[])new Object[]{variant.getTierDescription()});
    }

    private static Component createAxolootlName(AxolootlVariant variant, ResourceLocation id) {
        return Component.m_237110_((String)"entity.axolootl.axolootl.description", (Object[])new Object[]{Component.m_237115_((String)"entity.axolootl.axolootl"), variant.getDescription()}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)variant.getDescription().m_6881_().m_130946_("\n").m_7220_((Component)Component.m_237113_((String)("" + id)).m_130940_(ChatFormatting.GRAY)))));
    }

    private static Component createTieredAxolootlName(AxolootlVariant variant, ResourceLocation id) {
        return Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_details.parents.entry.axolootl_tier", (Object[])new Object[]{variant.getDescription(), variant.getTierDescription()}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)variant.getDescription().m_6881_().m_130946_("\n").m_7220_((Component)Component.m_237113_((String)("" + id)).m_130940_(ChatFormatting.GRAY)))));
    }

    private static List<List<ItemStack>> distributeEqually(Collection<ItemStack> collection, int maxCount) {
        int listCount = Math.min(collection.size(), maxCount);
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < listCount; ++i) {
            list.add(new ArrayList());
        }
        Iterator<ItemStack> iterator = collection.iterator();
        int n = collection.size();
        for (int i = 0; i < n && iterator.hasNext(); ++i) {
            ((List)list.get(i % listCount)).add(iterator.next());
        }
        return list;
    }

    protected void m_7856_() {
        int i;
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 250) / 2;
        this.topPos = (this.f_96544_ - 176) / 2;
        int resourceMaxWidth = 94;
        this.resourceDescriptionHeight = ResourceDescriptionGroupButton.calculateTotalHeight(this.resourceDescriptionGroups, this.f_96547_, 94);
        this.scrollButton = (ScrollButton)this.m_142416_((GuiEventListener)new ScrollButton(this.leftPos + 128 + 100 + 1, this.topPos + 32 + 2, 12, 133, WIDGETS, 244, 0, 12, 15, 15, true, (float)ResourceDescriptionGroupButton.getHeight(this.f_96547_) / (float)Math.max(1, this.resourceDescriptionHeight - 135), this));
        this.m_7522_((GuiEventListener)this.scrollButton);
        this.scrollButton.f_93623_ = this.resourceDescriptionHeight > 135;
        Button.OnTooltip componentButtonOnTooltip = (b, p, mx, my) -> this.m_96570_(p, b.m_6035_().m_7383_(), mx, my);
        int x = this.leftPos + 8;
        Objects.requireNonNull(this.f_96547_);
        int y = this.topPos + 8 + (16 - 9) / 2;
        Objects.requireNonNull(this.f_96547_);
        int deltaY = 4 + 9;
        Button.OnTooltip iconButtonOnTooltip = (b, p, mx, my) -> this.m_169388_(p, ((ItemButton)b).getTooltips(), Optional.empty(), mx, my);
        this.m_142416_((GuiEventListener)new ItemButton(x, y + deltaY / 2, false, this.f_96547_, this.f_96542_, this.itemStack, arg_0 -> ((AxolootlDetailsScreen)this).m_96555_(arg_0), b -> {}, iconButtonOnTooltip));
        Objects.requireNonNull(this.f_96547_);
        this.componentButtons.add((DetailsComponentButton)this.m_142416_((GuiEventListener)new DetailsComponentButton(x + 16 + 2, y, 9, this.f_96547_, this.m_96636_(), componentButtonOnTooltip)));
        int resourceTitleX = this.leftPos + 128;
        Objects.requireNonNull(this.f_96547_);
        this.componentButtons.add((DetailsComponentButton)this.m_142416_((GuiEventListener)new DetailsComponentButton(x + 16 + 2, y += deltaY, 9, this.f_96547_, this.tierText, componentButtonOnTooltip)));
        Objects.requireNonNull(this.f_96547_);
        this.componentButtons.add((DetailsComponentButton)this.m_142416_((GuiEventListener)new DetailsComponentButton(resourceTitleX, y, 9, this.f_96547_, this.resourceTitleText, componentButtonOnTooltip)));
        if (this.variant.getEnergyCost() > 0) {
            MutableComponent energyCostText = Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_details.energy_cost.description", (Object[])new Object[]{this.variant.getEnergyCost()}).m_130940_(ChatFormatting.RED);
            this.m_142416_((GuiEventListener)new ItemButton(resourceTitleX + this.f_96547_.m_92852_((FormattedText)this.resourceTitleText) + 4, y - (16 - DetailsComponentButton.getHeight(this.f_96547_)), false, this.f_96547_, this.f_96542_, new ItemStack((ItemLike)Items.f_42451_), arg_0 -> AxolootlDetailsScreen.lambda$init$9((Component)energyCostText, arg_0), b -> {}, (arg_0, arg_1, arg_2, arg_3) -> this.lambda$init$11((Component)energyCostText, arg_0, arg_1, arg_2, arg_3)));
        }
        Objects.requireNonNull(this.f_96547_);
        this.componentButtons.add((DetailsComponentButton)this.m_142416_((GuiEventListener)new DetailsComponentButton(x, y += deltaY + 4, 9, this.f_96547_, this.foodText, componentButtonOnTooltip)));
        Button.OnTooltip cyclingItemButtonOnTooltip = (b, p, mx, my) -> this.m_169388_(p, ((CyclingItemButton)b).getTooltips(), Optional.empty(), mx, my);
        y += deltaY;
        int n = this.foods.size();
        for (i = 0; i < n; ++i) {
            this.foodButtons.add((CyclingItemButton)this.m_142416_((GuiEventListener)new CyclingItemButton(x + i * 19, y, this.f_96547_, this.f_96542_, this.foods.get(i), itemStack -> this.getFoodTooltip(this.variant, (ItemStack)itemStack), cyclingItemButtonOnTooltip)));
        }
        Objects.requireNonNull(this.f_96547_);
        this.componentButtons.add((DetailsComponentButton)this.m_142416_((GuiEventListener)new DetailsComponentButton(x, y += 20, 9, this.f_96547_, this.breedFoodText, componentButtonOnTooltip)));
        y += deltaY;
        n = this.breedFoods.size();
        for (i = 0; i < n; ++i) {
            this.breedFoodButtons.add((CyclingItemButton)this.m_142416_((GuiEventListener)new CyclingItemButton(x + i * 19, y, this.f_96547_, this.f_96542_, this.breedFoods.get(i), arg_0 -> ((AxolootlDetailsScreen)this).m_96555_(arg_0), cyclingItemButtonOnTooltip)));
        }
        Objects.requireNonNull(this.f_96547_);
        this.componentButtons.add((DetailsComponentButton)this.m_142416_((GuiEventListener)new DetailsComponentButton(x, y += 16 + deltaY, 9, this.f_96547_, this.parentsTitleText, componentButtonOnTooltip)));
        y += deltaY;
        Button.OnTooltip parentButtonOnTooltip = (b, p, mx, my) -> this.m_169388_(p, ((ParentDataButton)b).getTooltips(mx, my), Optional.empty(), mx, my);
        for (ParentData entry : this.parentData) {
            ParentDataButton button = (ParentDataButton)this.m_142416_((GuiEventListener)new ParentDataButton(x, y, this.f_96547_, this.f_96542_, arg_0 -> ((AxolootlDetailsScreen)this).m_96555_(arg_0), parentButtonOnTooltip));
            this.parentButtons.add(button);
            y += 17;
        }
        x = this.leftPos + 128 + 6;
        y = this.topPos + 32 + 1;
        Button.OnTooltip descriptionButtonOnTooltip = (b, p, mx, my) -> this.m_169388_(p, ((ResourceDescriptionButton)b).getTooltips(), Optional.empty(), mx, my);
        int n2 = this.resourceDescriptionGroups.size();
        int h = ResourceDescriptionGroupButton.getHeight(this.f_96547_);
        for (int i2 = 0; i2 < n2; ++i2) {
            ResourceDescriptionGroup group = this.resourceDescriptionGroups.get(i2);
            ResourceDescriptionGroupButton button = new ResourceDescriptionGroupButton(x, y, 94, h, this.f_96542_, this.f_96547_, group, arg_0 -> ((AxolootlDetailsScreen)this).m_96555_(arg_0), componentButtonOnTooltip, descriptionButtonOnTooltip, this.resourceDescriptionButtons::add);
            this.resourceDescriptionGroupButtons.add(button);
            y += button.getTotalHeight() + 6;
        }
        this.updateParentDataButtons();
        this.updateResourceDescriptionButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.ticksOpen;
        this.updateCyclingItemButtons();
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        RenderSystem.m_69461_();
        this.m_93250_(0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pPoseStack, this.leftPos, this.topPos, 0, 0, 250, 176);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        int scissorStartX = this.leftPos + 128;
        int scissorStartY = this.topPos + 32;
        AxolootlDetailsScreen.m_239260_((int)scissorStartX, (int)scissorStartY, (int)(scissorStartX + 100), (int)(scissorStartY + 135));
        for (ResourceDescriptionGroupButton resourceDescriptionGroupButton : this.resourceDescriptionGroupButtons) {
            resourceDescriptionGroupButton.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        for (ResourceDescriptionButton resourceDescriptionButton : this.resourceDescriptionButtons) {
            resourceDescriptionButton.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
        AxolootlDetailsScreen.m_240060_();
        this.renderHoverActions(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private void renderHoverActions(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        for (ResourceDescriptionGroupButton resourceDescriptionGroupButton : this.resourceDescriptionGroupButtons) {
            if (!resourceDescriptionGroupButton.f_93624_ || !resourceDescriptionGroupButton.m_198029_()) continue;
            resourceDescriptionGroupButton.m_7428_(poseStack, mouseX, mouseY);
        }
        for (ResourceDescriptionButton resourceDescriptionButton : this.resourceDescriptionButtons) {
            if (!resourceDescriptionButton.f_93624_ || !resourceDescriptionButton.m_198029_()) continue;
            resourceDescriptionButton.m_7428_(poseStack, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pMouseX < (double)this.leftPos || pMouseX > (double)(this.leftPos + 250) || pMouseY < (double)this.topPos || pMouseY > (double)(this.topPos + 176)) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7043_() {
        return false;
    }

    private void updateCyclingItemButtons() {
        for (CyclingItemButton button : this.foodButtons) {
            button.tick(this.ticksOpen);
        }
        for (CyclingItemButton button : this.breedFoodButtons) {
            button.tick(this.ticksOpen);
        }
    }

    private void updateParentDataButtons() {
        RegistryAccess access = this.getMinecraft().f_91073_.m_5962_();
        int n = this.parentButtons.size();
        for (int i = 0; i < n; ++i) {
            ParentDataButton button = this.parentButtons.get(i);
            int index = i;
            if (index >= this.parentData.size()) {
                button.f_93624_ = false;
                continue;
            }
            button.f_93624_ = true;
            button.update(access, this.parentData.get(index));
        }
    }

    private void updateResourceDescriptionButtons() {
        int scissorStartY = this.topPos + 32;
        int deltaY = -this.scrollOffset;
        for (ResourceDescriptionGroupButton resourceDescriptionGroupButton : this.resourceDescriptionGroupButtons) {
            resourceDescriptionGroupButton.move(0, deltaY);
            resourceDescriptionGroupButton.f_93624_ = resourceDescriptionGroupButton.group.showChance() && (resourceDescriptionGroupButton.f_93621_ + resourceDescriptionGroupButton.m_93694_() > scissorStartY || resourceDescriptionGroupButton.f_93621_ < scissorStartY + 135);
        }
        for (ResourceDescriptionButton resourceDescriptionButton : this.resourceDescriptionButtons) {
            resourceDescriptionButton.move(0, deltaY);
            resourceDescriptionButton.f_93624_ = resourceDescriptionButton.f_93621_ + resourceDescriptionButton.m_93694_() > scissorStartY || resourceDescriptionButton.f_93621_ < scissorStartY + 135;
        }
    }

    public static boolean canOpenDetails(Player player, ResourceLocation id) {
        Optional oVariant = AxolootlVariant.getRegistry(player.f_19853_.m_5962_()).m_6612_(id);
        if (oVariant.isEmpty() || !AxRegistry.AxolootlVariantsReg.isValid(id)) {
            return false;
        }
        return ((AxolootlResearchCapability)player.getCapability(Axolootl.AXOLOOTL_RESEARCH_CAPABILITY).orElse((Object)AxolootlResearchCapability.EMPTY)).containsAxolootl(id);
    }

    public static void openDetails(Minecraft minecraft, RegistryAccess access, ResourceLocation id) {
        AxolootlVariant variant = AxolootlVariant.getRegistry(access).m_6612_(id).orElse(AxolootlVariant.EMPTY);
        ItemStack icon = AxolootlBucketItem.getWithVariant(new ItemStack((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get()), id);
        AxolootlDetailsScreen.openDetails(minecraft, access, id, variant, icon);
    }

    public static void openDetails(Minecraft minecraft, RegistryAccess access, ResourceLocation id, AxolootlVariant variant, ItemStack icon) {
        minecraft.pushGuiLayer((Screen)new AxolootlDetailsScreen(id, variant, icon, access));
    }

    private static Collection<ItemStack> resolveHolderSets(Collection<HolderSet<Item>> holderSets) {
        HashSet<Item> collection = new HashSet<Item>();
        for (HolderSet<Item> holderSet : holderSets) {
            collection.addAll(AxolootlDetailsScreen.resolveHolderSetItems(holderSet));
        }
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(collection.size());
        for (Item item : collection) {
            itemStacks.add(item.m_7968_());
        }
        return itemStacks;
    }

    private static Collection<ItemStack> resolveHolderSet(HolderSet<Item> holderSet) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Item item : AxolootlDetailsScreen.resolveHolderSetItems(holderSet)) {
            itemStacks.add(item.m_7968_());
        }
        return itemStacks;
    }

    private static Collection<Item> resolveHolderSetItems(HolderSet<Item> holderSet) {
        HashSet<Item> collection = new HashSet<Item>();
        Either either = holderSet.m_203440_();
        either.ifLeft(key -> {
            for (Item item : ForgeRegistries.ITEMS.tags().getTag(key)) {
                collection.add(item);
            }
        });
        either.ifRight(items -> {
            for (Holder item : items) {
                collection.add((Item)item.m_203334_());
            }
        });
        return collection;
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)(this.leftPos + 128 - 1) && pMouseX < (double)(this.leftPos + 128 + 100 + 1) && pMouseY >= (double)(this.topPos + 32 - 1) && pMouseY < (double)(this.topPos + 32 + 135 + 1)) {
            return this.scrollButton.m_6050_(pMouseX, pMouseY, pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrollButton != null && this.scrollButton.isDragging()) {
            this.scrollButton.m_7212_(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public void onScroll(ScrollButton button, float percent) {
        this.scrollOffset = Mth.m_14143_((float)Math.max(0.0f, percent * (float)Math.max(0, this.resourceDescriptionHeight - 135)));
        this.updateResourceDescriptionButtons();
    }

    private static List<ParentData> calculateParentData(AxolootlVariant variant, RegistryAccess access) {
        ResourceLocation variantId = variant.getRegistryName(access);
        Registry<AxolootlBreeding> breedingRegistry = AxolootlBreeding.getRegistry(access);
        ArrayList<ParentData> list = new ArrayList<ParentData>();
        for (AxolootlBreeding breeding : breedingRegistry) {
            AxolootlBreedingWrapper breedingWrapper = AxRegistry.AxolootlBreedingReg.getWrapper(access, breeding);
            for (WeightedEntry.Wrapper wrapper : breedingWrapper.getResult().m_146338_()) {
                if (!((ResourceKey)wrapper.m_146310_()).m_135782_().equals((Object)variantId)) continue;
                double totalWeight = ResourceGenerator.calculateTotalWeight(breedingWrapper.getResult());
                list.add(new ParentData(breeding.getFirst(access), breeding.getSecond(access), (double)wrapper.m_142631_().m_146281_() / totalWeight));
            }
        }
        return list;
    }

    private List<Component> getFoodTooltip(AxolootlVariant variant, ItemStack itemStack) {
        ArrayList<Component> list = new ArrayList<Component>(this.m_96555_(itemStack));
        if (list.isEmpty()) {
            return list;
        }
        Optional<Bonuses> oBonuses = variant.getFoodBonuses((ItemLike)itemStack.m_41720_());
        if (oBonuses.isEmpty()) {
            return list;
        }
        Bonuses bonuses = oBonuses.get();
        double bonus = bonuses.getBreedBonus();
        if (Math.abs(bonus) > 1.0E-7) {
            list.add(1, (Component)Component.m_237110_((String)"axolootl.modifier_settings.breed_speed.single", (Object[])new Object[]{ControllerScreen.toAdditivePercentage(bonus, bonus < 0.0 ? ChatFormatting.RED : ChatFormatting.LIGHT_PURPLE)}));
        }
        if (Math.abs(bonus = bonuses.getFeedBonus()) > 1.0E-7) {
            list.add(1, (Component)Component.m_237110_((String)"axolootl.modifier_settings.feed_speed.single", (Object[])new Object[]{ControllerScreen.toAdditivePercentage(bonus, bonus < 0.0 ? ChatFormatting.RED : ChatFormatting.YELLOW)}));
        }
        if (Math.abs(bonus = bonuses.getGenerationBonus()) > 1.0E-7) {
            list.add(1, (Component)Component.m_237110_((String)"axolootl.modifier_settings.generation_speed.single", (Object[])new Object[]{ControllerScreen.toAdditivePercentage(bonus, bonus < 0.0 ? ChatFormatting.RED : ChatFormatting.GREEN)}));
        }
        return list;
    }

    private /* synthetic */ void lambda$init$11(Component energyCostText, Button b, PoseStack p, int mx, int my) {
        this.m_96602_(p, energyCostText, mx, my);
    }

    private static /* synthetic */ List lambda$init$9(Component energyCostText, ItemStack item) {
        return ImmutableList.of((Object)energyCostText);
    }

    private static class ResourceDescriptionGroupButton
    extends DetailsComponentButton {
        private final ResourceDescriptionGroup group;
        private int totalWidth;
        private int totalHeight;
        private int xo;
        private int yo;

        public ResourceDescriptionGroupButton(int pX, int pY, int width, int height, ItemRenderer itemRenderer, Font font, ResourceDescriptionGroup group, Function<ItemStack, List<Component>> getTooltipFromItem, Button.OnTooltip onTooltip, Button.OnTooltip descriptionButtonOnTooltip, Consumer<ResourceDescriptionButton> onAddDescriptionButton) {
            super(pX, pY, height, font, group.getChanceDescription(), onTooltip);
            this.group = group;
            this.totalWidth = width;
            this.totalHeight = group.showChance() ? height : 0;
            this.xo = pX;
            this.yo = pY;
            this.drawTooltip = false;
            this.init(onAddDescriptionButton, getTooltipFromItem, descriptionButtonOnTooltip, itemRenderer, font);
        }

        private void init(Consumer<ResourceDescriptionButton> onAddDescriptionButton, Function<ItemStack, List<Component>> getTooltipFromItem, Button.OnTooltip descriptionButtonOnTooltip, ItemRenderer itemRenderer, Font font) {
            int n = this.group.getDescriptions().size();
            int countX = this.totalWidth / 30;
            int startY = this.f_93621_ + (this.group.showChance() ? this.f_93619_ : 0);
            for (int i = 0; i < n; ++i) {
                ResourceDescription description = this.group.getDescriptions().get(i);
                ResourceDescriptionButton button = new ResourceDescriptionButton(this.f_93620_ + i % countX * 30, startY + i / countX * ResourceDescriptionButton.getHeight(font), font, itemRenderer, description, getTooltipFromItem, descriptionButtonOnTooltip);
                onAddDescriptionButton.accept(button);
                if (i % countX != 0) continue;
                this.totalHeight += button.getTotalHeight();
            }
        }

        public void move(int deltaX, int deltaY) {
            this.f_93620_ = this.xo + deltaX;
            this.f_93621_ = this.yo + deltaY;
        }

        public int getTotalWidth() {
            return this.totalWidth;
        }

        public int getTotalHeight() {
            return this.totalHeight;
        }

        public static int calculateTotalHeight(List<ResourceDescriptionGroup> groups, Font font, int maxWidth) {
            int height = 0;
            float countX = maxWidth / 30;
            for (ResourceDescriptionGroup group : groups) {
                if (group.showChance()) {
                    height += ResourceDescriptionGroupButton.getHeight(font);
                }
                height += Mth.m_14167_((float)((float)group.getDescriptions().size() / countX)) * ResourceDescriptionButton.getHeight(font);
                height += 6;
            }
            return height;
        }
    }

    private static class DetailsComponentButton
    extends ComponentButton {
        public DetailsComponentButton(int pX, int pY, int height, Font font, Component pMessage, Button.OnTooltip onTooltip) {
            this(pX, pY, font.m_92852_((FormattedText)pMessage), height, font, pMessage, onTooltip);
        }

        public DetailsComponentButton(int pX, int pY, int width, int height, Font font, Component pMessage, Button.OnTooltip onTooltip) {
            super(pX, pY, width, height, font, pMessage, b -> {}, onTooltip);
        }
    }

    private static class CyclingItemButton
    extends ItemButton {
        private final List<ItemStack> items;
        private int index;

        public CyclingItemButton(int pX, int pY, Font font, ItemRenderer itemRenderer, List<ItemStack> items, Function<ItemStack, List<Component>> getTooltipFromItem, Button.OnTooltip onTooltip) {
            super(pX, pY, true, font, itemRenderer, ItemStack.f_41583_, getTooltipFromItem, b -> {}, onTooltip);
            this.items = items;
            this.f_93624_ = !items.isEmpty();
            this.index = -1;
            this.tick(0L);
        }

        public void tick(long ticksOpen) {
            if (!this.f_93624_) {
                return;
            }
            if (this.items.isEmpty()) {
                return;
            }
            int indexOld = this.index;
            this.index = (int)(ticksOpen / 20L % (long)this.items.size());
            if (indexOld == this.index) {
                return;
            }
            this.setItem(this.items.get(this.index));
        }
    }

    private record ParentData(AxolootlVariant parentA, AxolootlVariant parentB, double chance) {
    }

    private static class ParentDataButton
    extends ItemButton {
        public final int TEXT_WIDTH = 35;
        public final int WIDTH = 71;
        private ParentData entry = new ParentData(AxolootlVariant.EMPTY, AxolootlVariant.EMPTY, 0.0);
        private ItemStack parentA = ItemStack.f_41583_;
        private ItemStack parentB = ItemStack.f_41583_;
        private Button.OnPress onPressParentA;
        private Button.OnPress onPressParentB;
        private final Component clickToViewText;
        private List<Component> chanceTooltip;

        public ParentDataButton(int pX, int pY, Font font, ItemRenderer itemRenderer, Function<ItemStack, List<Component>> getTooltipFromItem, Button.OnTooltip onTooltip) {
            super(pX, pY, true, font, itemRenderer, ItemStack.f_41583_, getTooltipFromItem, b -> {}, onTooltip);
            this.f_93618_ = 71;
            this.onPressParentA = b -> {};
            this.onPressParentB = b -> {};
            this.clickToViewText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_details.parents.entry.tooltip").m_130940_(ChatFormatting.YELLOW);
            this.chanceTooltip = new ArrayList<Component>();
        }

        public void update(RegistryAccess access, ParentData entry) {
            this.entry = entry;
            this.onPressParentA = b -> this.tryOpenDetails(access, entry.parentA().getRegistryName(access));
            this.onPressParentB = b -> this.tryOpenDetails(access, entry.parentB().getRegistryName(access));
            this.parentA = AxolootlBucketItem.getWithVariant(access, new ItemStack((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get()), entry.parentA());
            this.parentB = AxolootlBucketItem.getWithVariant(access, new ItemStack((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get()), entry.parentB());
            MutableComponent chance = Component.m_237113_((String)String.format("%.1f", entry.chance() * 100.0).replaceAll("\\.0$", ""));
            this.m_93666_((Component)Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_details.parents.entry.chance", (Object[])new Object[]{chance}).m_130940_(ChatFormatting.DARK_BLUE));
            MutableComponent parentAText = Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_details.parents.entry.axolootl_tier", (Object[])new Object[]{entry.parentA().getDescription(), entry.parentA().getTierDescription()}).m_130938_(entry.parentA().getRarity().getStyleModifier());
            MutableComponent parentBText = Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_details.parents.entry.axolootl_tier", (Object[])new Object[]{entry.parentB().getDescription(), entry.parentB().getTierDescription()}).m_130938_(entry.parentB().getRarity().getStyleModifier());
            this.chanceTooltip.clear();
            this.chanceTooltip.add((Component)Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_details.parents.entry.chance.description", (Object[])new Object[]{chance, parentAText, parentBText}));
        }

        public List<Component> getTooltips(double mouseX, double mouseY) {
            double x = mouseX - (double)this.f_93620_;
            if (x > 53.0) {
                return this.withInsertedText((List)this.getTooltipFromItem.apply(this.parentB), this.clickToViewText);
            }
            if (x > 35.0) {
                return this.withInsertedText((List)this.getTooltipFromItem.apply(this.parentA), this.clickToViewText);
            }
            return this.chanceTooltip;
        }

        private List<Component> withInsertedText(List<Component> list, Component inserted) {
            int index = list.size() > 1 ? 2 : 0;
            list.add(index, inserted);
            return list;
        }

        public void m_5716_(double pMouseX, double pMouseY) {
            double x = pMouseX - (double)this.f_93620_;
            if (x > 53.0) {
                this.onPressParentB.m_93750_((Button)this);
            } else if (x > 35.0) {
                this.onPressParentA.m_93750_((Button)this);
            } else {
                super.m_5716_(pMouseX, pMouseY);
            }
        }

        @Override
        public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.drawBackground) {
                this.renderBackground(pPoseStack, this.f_93620_ + 35, this.f_93621_);
                this.renderBackground(pPoseStack, this.f_93620_ + 35 + 16 + 2, this.f_93621_);
            }
            Component component = this.m_6035_();
            float f = this.f_93620_;
            float f2 = this.f_93621_;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(pPoseStack, component, f, f2 + (float)(16 - 9) / 2.0f, 0);
            if (!this.parentA.m_41619_()) {
                this.renderItem(this.parentA, this.f_93620_ + 35, this.f_93621_);
            }
            if (!this.parentB.m_41619_()) {
                this.renderItem(this.parentB, this.f_93620_ + 35 + 16 + 2, this.f_93621_);
            }
            if (this.drawTooltip && this.m_198029_()) {
                this.m_7428_(pPoseStack, pMouseX, pMouseY);
            }
        }

        private void tryOpenDetails(RegistryAccess access, ResourceLocation target) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (null == minecraft.f_91073_ || null == minecraft.f_91074_) {
                return;
            }
            if (!AxolootlDetailsScreen.canOpenDetails((Player)minecraft.f_91074_, target)) {
                return;
            }
            minecraft.popGuiLayer();
            AxolootlDetailsScreen.openDetails(minecraft, access, target);
        }
    }

    private static class ResourceDescriptionButton
    extends ItemButton {
        public static final int WIDTH = 30;
        private static final List<Component> EMPTY_TOOLTIP = ImmutableList.of((Object)ResourceGenerator.getItemDisplayName(ItemStack.f_41583_));
        private static final ItemStack EMPTY_ITEMSTACK = new ItemStack((ItemLike)Items.f_42127_);
        private final ResourceDescription description;
        private final Font font;
        private int xo;
        private int yo;

        public ResourceDescriptionButton(int pX, int pY, Font font, ItemRenderer itemRenderer, ResourceDescription description, Function<ItemStack, List<Component>> getTooltipFromItem, Button.OnTooltip onTooltip) {
            super(pX, pY, false, font, itemRenderer, description.getItem().m_41619_() ? EMPTY_ITEMSTACK : description.getItem(), getTooltipFromItem, b -> {}, onTooltip);
            this.font = font;
            this.description = description;
            this.xo = pX;
            this.yo = pY;
            this.drawTooltip = false;
        }

        public void move(int deltaX, int deltaY) {
            this.f_93620_ = this.xo + deltaX;
            this.f_93621_ = this.yo + deltaY;
        }

        public static int getHeight(Font font) {
            Objects.requireNonNull(font);
            return 16 + 9 + 1;
        }

        @Override
        public List<Component> getTooltips() {
            if (this.description.getItem().m_41619_()) {
                return new ArrayList<Component>(EMPTY_TOOLTIP);
            }
            if (this.description.getDescriptions().isEmpty()) {
                return (List)this.getTooltipFromItem.apply(this.description.getItem());
            }
            return this.description.getDescriptions();
        }

        public int getTotalHeight() {
            Objects.requireNonNull(this.font);
            return this.f_93619_ + 9 + 1;
        }

        @Override
        public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.description.showChance()) {
                int textWidth = this.font.m_92852_((FormattedText)this.description.getChanceDescription());
                this.font.m_92889_(pPoseStack, this.description.getChanceDescription(), (float)this.f_93620_ + (float)(this.f_93618_ - textWidth) / 2.0f, (float)(this.f_93621_ + this.f_93619_ + 1), 0);
            }
            super.m_6303_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }
}

