/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.client.menu.AbstractTabScreen;
import axolootl.client.menu.widget.ScrollButton;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.menu.AxolootlInterfaceMenu;
import axolootl.util.TankMultiblock;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;

public class AxolootlInterfaceScreen
extends AbstractTabScreen<AxolootlInterfaceMenu>
implements ScrollButton.IScrollListener {
    public static final ResourceLocation AXOLOOTL_BG = new ResourceLocation("axolootl", "textures/gui/aquarium/axolootl_interface.png");
    private static final int ENTRY_X = 8;
    private static final int ENTRY_Y = 20;
    private static final int ENTRY_COUNT_X = 2;
    private static final int ENTRY_COUNT_Y = 4;
    private static final int ENTRY_COUNT = 8;
    private List<EntryButton> entryButtons;
    private InsertButton insertButton;
    private ScrollButton scrollButton;
    private int scrollOffset;
    private List<Map.Entry<AxolootlVariant, Integer>> variantCountList = new ArrayList<Map.Entry<AxolootlVariant, Integer>>();
    private int entryCount;
    private boolean hasBucket;
    private boolean hasAxolootl;
    public static final String PREFIX = "gui.controller_tab.axolootl.axolootl_interface.";
    private Component countText;
    private Component emptyText;

    public AxolootlInterfaceScreen(AxolootlInterfaceMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.entryButtons = new ArrayList<EntryButton>();
        this.countText = pTitle;
        this.emptyText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_interface.no_axolootls");
    }

    private void updateVariantList() {
        Optional<ControllerBlockEntity> oController = ((AxolootlInterfaceMenu)this.m_6262_()).getController();
        this.variantCountList.clear();
        this.variantCountList.addAll(((AxolootlInterfaceMenu)this.m_6262_()).getVariantCountMap().entrySet());
        this.variantCountList.sort(Comparator.comparingInt(e -> ((AxolootlVariant)e.getKey()).getTier()));
        this.entryCount = ((AxolootlInterfaceMenu)this.m_6262_()).getTotalCount();
        oController.ifPresent(c -> {
            int maxCapacity = ControllerBlockEntity.calculateMaxCapacity(c.getSize().orElse(TankMultiblock.Size.EMPTY));
            ChatFormatting color = this.entryCount <= maxCapacity ? ChatFormatting.RESET : ChatFormatting.RED;
            this.countText = Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_interface.count", (Object[])new Object[]{Component.m_237113_((String)("" + this.entryCount)).m_130940_(color), maxCapacity});
        });
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.updateVariantList();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.m_96636_())) / 2;
        this.scrollButton = (ScrollButton)this.m_142416_((GuiEventListener)new ScrollButton(this.f_97735_ + 199, this.f_97736_ + 20, 12, 80, WIDGETS, 244, 0, 12, 15, 15, true, 1.0f / Math.max(1.0f, (float)(this.variantCountList.size() - 8) / 2.0f), this));
        this.m_7522_((GuiEventListener)this.scrollButton);
        this.scrollButton.f_93623_ = ((AxolootlInterfaceMenu)this.m_6262_()).getVariantCountMap().size() > 8;
        Button.OnPress insertButtonOnPress = b -> {
            ((AxolootlInterfaceMenu)this.m_6262_()).insert();
            this.updateVariantList();
            this.updateEntryButtons();
        };
        this.insertButton = (InsertButton)this.m_142416_((GuiEventListener)new InsertButton(this.f_97735_ + 220 - 92 - 7, this.f_97736_ + 108 - 1, this.f_96547_, insertButtonOnPress, (b, p, mx, my) -> this.m_96602_(p, b.m_6035_(), mx, my)));
        this.entryButtons.clear();
        for (int i = 0; i < 8; ++i) {
            int x = this.f_97735_ + 8 + i % 2 * 92;
            int y = this.f_97736_ + 20 + i / 2 * 20;
            Button.OnPress onPress = b -> {
                ((AxolootlInterfaceMenu)this.m_6262_()).extract(((EntryButton)b).getEntry());
                this.updateVariantList();
                this.updateEntryButtons();
            };
            this.entryButtons.add((EntryButton)this.m_142416_((GuiEventListener)new EntryButton(x, y, this.f_96547_, onPress, (b, p, mx, my) -> this.m_96602_(p, b.m_6035_(), mx, my))));
        }
        this.updateEntryButtons();
        this.m_181908_();
    }

    public Component m_96636_() {
        return this.countText;
    }

    protected void m_181908_() {
        super.m_181908_();
        boolean hadBucket = this.hasBucket;
        this.updateContainerFlags(((AxolootlInterfaceMenu)this.m_6262_()).getContainer());
        if (this.hasBucket != hadBucket) {
            this.updateEntryButtons();
        }
        this.insertButton.f_93623_ = this.hasAxolootl;
    }

    @Override
    protected void renderBgTexture(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 220, 222);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AXOLOOTL_BG);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, 220, 222);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SLOTS);
        this.m_93228_(poseStack, this.f_97735_ + 30 - 1, this.f_97736_ + 108 - 1, 29, 107, AxolootlInterfaceMenu.INV_SIZE * 18, 18);
        this.m_93228_(poseStack, this.f_97735_ + 30, this.f_97736_ + 108 - 1, 240, 0, 16, 16);
    }

    @Override
    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.entryCount < 1) {
            int textWidth = this.f_96547_.m_92852_((FormattedText)this.emptyText);
            float f = (float)(this.f_97735_ + 8) + (float)(184 - textWidth) / 2.0f;
            float f2 = this.f_97736_ + 20;
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92889_(pPoseStack, this.emptyText, f, f2 + (float)(80 - 9) / 2.0f, 0);
        }
    }

    private void updateContainerFlags(Container container) {
        this.hasBucket = false;
        this.hasAxolootl = false;
        int n = container.m_6643_();
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_150930_(Items.f_42446_)) {
                this.hasBucket = true;
            }
            if (!(itemStack.m_41720_() instanceof MobBucketItem)) continue;
            this.hasAxolootl = true;
        }
    }

    private void updateEntryButtons() {
        int n = this.entryButtons.size();
        for (int i = 0; i < n; ++i) {
            EntryButton button = this.entryButtons.get(i);
            int index = i + this.scrollOffset * 2;
            if (index < 0 || index >= this.variantCountList.size()) {
                button.f_93623_ = false;
                button.f_93624_ = false;
                continue;
            }
            button.f_93624_ = true;
            button.update(this.variantCountList.get(index), this.hasBucket);
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.m_6774_(8, 20, 184, 80, pMouseX, pMouseY)) {
            return this.scrollButton.m_6050_(pMouseX, pMouseY, pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrollButton != null && this.scrollButton.isDragging()) {
            this.scrollButton.m_7212_(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public void onScroll(ScrollButton button, float percent) {
        this.scrollOffset = Math.round(Math.max(0.0f, percent * Math.max(0.0f, (float)Mth.m_14167_((float)((float)(this.variantCountList.size() - 8) / 2.0f)))));
        this.updateEntryButtons();
    }

    private static class InsertButton
    extends ImageButton {
        private static final int WIDTH = 92;
        private static final int HEIGHT = 18;
        private final Font font;

        public InsertButton(int pX, int pY, Font font, Button.OnPress pOnPress, Button.OnTooltip pOnTooltip) {
            super(pX, pY, 92, 18, 137, 50, 18, AbstractTabScreen.WIDGETS, 256, 256, pOnPress, pOnTooltip, (Component)Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_interface.insert"));
            this.font = font;
        }

        public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_6303_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            Component component = this.m_6035_();
            float f = (float)this.f_93620_ + (float)(this.f_93618_ - this.font.m_92852_((FormattedText)this.m_6035_())) / 2.0f;
            float f2 = this.f_93621_;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(pPoseStack, component, f, f2 + (float)(this.f_93619_ - 9) / 2.0f, 0);
        }
    }

    public static class EntryButton
    extends ImageButton {
        public static final int WIDTH = 92;
        public static final int HEIGHT = 20;
        public static final int INTERACT_WIDTH = 14;
        public static final int INTERACT_HEIGHT = 14;
        private Font font;
        private AxolootlVariant entry = AxolootlVariant.EMPTY;
        private int count;
        private Component text;
        private Component tooltipText;
        private Component tooltipFailText;

        public EntryButton(int pX, int pY, Font font, Button.OnPress pOnPress, Button.OnTooltip pOnTooltip) {
            super(pX, pY, 14, 14, 242, 143, 14, AbstractTabScreen.WIDGETS, 256, 256, pOnPress, pOnTooltip, (Component)Component.m_237119_());
            this.font = font;
            this.text = Component.m_237119_();
            this.tooltipText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_interface.extract");
            this.tooltipFailText = Component.m_237115_((String)"gui.controller_tab.axolootl.axolootl_interface.extract.fail").m_130940_(ChatFormatting.RED);
        }

        public AxolootlVariant getEntry() {
            return this.entry;
        }

        public void update(Map.Entry<AxolootlVariant, Integer> entry, boolean isActive) {
            this.entry = entry.getKey();
            this.count = entry.getValue();
            MutableComponent axolootlName = Component.m_237110_((String)"entity.axolootl.axolootl.description", (Object[])new Object[]{((EntityType)AxRegistry.EntityReg.AXOLOOTL.get()).m_20676_(), entry.getKey().getDescription()});
            this.tooltipText = Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_interface.extract_x", (Object[])new Object[]{axolootlName});
            String sText = Component.m_237110_((String)"gui.controller_tab.axolootl.axolootl_interface.entry", (Object[])new Object[]{this.count, entry.getKey().getDescription()}).getString();
            this.text = Component.m_237113_((String)StringUtil.m_144998_((String)sText, (int)14, (boolean)true));
            this.updateActive(isActive);
        }

        public void updateActive(boolean isActive) {
            this.f_93623_ = isActive && this.count > 0 && this.entry != AxolootlVariant.EMPTY;
            this.m_93666_(this.f_93623_ ? this.tooltipText : this.tooltipFailText);
        }

        public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            float f = this.f_93620_ + 14 + 4;
            float f2 = this.f_93621_;
            Objects.requireNonNull(this.font);
            this.font.m_92889_(pPoseStack, this.text, f, f2 + (float)(this.f_93619_ - 9) / 2.0f, 0);
            super.m_6303_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }
}

