/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.block.AbstractInterfaceBlock;
import axolootl.block.entity.WaterInterfaceBlockEntity;
import axolootl.client.menu.CyclingContainerScreen;
import axolootl.menu.CyclingContainerMenu;
import axolootl.util.TankMultiblock;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FluidInterfaceScreen
extends CyclingContainerScreen {
    private static final int FLUID_X = 29;
    private static final int FLUID_Y = 17;
    private static final int FLUID_WIDTH = 18;
    private static final int FLUID_HEIGHT = 72;
    private static final int FLUID_U = 55;
    private static final int FLUID_V = 50;
    private static final int FLUID_MARGIN = 2;
    private static final int TEXT_X = 51;
    private static final int TEXT_Y = 25;
    private static final int TEXT_WIDTH = 162;
    private static final int TEXT_LINE_SPACING = 8;
    private WaterInterfaceBlockEntity blockEntity;
    private IFluidHandler storage;
    private FluidStack fluidStack;
    private long volume;
    private float totalFluidPercent;
    private int totalFluidHeight;
    private int totalCapacity;
    private int textureWidth = Math.min(9, ((CyclingContainerMenu)this.m_6262_()).getContainerSize()) * 18;
    public static final String PREFIX = "gui.controller_tab.axolootl.fluid_interface.";
    private Component volumeText;
    private Component capacityText;
    private Component storageText;
    private Component statusText;
    private Component statusDescriptionText;

    public FluidInterfaceScreen(CyclingContainerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        BlockEntity blockEntity = pPlayerInventory.f_35978_.f_19853_.m_7702_(((CyclingContainerMenu)this.m_6262_()).getBlockPos());
        this.storage = blockEntity != null ? (IFluidHandler)blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse((Object)EmptyFluidHandler.INSTANCE) : EmptyFluidHandler.INSTANCE;
        this.fluidStack = this.storage.getFluidInTank(0);
        if (((CyclingContainerMenu)this.m_6262_()).hasTank()) {
            this.volume = ((CyclingContainerMenu)this.m_6262_()).getController().get().getSize().orElse(TankMultiblock.Size.EMPTY).getInnerVolume();
        }
        this.volumeText = Component.m_237110_((String)"gui.controller_tab.axolootl.fluid_interface.volume", (Object[])new Object[]{this.volume});
        BlockEntity blockEntity2 = ((CyclingContainerMenu)this.m_6262_()).getInventory().f_35978_.f_19853_.m_7702_(pMenu.getBlockPos());
        if (blockEntity2 instanceof WaterInterfaceBlockEntity) {
            WaterInterfaceBlockEntity be;
            this.blockEntity = be = (WaterInterfaceBlockEntity)blockEntity2;
        }
    }

    @Override
    protected void renderContainerSlots(PoseStack pPoseStack, float pPartialTick, int pMouseX, int pMouseY) {
        int x = this.f_97735_ + 30;
        int y = this.f_97736_ + 18 + 90;
        RenderSystem.m_157456_((int)0, (ResourceLocation)SLOTS);
        this.m_93228_(pPoseStack, x - 1, y - 1, 29, 17, this.textureWidth, this.textureHeight);
        this.m_93228_(pPoseStack, x, y - 1, 240, 0, 16, 16);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_181908_();
    }

    protected void m_181908_() {
        super.m_181908_();
        this.fluidStack = this.storage.getFluidInTank(0);
        this.totalCapacity = this.storage.getTankCapacity(0);
        this.totalFluidPercent = (float)this.fluidStack.getAmount() / (float)Math.max(1, this.totalCapacity);
        this.totalFluidHeight = Mth.m_14143_((float)(this.totalFluidPercent * 72.0f));
        if (!this.fluidStack.isEmpty()) {
            this.totalFluidHeight = Mth.m_14045_((int)this.totalFluidHeight, (int)1, (int)68);
        }
        this.capacityText = Component.m_237110_((String)"gui.controller_tab.axolootl.fluid_interface.capacity", (Object[])new Object[]{this.totalCapacity});
        this.storageText = Component.m_237110_((String)"gui.controller_tab.axolootl.fluid_interface.storage", (Object[])new Object[]{this.fluidStack.getAmount(), this.totalCapacity});
        String status = this.getStatus();
        this.statusDescriptionText = Component.m_237115_((String)("gui.controller_tab.axolootl.fluid_interface.status." + status + ".description"));
        this.statusText = Component.m_237110_((String)"gui.controller_tab.axolootl.fluid_interface.status", (Object[])new Object[]{Component.m_237115_((String)("gui.controller_tab.axolootl.fluid_interface.status." + status))}).m_130938_(a -> a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)this.statusDescriptionText)));
    }

    @Override
    protected void renderBgTexture(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        super.renderBgTexture(poseStack, partialTick, mouseX, mouseY);
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
        this.m_93228_(poseStack, this.f_97735_ + 29, this.f_97736_ + 93, 226, 0, 18, 10);
    }

    @Override
    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderFluidBar(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderDetails(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderHoverActions(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    private String getStatus() {
        BlockState blockState = ((CyclingContainerMenu)this.m_6262_()).getInventory().f_35978_.f_19853_.m_8055_(((CyclingContainerMenu)this.m_6262_()).getBlockPos());
        if (blockState.m_61138_((Property)AbstractInterfaceBlock.POWERED) && ((Boolean)blockState.m_61143_((Property)AbstractInterfaceBlock.POWERED)).booleanValue()) {
            return "paused";
        }
        if (this.blockEntity != null && this.blockEntity.isObstructed()) {
            return "obstructed";
        }
        if (this.fluidStack.isEmpty() || this.fluidStack.getAmount() < 1000) {
            return "empty";
        }
        return "active";
    }

    private void renderDetails(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int x = this.f_97735_ + 51;
        int y = this.f_97736_ + 25;
        y += this.renderWrappedText(poseStack, this.volumeText, x, y, 162, 0) + 8;
        y += this.renderWrappedText(poseStack, this.storageText, x, y, 162, 0) + 8;
        y += this.renderWrappedText(poseStack, this.statusText, x, y, 162, 0) + 8;
    }

    private void renderFluidBar(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int x = this.f_97735_ + 29;
        int y = this.f_97736_ + 17;
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
        this.m_93228_(poseStack, x, y, 55, 50, 18, 72);
        x = this.f_97735_ + 29 + 2;
        y = this.f_97736_ + 17 + (72 - this.totalFluidHeight) - 2;
        int width = 14;
        FluidInterfaceScreen.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + this.totalFluidHeight), (int)-1);
        this.renderFluid(poseStack, x, y, width, this.totalFluidHeight, this.fluidStack);
    }

    private void renderFluid(PoseStack poseStack, int x, int y, int width, int height, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid.m_6212_(Fluids.f_76191_) || fluidStack.getAmount() <= 0) {
            return;
        }
        IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation stillTexture = fluidExtensions.getStillTexture(fluidStack);
        TextureAtlasSprite stillTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillTexture);
        int textureWidth = stillTextureSprite.m_118405_();
        int textureHeight = stillTextureSprite.m_118408_();
        int fluidColor = fluidExtensions.getTintColor(fluidStack);
        float red = (float)FastColor.ARGB32.m_13665_((int)fluidColor) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)fluidColor) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)fluidColor) / 255.0f;
        float alpha = (float)FastColor.ARGB32.m_13655_((int)fluidColor) / 255.0f;
        FluidInterfaceScreen.m_239260_((int)x, (int)y, (int)(x + width), (int)(y + height));
        RenderSystem.m_69478_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
        int xCount = Mth.m_14167_((float)((float)width / (float)textureWidth));
        for (int i = 0; i < xCount; ++i) {
            int yCount = Mth.m_14167_((float)((float)height / (float)textureHeight));
            for (int j = 0; j < yCount; ++j) {
                FluidInterfaceScreen.m_93200_((PoseStack)poseStack, (int)(x + i * textureWidth), (int)(y + j * textureHeight), (int)(this.m_93252_() + 100), (int)textureWidth, (int)textureHeight, (TextureAtlasSprite)stillTextureSprite);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        RenderSystem.m_69471_();
    }

    private void renderHoverActions(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int x = 51;
        int y = 41 + this.f_96547_.m_239133_((FormattedText)this.volumeText, 162) + this.f_96547_.m_239133_((FormattedText)this.storageText, 162);
        if (this.m_6774_(x, y, this.f_96547_.m_92852_((FormattedText)this.statusText), this.f_96547_.m_239133_((FormattedText)this.statusText, 162), mouseX, mouseY)) {
            this.m_96570_(poseStack, this.statusText.m_7383_(), mouseX, mouseY);
        }
        if (this.m_6774_(x = 29, y = 17, 18, 72 - this.totalFluidHeight - 1, mouseX, mouseY)) {
            this.m_96602_(poseStack, this.capacityText, mouseX, mouseY);
        }
        if (this.m_6774_(x, y += 72 - this.totalFluidHeight + 1, 18, this.totalFluidHeight, mouseX, mouseY)) {
            this.m_96602_(poseStack, this.storageText, mouseX, mouseY);
        }
    }
}

