/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.client.menu.widget.CycleButton;
import axolootl.menu.AbstractControllerMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringUtil;

public interface ICycleProvider {
    default public int calculateTitleStartX(int imageWidth, int textWidth) {
        return (imageWidth - textWidth) / 2;
    }

    default public List<CycleButton> initCycleButtons(AbstractContainerScreen<? extends AbstractControllerMenu> screen) {
        ArrayList<CycleButton> list = new ArrayList<CycleButton>();
        list.add(this.addCycleButton(7, 4, true, b -> {
            this.cycle(-1);
            this.setCycleButtonsVisible(false);
        }));
        list.add(this.addCycleButton(screen.getXSize() - 27 - 7, 4, false, b -> {
            this.cycle(1);
            this.setCycleButtonsVisible(false);
        }));
        return list;
    }

    default public void renderCycleTooltip(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        for (CycleButton button : this.getCycleButtons()) {
            if (!button.m_198029_()) continue;
            button.m_7428_(poseStack, mouseX, mouseY);
        }
    }

    default public Component createCycledTitle(Component title, BlockPos pos, int cycle, int maxCycle) {
        int maxSize = maxCycle > 1 ? 23 : 36;
        String sTitle = StringUtil.m_144998_((String)title.getString(), (int)maxSize, (boolean)true);
        MutableComponent tooltip = Component.m_237119_().m_7220_(title).m_130946_("\n").m_130946_("(" + pos.m_123344_() + ")");
        return Component.m_237119_().m_7220_((Component)Component.m_237110_((String)"gui.axolootl.cycle.tooltip", (Object[])new Object[]{cycle + 1, maxCycle}).m_130940_(ChatFormatting.DARK_BLUE)).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)sTitle).m_130940_(ChatFormatting.BLACK)).m_130938_(arg_0 -> ICycleProvider.lambda$createCycledTitle$2((Component)tooltip, arg_0));
    }

    public CycleButton addCycleButton(int var1, int var2, boolean var3, Button.OnPress var4);

    public Component getCycledTitle();

    public void cycle(int var1);

    public int getCycle();

    public List<CycleButton> getCycleButtons();

    default public void setCycleButtonsVisible(boolean visible) {
        for (CycleButton button : this.getCycleButtons()) {
            button.f_93624_ = visible;
        }
    }

    default public void setCycleButtonsEnabled(boolean enabled) {
        for (CycleButton button : this.getCycleButtons()) {
            button.f_93623_ = enabled;
        }
    }

    private static /* synthetic */ Style lambda$createCycledTitle$2(Component tooltip, Style a) {
        return a.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tooltip));
    }
}

