/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.client.menu.widget.TabButton;
import axolootl.client.menu.widget.TabGroupButton;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.menu.AbstractControllerMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public interface ITabProvider {
    public static final int MIN_TOOLTIP_Y = 18;

    default public int calculateTopPos(AbstractContainerScreen<?> screen) {
        int tabHeight = 18;
        return Math.max(screen.getGuiTop(), 18);
    }

    default public List<TabButton> initTabs(AbstractContainerScreen<? extends AbstractControllerMenu> screen) {
        ArrayList<TabButton> list = new ArrayList<TabButton>();
        int y = -21;
        int n = this.getTabsPerGroup();
        for (int i = 0; i < n; ++i) {
            int index = i;
            list.add(this.addTabButton(i * 44, y, i));
        }
        return list;
    }

    default public List<TabGroupButton> initTabGroups(AbstractContainerScreen<? extends AbstractControllerMenu> screen) {
        ArrayList<TabGroupButton> list = new ArrayList<TabGroupButton>();
        int y = -16;
        list.add(this.addTabGroupButton(0, y, true, b -> this.setTabGroup(this.getTabGroup() - 1)));
        list.add(this.addTabGroupButton(screen.getXSize() - 24, y, false, b -> this.setTabGroup(this.getTabGroup() + 1)));
        return list;
    }

    default public void renderTabTooltip(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        for (TabButton tabButton : this.getTabButtons()) {
            if (!tabButton.m_198029_()) continue;
            tabButton.m_7428_(poseStack, mouseX, Math.max(mouseY, 18));
        }
    }

    public TabButton addTabButton(int var1, int var2, int var3);

    public TabGroupButton addTabGroupButton(int var1, int var2, boolean var3, Button.OnPress var4);

    public void setTab(int var1);

    public int getTab();

    public void setTabGroup(int var1);

    public int getTabGroup();

    public List<TabButton> getTabButtons();

    public List<TabGroupButton> getTabGroupButtons();

    default public int getTabsPerGroup() {
        return 5;
    }

    default public int calculateTabGroup(int tab) {
        int maxPerGroup = this.getTabsPerGroup();
        int groupCount = this.calculateGroupCount();
        if (tab < maxPerGroup - 1) {
            return 0;
        }
        if (tab % Math.max(1, maxPerGroup - 2) == 1) {
            int groupIndex = (tab - 1) / Math.max(1, maxPerGroup - 2);
            return groupCount > groupIndex ? groupIndex : groupIndex - 1;
        }
        return (tab + 1) / Math.max(1, maxPerGroup - 2) - 1;
    }

    default public int calculateGroupCount() {
        int maxPerGroup;
        int tabCount = AxRegistry.AquariumTabsReg.getTabCount();
        if (tabCount <= (maxPerGroup = this.getTabsPerGroup())) {
            return 1;
        }
        return tabCount / Math.max(1, maxPerGroup - 2);
    }

    default public int validateTab(int tab) {
        return Mth.m_14045_((int)tab, (int)0, (int)(AxRegistry.AquariumTabsReg.getTabCount() - 1));
    }

    default public int validateTabGroup(int tabGroup) {
        return Mth.m_14045_((int)tabGroup, (int)0, (int)(this.calculateGroupCount() - 1));
    }

    default public void onTabGroupUpdated(ControllerBlockEntity controller) {
        int group = this.getTabGroup();
        int maxGroup = this.calculateGroupCount() - 1;
        List<IAquariumTab> sortedTabs = AxRegistry.AquariumTabsReg.getSortedTabs();
        List<TabButton> tabButtons = this.getTabButtons();
        List<TabGroupButton> tabGroupButtons = this.getTabGroupButtons();
        int n = tabButtons.size();
        int index = group * (this.getTabsPerGroup() - 1);
        for (int i = 0; i < n; ++i) {
            Button.OnPress onPress;
            boolean active;
            TabButton button = this.getTabButtons().get(i);
            if (i == 0) {
                button.f_93623_ = button.f_93624_ = (active = group <= 0);
                if (!active) continue;
            }
            if (i == n - 1) {
                button.f_93623_ = button.f_93624_ = (active = group > maxGroup);
                if (!active) continue;
            }
            if (index >= sortedTabs.size()) {
                button.f_93624_ = false;
                button.f_93623_ = false;
                continue;
            }
            button.f_93624_ = true;
            button.f_93623_ = true;
            IAquariumTab tab = sortedTabs.get(index);
            ArrayList<Component> messages = new ArrayList<Component>();
            if (tab.isAvailable(controller)) {
                messages.add(tab.getTitle(true));
                int onPressIndex = index;
                onPress = b -> {
                    this.setTab(onPressIndex);
                    this.setTabsEnabled(false);
                };
            } else {
                messages.add(tab.getTitle(false));
                messages.add((Component)Component.m_237115_((String)"gui.controller_tab.not_enabled"));
                onPress = b -> {};
            }
            button.setIndex(i, tab.getIcon(), messages, onPress);
            button.setSelected(i == this.getTab());
            button.setSelected(index == this.getTab());
            ++index;
        }
        if (tabGroupButtons.size() != 2) {
            Axolootl.LOGGER.warn("[ITabProvider#onTabGroupUpdated] Invalid tab group button size; expected 2 but got " + tabGroupButtons.size());
            return;
        }
        TabGroupButton b2 = tabGroupButtons.get(0);
        b2.f_93623_ = group > 0;
        b2.f_93624_ = b2.f_93623_;
        b2 = tabGroupButtons.get(1);
        b2.f_93623_ = group < maxGroup;
        b2.f_93624_ = b2.f_93623_;
    }

    default public void setTabsEnabled(boolean enabled) {
        for (TabButton tabButton : this.getTabButtons()) {
            tabButton.f_93623_ = enabled;
        }
    }
}

