/*
 * Decompiled with CFR 0.152.
 */
package axolootl.client.menu.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScrollButton
extends Button {
    protected final ResourceLocation resourceLocation;
    protected final int iconU;
    protected final int iconV;
    protected final int iconWidth;
    protected final int iconHeight;
    protected final int iconDeltaV;
    protected final boolean isVertical;
    protected final float scrollAmountMultiplier;
    protected final IScrollListener listener;
    protected float scrollPercent;
    protected boolean dragging;

    public ScrollButton(int x, int y, int width, int height, ResourceLocation resourceLocation, int iconU, int iconV, int iconWidth, int iconHeight, int iconDeltaV, boolean isVertical, float scrollAmountMultiplier, IScrollListener listener) {
        super(x, y, Math.max(1, width), Math.max(1, height), (Component)Component.m_237119_(), b -> {});
        this.resourceLocation = resourceLocation;
        this.iconU = iconU;
        this.iconV = iconV;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.iconDeltaV = iconDeltaV;
        this.isVertical = isVertical;
        this.scrollAmountMultiplier = scrollAmountMultiplier;
        this.listener = listener;
        this.scrollPercent = 0.0f;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.resourceLocation);
            int v = this.iconV;
            if (!this.m_142518_()) {
                v += this.iconDeltaV;
            }
            int renderX = this.f_93620_;
            int renderY = this.f_93621_;
            if (this.isVertical) {
                renderY += Mth.m_14143_((float)((float)(this.f_93619_ - this.iconHeight) * this.scrollPercent));
            } else {
                renderX += Mth.m_14143_((float)((float)(this.f_93618_ - this.iconWidth) * this.scrollPercent));
            }
            ScrollButton.m_93172_((PoseStack)poseStack, (int)renderX, (int)renderY, (int)(renderX + this.iconWidth), (int)(renderY + this.iconHeight), (int)0xFFFF00);
            this.m_93228_(poseStack, renderX, renderY, this.iconU, v, this.iconWidth, this.iconHeight);
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.dragging = true;
        this.setValueFromMouse(mouseX, mouseY);
        super.m_5716_(mouseX, mouseY);
    }

    public void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.dragging = true;
        this.setValueFromMouse(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.m_142518_()) {
            float scrollPercent = Mth.m_14036_((float)(this.scrollPercent - (float)amount * this.scrollAmountMultiplier), (float)0.0f, (float)1.0f);
            this.setScrollPercent(scrollPercent);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    protected void setValueFromMouse(double mouseX, double mouseY) {
        float scrollPercent = (float)((this.isVertical ? mouseY - (double)this.f_93621_ : mouseX - (double)this.f_93620_) / (double)this.f_93619_);
        this.setScrollPercent(Mth.m_14036_((float)scrollPercent, (float)0.0f, (float)1.0f));
    }

    public void setScrollPercent(float scrollPercent) {
        this.scrollPercent = scrollPercent;
        this.listener.onScroll(this, scrollPercent);
    }

    public double getScrollPercent() {
        return this.scrollPercent;
    }

    @FunctionalInterface
    public static interface IScrollListener {
        public void onScroll(ScrollButton var1, float var2);
    }
}

