/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.ModifierSettings;
import axolootl.data.aquarium_modifier.condition.FalseModifierCondition;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import axolootl.data.aquarium_modifier.condition.TrueModifierCondition;
import axolootl.util.AxCodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class AquariumModifier {
    public static final AquariumModifier EMPTY = new AquariumModifier("empty", ModifierSettings.EMPTY, new Vec3i(1, 1, 1), BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190435_()), FalseModifierCondition.INSTANCE);
    public static final Codec<AquariumModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("translation_key").forGetter(AquariumModifier::getTranslationKey), (App)ModifierSettings.CODEC.fieldOf("settings").forGetter(AquariumModifier::getSettings), (App)AxCodecUtils.POSITIVE_VEC3I_CODEC.optionalFieldOf("dimensions", (Object)new Vec3i(1, 1, 1)).forGetter(AquariumModifier::getDimensions), (App)BlockPredicate.f_190392_.optionalFieldOf("block", (Object)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_190435_())).forGetter(AquariumModifier::getBlockStatePredicate), (App)ModifierCondition.DIRECT_CODEC.optionalFieldOf("condition", (Object)TrueModifierCondition.INSTANCE).forGetter(AquariumModifier::getCondition)).apply((Applicative)instance, AquariumModifier::new));
    public static final Codec<Holder<AquariumModifier>> HOLDER_CODEC = RegistryFileCodec.m_135589_(AxRegistry.Keys.AQUARIUM_MODIFIERS, CODEC);
    public static final Codec<HolderSet<AquariumModifier>> HOLDER_SET_CODEC = RegistryCodecs.m_206279_(AxRegistry.Keys.AQUARIUM_MODIFIERS, CODEC);
    private final String translationKey;
    private final ModifierSettings settings;
    private final Vec3i dimensions;
    private final BlockPredicate blockStatePredicate;
    private final ModifierCondition condition;
    private Component description;
    private Holder<AquariumModifier> holder;

    public AquariumModifier(String translationKey, ModifierSettings settings, Vec3i dimensions, BlockPredicate blockStatePredicate, ModifierCondition condition) {
        this.translationKey = translationKey;
        this.settings = settings;
        this.dimensions = dimensions;
        this.blockStatePredicate = blockStatePredicate;
        this.condition = condition;
    }

    public static Registry<AquariumModifier> getRegistry(RegistryAccess access) {
        return AxRegistry.AQUARIUM_MODIFIERS_REGISTRY_SUPPLIER.apply(access);
    }

    public static Optional<AquariumModifier> forBlock(LevelAccessor level, BlockPos pos) {
        ServerLevel serverLevel = (ServerLevel)level;
        for (AquariumModifier entry : AquariumModifier.getRegistry(level.m_5962_())) {
            if (!entry.isApplicable(serverLevel, pos)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    public boolean is(RegistryAccess registryAccess, TagKey<AquariumModifier> tagKey) {
        return this.getHolder(registryAccess).m_203656_(tagKey);
    }

    public ResourceLocation getRegistryName(RegistryAccess registryAccess) {
        return Optional.ofNullable(AquariumModifier.getRegistry(registryAccess).m_7981_((Object)this)).orElseThrow(() -> new IllegalStateException("Missing key in AquariumModifier registry for object " + this.toString()));
    }

    public List<TagKey<AquariumModifier>> getReverseTags(RegistryAccess access) {
        Holder<AquariumModifier> self = this.getHolder(access);
        return AquariumModifier.getRegistry(access).m_203612_().filter(pair -> ((HolderSet.Named)pair.getSecond()).m_203333_(self)).map(Pair::getFirst).toList();
    }

    public boolean isApplicable(ServerLevel level, BlockPos pos) {
        return this.blockStatePredicate.test((Object)level, (Object)pos);
    }

    public boolean isActive(AquariumModifierContext context) {
        return this.condition.test(context);
    }

    public boolean isMultiblock() {
        return this.dimensions.m_123341_() > 1 || this.dimensions.m_123342_() > 1 || this.dimensions.m_123343_() > 1;
    }

    public Optional<BlockPos> checkAndSpread(AquariumModifierContext context) {
        double spreadSpeed = this.settings.getSpreadSpeed();
        if (!(spreadSpeed > 0.0) || context.getLevel().m_213780_().m_188500_() > spreadSpeed) {
            return Optional.empty();
        }
        BlockState blockState = context.getLevel().m_8055_(context.getPos());
        Optional<BlockPos> oPos = this.findSpreadablePosition(context);
        if (oPos.isEmpty()) {
            return Optional.empty();
        }
        BlockPos pos = oPos.get().m_7949_();
        if (!context.getLevel().m_7731_(pos, blockState, 3)) {
            return Optional.empty();
        }
        context.getLevel().m_5594_(null, pos, blockState.m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 0.8f + context.getLevel().m_213780_().m_188501_() * 0.4f);
        context.getLevel().m_46796_(2005, pos, 0);
        return Optional.of(pos);
    }

    protected Optional<BlockPos> findSpreadablePosition(AquariumModifierContext context) {
        if (!context.hasTank()) {
            return Optional.empty();
        }
        BoundingBox bounds = context.getTankSize().boundingBox();
        Vec3i spreadDistance = this.settings.getSpreadSearchDistance();
        BlockPos origin = context.getPos();
        BlockState blockState = context.getLevel().m_8055_(origin);
        BlockPos fromPos = new BlockPos(Math.max(bounds.m_162395_(), origin.m_123341_() - spreadDistance.m_123341_()), Math.max(bounds.m_162396_(), origin.m_123342_() - spreadDistance.m_123342_()), Math.max(bounds.m_162398_(), origin.m_123343_() - spreadDistance.m_123343_()));
        BlockPos toPos = new BlockPos(Math.min(bounds.m_162399_(), origin.m_123341_() + spreadDistance.m_123341_()), Math.min(bounds.m_162400_(), origin.m_123342_() + spreadDistance.m_123342_()), Math.min(bounds.m_162401_(), origin.m_123343_() + spreadDistance.m_123343_()));
        int volume = (spreadDistance.m_123341_() * 2 + 1) * (spreadDistance.m_123342_() * 2 + 1) * (spreadDistance.m_123343_() * 2 + 1);
        int chance = context.getLevel().m_213780_().m_188503_(volume);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)fromPos, (BlockPos)toPos)) {
            BlockState replacing;
            if (--chance > 0 && context.getLevel().m_213780_().m_188503_(chance) != 0 || !(replacing = context.getLevel().m_8055_(pos)).m_60767_().m_76336_() || !blockState.m_60710_((LevelReader)context.getLevel(), pos)) continue;
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public ModifierSettings getSettings() {
        return this.settings;
    }

    public Vec3i getDimensions() {
        return new Vec3i(this.dimensions.m_123341_(), this.dimensions.m_123342_(), this.dimensions.m_123343_());
    }

    public BlockPredicate getBlockStatePredicate() {
        return this.blockStatePredicate;
    }

    public ModifierCondition getCondition() {
        return this.condition;
    }

    public Component getDescription() {
        if (null == this.description) {
            this.description = Component.m_237115_((String)this.getTranslationKey());
        }
        return this.description;
    }

    public Holder<AquariumModifier> getHolder(RegistryAccess registryAccess) {
        if (null == this.holder) {
            Registry<AquariumModifier> registry = AquariumModifier.getRegistry(registryAccess);
            this.holder = registry.m_206081_(ResourceKey.m_135785_(AxRegistry.Keys.AQUARIUM_MODIFIERS, (ResourceLocation)this.getRegistryName(registryAccess)));
        }
        return this.holder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AquariumModifier{");
        builder.append(" name=" + this.translationKey);
        builder.append(" settings=" + this.settings);
        builder.append(" predicate=" + this.blockStatePredicate);
        builder.append(" condition=" + this.condition);
        builder.append(" }");
        return builder.toString();
    }
}

