/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier;

import axolootl.data.aquarium_modifier.AquariumModifier;
import axolootl.entity.IAxolootl;
import axolootl.util.TankMultiblock;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.LevelAccessor;

@Immutable
public class AquariumModifierContext {
    private final LevelAccessor level;
    private final BlockPos pos;
    private final TankMultiblock.Size tankSize;
    private final Collection<IAxolootl> axolootls;
    private final Map<BlockPos, AquariumModifier> modifiers;
    private final Set<BlockPos> activeModifiers;

    public AquariumModifierContext(LevelAccessor level, BlockPos pos, TankMultiblock.Size tankSize, Collection<IAxolootl> axolootls, Map<BlockPos, AquariumModifier> modifiers, Set<BlockPos> activeModifiers) {
        this.level = level;
        this.pos = pos;
        this.tankSize = tankSize;
        this.axolootls = axolootls;
        this.modifiers = modifiers;
        this.activeModifiers = activeModifiers;
    }

    public LevelAccessor getLevel() {
        return this.level;
    }

    public RegistryAccess getRegistryAccess() {
        return this.level.m_5962_();
    }

    public TankMultiblock.Size getTankSize() {
        return this.tankSize;
    }

    public boolean hasTank() {
        return this.tankSize != null && this.tankSize != TankMultiblock.Size.EMPTY;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Collection<IAxolootl> getAxolootls() {
        return this.axolootls;
    }

    public Map<BlockPos, AquariumModifier> getModifiers() {
        return this.modifiers;
    }

    public Set<BlockPos> getActiveModifiers() {
        return this.activeModifiers;
    }

    public boolean isModifierActive(BlockPos pos) {
        return this.activeModifiers.contains(pos);
    }
}

