/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier;

import axolootl.util.AxCodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;

@Immutable
public class ModifierSettings {
    public static final ModifierSettings EMPTY = new ModifierSettings(0.0, 0.0, 0.0, 0.0, Vec3i.f_123288_, false, false, 0, false);
    public static final Codec<ModifierSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("generation", (Object)0.0).forGetter(ModifierSettings::getGenerationSpeed), (App)Codec.DOUBLE.optionalFieldOf("breed", (Object)0.0).forGetter(ModifierSettings::getBreedSpeed), (App)Codec.DOUBLE.optionalFieldOf("feed", (Object)0.0).forGetter(ModifierSettings::getFeedSpeed), (App)Codec.doubleRange((double)0.0, (double)1.0).optionalFieldOf("spread", (Object)0.0).forGetter(ModifierSettings::getSpreadSpeed), (App)AxCodecUtils.NON_NEGATIVE_VEC3I_CODEC.optionalFieldOf("spread_distance", (Object)Vec3i.f_123288_).forGetter(ModifierSettings::getSpreadSearchDistance), (App)Codec.BOOL.optionalFieldOf("enable_mob_generators", (Object)false).forGetter(ModifierSettings::isEnableMobResources), (App)Codec.BOOL.optionalFieldOf("enable_mob_breeding", (Object)false).forGetter(ModifierSettings::isEnableMobBreeding), (App)ExtraCodecs.f_144628_.optionalFieldOf("energy_cost", (Object)0).forGetter(ModifierSettings::getEnergyCost), (App)Codec.BOOL.optionalFieldOf("greedy_energy", (Object)false).forGetter(ModifierSettings::isGreedyEnergy)).apply((Applicative)instance, ModifierSettings::new));
    private final double generationSpeed;
    private final double breedSpeed;
    private final double feedSpeed;
    private final double spreadSpeed;
    private final Vec3i spreadSearchDistance;
    private final boolean enableMobResources;
    private final boolean enableMobBreeding;
    private final int energyCost;
    private final boolean greedyEnergy;

    public ModifierSettings(double generationSpeed, double breedSpeed, double feedSpeed, double spreadSpeed, Vec3i spreadSearchDistance, boolean enableMobResources, boolean enableMobBreeding, int energyCost, boolean greedyEnergy) {
        this.generationSpeed = generationSpeed;
        this.breedSpeed = breedSpeed;
        this.feedSpeed = feedSpeed;
        this.spreadSpeed = spreadSpeed;
        this.spreadSearchDistance = spreadSearchDistance;
        this.enableMobResources = enableMobResources;
        this.enableMobBreeding = enableMobBreeding;
        this.energyCost = energyCost;
        this.greedyEnergy = greedyEnergy;
    }

    public double getGenerationSpeed() {
        return this.generationSpeed;
    }

    public double getBreedSpeed() {
        return this.breedSpeed;
    }

    public double getFeedSpeed() {
        return this.feedSpeed;
    }

    public double getSpreadSpeed() {
        return this.spreadSpeed;
    }

    public Vec3i getSpreadSearchDistance() {
        return new Vec3i(this.spreadSearchDistance.m_123341_(), this.spreadSearchDistance.m_123342_(), this.spreadSearchDistance.m_123343_());
    }

    public boolean isEnableMobResources() {
        return this.enableMobResources;
    }

    public boolean isEnableMobBreeding() {
        return this.enableMobBreeding;
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    public boolean isGreedyEnergy() {
        return this.greedyEnergy;
    }
}

