/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.entity.IAxolootl;
import axolootl.util.AxCodecUtils;
import axolootl.util.DeferredHolderSet;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;

@Immutable
public class AxolootlCountModifierCondition
extends ModifierCondition {
    public static final Codec<AxolootlCountModifierCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DeferredHolderSet.codec(AxRegistry.Keys.AXOLOOTL_VARIANTS).optionalFieldOf("variant").forGetter(AxolootlCountModifierCondition::getVariant), (App)AxCodecUtils.NON_NEGATIVE_INTS_CODEC.fieldOf("count").forGetter(AxolootlCountModifierCondition::getCount)).apply((Applicative)instance, AxolootlCountModifierCondition::new));
    @Nullable
    private final DeferredHolderSet<AxolootlVariant> variant;
    private final MinMaxBounds.Ints count;

    public AxolootlCountModifierCondition(Optional<DeferredHolderSet<AxolootlVariant>> variant, MinMaxBounds.Ints count) {
        this.variant = variant.orElse(null);
        this.count = count;
    }

    public MinMaxBounds.Ints getCount() {
        return this.count;
    }

    public Optional<DeferredHolderSet<AxolootlVariant>> getVariant() {
        return Optional.ofNullable(this.variant);
    }

    @Override
    public boolean test(AquariumModifierContext context) {
        int count = 0;
        if (this.variant != null) {
            Registry registry = context.getRegistryAccess().m_175515_(AxRegistry.Keys.AXOLOOTL_VARIANTS);
            HolderSet<AxolootlVariant> holderSet = this.variant.get((Registry<AxolootlVariant>)registry);
            for (IAxolootl entry : context.getAxolootls()) {
                Optional<AxolootlVariant> oVariant = entry.getAxolootlVariant(context.getRegistryAccess());
                if (!oVariant.isPresent() || !holderSet.m_203333_(oVariant.get().getHolder(context.getRegistryAccess()))) continue;
                ++count;
            }
        } else {
            count = context.getAxolootls().size();
        }
        return this.getCount().m_55390_(count);
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.AXOLOOTL_COUNT.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        Registry registry = registryAccess.m_175515_(AxRegistry.Keys.AXOLOOTL_VARIANTS);
        if (this.variant != null) {
            return AxolootlCountModifierCondition.createCountedDescription("axolootl.modifier_condition.axolootl_count", this.count, registry, this.variant.get((Registry<AxolootlVariant>)registry), AxolootlVariant::getDescription);
        }
        if (this.count.m_55305_() != null && this.count.m_55326_() != null && ((Integer)this.count.m_55305_()).equals(this.count.m_55326_()) && (Integer)this.count.m_55305_() == 1) {
            return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.axolootl_count.any.single", (Object[])new Object[]{AxolootlCountModifierCondition.createIntDescription(this.count)}));
        }
        return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.axolootl_count.any.multiple", (Object[])new Object[]{AxolootlCountModifierCondition.createIntDescription(this.count)}));
    }

    public String toString() {
        return "axolootl_count {count=(" + Optional.ofNullable((Integer)this.getCount().m_55305_()) + "," + Optional.ofNullable((Integer)this.getCount().m_55326_()) + ") variant=" + this.getVariant().toString() + "}";
    }
}

