/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifier;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.CountModifierCondition;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import axolootl.util.DeferredHolderSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;

@Immutable
public class CountCappedModifierCondition
extends CountModifierCondition {
    public static final Codec<CountCappedModifierCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DeferredHolderSet.codec(AxRegistry.Keys.AQUARIUM_MODIFIERS).fieldOf("modifier").forGetter(CountModifierCondition::getModifiers), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("count").forGetter(CountCappedModifierCondition::getMaxCount), (App)Codec.BOOL.optionalFieldOf("active", (Object)false).forGetter(CountModifierCondition::isRequireActive)).apply((Applicative)instance, CountCappedModifierCondition::new));
    private final int maxCount;

    public CountCappedModifierCondition(CountModifierCondition copy) {
        this(copy.getModifiers(), Optional.ofNullable((Integer)copy.getCount().m_55326_()).orElse(Optional.ofNullable((Integer)copy.getCount().m_55305_()).orElse(0)), copy.isRequireActive());
    }

    public CountCappedModifierCondition(DeferredHolderSet<AquariumModifier> modifierId, int count, boolean requireActive) {
        super(modifierId, MinMaxBounds.Ints.m_154819_((int)count), requireActive);
        this.maxCount = count;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public boolean test(AquariumModifierContext context) {
        BlockPos pos = context.getPos();
        LinkedList<BlockPos> modifiers = new LinkedList<BlockPos>();
        Registry registry = context.getRegistryAccess().m_175515_(AxRegistry.Keys.AQUARIUM_MODIFIERS);
        HolderSet<AquariumModifier> holderSet = this.getModifiers().get((Registry<AquariumModifier>)registry);
        for (Map.Entry<BlockPos, AquariumModifier> entry : context.getModifiers().entrySet()) {
            if (entry.getKey().equals((Object)pos) || !holderSet.m_203333_(entry.getValue().getHolder(context.getRegistryAccess()))) continue;
            this.insertSorted(modifiers, entry.getKey());
        }
        if (modifiers.size() < this.getMaxCount()) {
            return true;
        }
        return this.sortedIndexOf(modifiers, pos) < this.getMaxCount();
    }

    private void insertSorted(List<BlockPos> list, BlockPos pos) {
        list.add(this.sortedIndexOf(list, pos), pos);
    }

    private int sortedIndexOf(List<BlockPos> list, BlockPos pos) {
        if (list.isEmpty()) {
            return 0;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (pos.compareTo((Vec3i)list.get(i)) >= 0) continue;
            return i;
        }
        return list.size();
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.COUNT_CAPPED.get();
    }

    @Override
    public String toString() {
        return "count_capped {count=(" + this.getMaxCount() + ") modifier=" + this.getModifiers() + "}";
    }
}

