/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifier;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import axolootl.util.AxCodecUtils;
import axolootl.util.DeferredHolderSet;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;

@Immutable
public class CountModifierCondition
extends ModifierCondition {
    public static final Codec<CountModifierCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DeferredHolderSet.codec(AxRegistry.Keys.AQUARIUM_MODIFIERS).fieldOf("modifier").forGetter(CountModifierCondition::getModifiers), (App)AxCodecUtils.NON_NEGATIVE_INTS_CODEC.fieldOf("count").forGetter(CountModifierCondition::getCount), (App)Codec.BOOL.optionalFieldOf("active", (Object)false).forGetter(CountModifierCondition::isRequireActive)).apply((Applicative)instance, CountModifierCondition::new));
    private final DeferredHolderSet<AquariumModifier> modifierId;
    private final MinMaxBounds.Ints count;
    private final boolean requireActive;

    public CountModifierCondition(DeferredHolderSet<AquariumModifier> modifierId, MinMaxBounds.Ints count, boolean requireActive) {
        this.modifierId = modifierId;
        this.count = count;
        this.requireActive = requireActive;
    }

    public DeferredHolderSet<AquariumModifier> getModifiers() {
        return this.modifierId;
    }

    public MinMaxBounds.Ints getCount() {
        return this.count;
    }

    public boolean isRequireActive() {
        return this.requireActive;
    }

    @Override
    public boolean test(AquariumModifierContext context) {
        int count = 0;
        Registry registry = context.getRegistryAccess().m_175515_(AxRegistry.Keys.AQUARIUM_MODIFIERS);
        HolderSet<AquariumModifier> holderSet = this.modifierId.get((Registry<AquariumModifier>)registry);
        for (Map.Entry<BlockPos, AquariumModifier> entry : context.getModifiers().entrySet()) {
            if (entry.getKey().equals((Object)context.getPos()) || !holderSet.m_203333_(entry.getValue().getHolder(context.getRegistryAccess())) || this.isRequireActive() && !context.isModifierActive(entry.getKey())) continue;
            ++count;
        }
        return this.getCount().m_55390_(count);
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.COUNT.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        Registry registry = registryAccess.m_175515_(AxRegistry.Keys.AQUARIUM_MODIFIERS);
        List<Component> modifierDescription = CountModifierCondition.createHolderSetDescription(registry, this.modifierId.get((Registry<AquariumModifier>)registry), AquariumModifier::getDescription);
        if (modifierDescription.size() == 1) {
            return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.count.single", (Object[])new Object[]{CountModifierCondition.createIntDescription(this.count), modifierDescription.get(0)}));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Component.m_237110_((String)"axolootl.modifier_condition.count.single", (Object[])new Object[]{CountModifierCondition.createIntDescription(this.count)}));
        for (Component c : modifierDescription) {
            builder.add((Object)Component.m_237113_((String)"  ").m_7220_(c));
        }
        return builder.build();
    }

    public String toString() {
        return "count {count=(" + Optional.ofNullable((Integer)this.getCount().m_55305_()) + "," + Optional.ofNullable((Integer)this.getCount().m_55326_()) + ") modifier=" + this.getModifiers() + "}";
    }
}

