/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifier;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import axolootl.util.AxCodecUtils;
import axolootl.util.DeferredHolderSet;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

@Immutable
public class DistanceModifierCondition
extends ModifierCondition {
    public static final Codec<DistanceModifierCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DeferredHolderSet.codec(AxRegistry.Keys.AQUARIUM_MODIFIERS).fieldOf("modifier").forGetter(DistanceModifierCondition::getModifier), (App)AxCodecUtils.NON_NEGATIVE_INTS_CODEC.fieldOf("distance").forGetter(DistanceModifierCondition::getDistance), (App)Vec3i.f_123287_.optionalFieldOf("offset", (Object)Vec3i.f_123288_).forGetter(DistanceModifierCondition::getOffset)).apply((Applicative)instance, DistanceModifierCondition::new));
    private final DeferredHolderSet<AquariumModifier> modifier;
    private final MinMaxBounds.Ints distance;
    private final Vec3i offset;

    public DistanceModifierCondition(DeferredHolderSet<AquariumModifier> modifier, MinMaxBounds.Ints distance, Vec3i offset) {
        this.modifier = modifier;
        this.distance = distance;
        this.offset = offset;
    }

    public DeferredHolderSet<AquariumModifier> getModifier() {
        return this.modifier;
    }

    public MinMaxBounds.Ints getDistance() {
        return this.distance;
    }

    public Vec3i getOffset() {
        return new Vec3i(this.offset.m_123341_(), this.offset.m_123342_(), this.offset.m_123343_());
    }

    @Override
    public boolean test(AquariumModifierContext context) {
        BlockPos pos = context.getPos().m_121955_(this.offset);
        Registry registry = context.getRegistryAccess().m_175515_(AxRegistry.Keys.AQUARIUM_MODIFIERS);
        HolderSet<AquariumModifier> holderSet = this.getModifier().get((Registry<AquariumModifier>)registry);
        for (Map.Entry<BlockPos, AquariumModifier> entry : context.getModifiers().entrySet()) {
            if (entry.getKey().equals((Object)context.getPos()) || !holderSet.m_203333_(entry.getValue().getHolder(context.getRegistryAccess())) || !this.isWithinDistance(pos, entry.getKey(), entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isWithinDistance(BlockPos origin, BlockPos pos, AquariumModifier modifier) {
        BlockPos modifierEnd;
        if (this.distance.m_55327_()) {
            return true;
        }
        if (!modifier.isMultiblock()) {
            return this.distance.m_55390_(origin.m_123333_((Vec3i)pos));
        }
        Vec3i dimensions = modifier.getDimensions();
        Vec3i offset = new Vec3i(dimensions.m_123341_() - 1, dimensions.m_123342_() - 1, dimensions.m_123343_() - 1);
        BlockPos modifierStart = pos.m_7918_(Math.max(0, offset.m_123341_() - 1), Math.max(0, offset.m_123342_() - 1), Math.max(0, offset.m_123343_() - 1));
        Optional oBox = BoundingBox.m_162378_((Iterable)ImmutableList.of((Object)origin, (Object)pos, (Object)modifierStart, (Object)(modifierEnd = pos.m_121955_(offset))));
        if (oBox.isEmpty()) {
            return false;
        }
        Vec3i length = ((BoundingBox)oBox.get()).m_71053_();
        int dx = Math.max(0, length.m_123341_() - dimensions.m_123341_() + 1);
        int dy = Math.max(0, length.m_123342_() - dimensions.m_123342_() + 1);
        int dz = Math.max(0, length.m_123343_() - dimensions.m_123343_() + 1);
        int totalDistance = dx + dy + dz;
        return this.distance.m_55390_(totalDistance);
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.DISTANCE.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        Registry registry = registryAccess.m_175515_(AxRegistry.Keys.AQUARIUM_MODIFIERS);
        HolderSet<AquariumModifier> holderSet = this.getModifier().get((Registry<AquariumModifier>)registry);
        return DistanceModifierCondition.createCountedDescription("axolootl.modifier_condition.distance", this.distance, registry, holderSet, AquariumModifier::getDescription);
    }

    public String toString() {
        return "distance {distance=(" + Optional.ofNullable((Integer)this.getDistance().m_55305_()) + "," + Optional.ofNullable((Integer)this.getDistance().m_55326_()) + ") modifier=" + this.getModifier() + "}";
    }
}

