/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import axolootl.util.AxCodecUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.structure.Structure;

@Immutable
public class LocationModifierCondition
extends ModifierCondition {
    public static final Codec<LocationModifierCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DoublesPosition.CODEC.optionalFieldOf("position", (Object)DoublesPosition.ANY).forGetter(LocationModifierCondition::getPosition), (App)Vec3i.f_123287_.optionalFieldOf("offset", (Object)Vec3i.f_123288_).forGetter(LocationModifierCondition::getOffset), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122885_).optionalFieldOf("biome").forGetter(LocationModifierCondition::getBiome), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_235725_).optionalFieldOf("structure").forGetter(LocationModifierCondition::getStructure), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).optionalFieldOf("dimension").forGetter(LocationModifierCondition::getDimension), (App)Codec.BOOL.optionalFieldOf("smokey").forGetter(LocationModifierCondition::getSmokey), (App)AxCodecUtils.LIGHT_PREDICATE_CODEC.optionalFieldOf("light", (Object)LightPredicate.f_51335_).forGetter(LocationModifierCondition::getLight), (App)AxCodecUtils.FLUID_PREDICATE_CODEC.optionalFieldOf("fluid", (Object)FluidPredicate.f_41094_).forGetter(LocationModifierCondition::getFluid), (App)BlockPredicate.f_190392_.optionalFieldOf("block", (Object)BlockPredicate.m_190435_()).forGetter(LocationModifierCondition::getBlock)).apply((Applicative)instance, LocationModifierCondition::new));
    private final DoublesPosition position;
    private final Vec3i offset;
    @Nullable
    private final ResourceKey<Biome> biome;
    @Nullable
    private final ResourceKey<Structure> structure;
    @Nullable
    private final ResourceKey<Level> dimension;
    @Nullable
    private final Boolean smokey;
    private final LightPredicate light;
    private final FluidPredicate fluid;
    private final BlockPredicate block;

    public LocationModifierCondition(DoublesPosition position, Vec3i offset, Optional<ResourceKey<Biome>> biome, Optional<ResourceKey<Structure>> structure, Optional<ResourceKey<Level>> dimension, Optional<Boolean> smokey, LightPredicate light, FluidPredicate fluid, BlockPredicate block) {
        this.position = position;
        this.offset = offset;
        this.biome = biome.orElse(null);
        this.structure = structure.orElse(null);
        this.dimension = dimension.orElse(null);
        this.smokey = smokey.orElse(null);
        this.light = light;
        this.fluid = fluid;
        this.block = block;
    }

    @Override
    public boolean test(AquariumModifierContext context) {
        BlockPos blockpos = context.getPos().m_121955_(this.offset);
        ServerLevel level = (ServerLevel)context.getLevel();
        if (!this.position.x.m_154810_((double)blockpos.m_123341_())) {
            return false;
        }
        if (!this.position.y.m_154810_((double)blockpos.m_123342_())) {
            return false;
        }
        if (!this.position.z.m_154810_((double)blockpos.m_123343_())) {
            return false;
        }
        if (this.dimension != null && !this.dimension.equals((Object)level.m_46472_())) {
            return false;
        }
        boolean isLoaded = level.m_46749_(blockpos);
        if (!isLoaded) {
            return false;
        }
        if (this.biome != null && !level.m_204166_(blockpos).m_203565_(this.biome)) {
            return false;
        }
        if (this.structure != null && !LocationModifierCondition.hasStructure(context.getRegistryAccess(), this.structure, level.m_215010_().m_220522_(blockpos).keySet())) {
            return false;
        }
        if (!this.getLight().m_51341_(level, blockpos)) {
            return false;
        }
        if (!this.getBlock().test((Object)level, (Object)blockpos)) {
            return false;
        }
        if (!this.getFluid().m_41104_(level, blockpos)) {
            return false;
        }
        return this.smokey == null || this.smokey == CampfireBlock.m_51248_((Level)level, (BlockPos)blockpos);
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.LOCATION.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        Component text;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!Vec3i.f_123288_.equals((Object)this.offset)) {
            builder.add((Object)Component.m_237110_((String)"axolootl.modifier_condition.location.with_offset", (Object[])new Object[]{this.offset.m_123341_(), this.offset.m_123342_(), this.offset.m_123343_()}).m_130940_(ChatFormatting.ITALIC));
        }
        if (this.position != DoublesPosition.ANY) {
            builder.addAll(this.position.getDescription());
        }
        if (this.biome != null) {
            text = LocationModifierCondition.createResourceKeyDescription(this.biome);
            builder.add((Object)Component.m_237110_((String)"axolootl.modifier_condition.location.biome", (Object[])new Object[]{text}));
        }
        if (this.structure != null) {
            text = LocationModifierCondition.createResourceKeyDescription(this.structure);
            builder.add((Object)Component.m_237110_((String)"axolootl.modifier_condition.location.structure", (Object[])new Object[]{text}));
        }
        if (this.dimension != null) {
            text = LocationModifierCondition.createResourceKeyDescription(this.dimension);
            builder.add((Object)Component.m_237110_((String)"axolootl.modifier_condition.location.dimension", (Object[])new Object[]{text}));
        }
        if (this.smokey != null) {
            builder.add((Object)Component.m_237115_((String)("axolootl.modifier_condition.location." + (this.smokey != false ? "smokey" : "not_smokey"))));
        }
        if (this.light != LightPredicate.f_51335_) {
            builder.add((Object)LocationModifierCondition.createLightDescription(this.light.f_51336_));
        }
        return builder.build();
    }

    private static boolean hasStructure(RegistryAccess registryAccess, ResourceKey<Structure> key, Set<Structure> structures) {
        Registry registry = registryAccess.m_175515_(Registry.f_235725_);
        for (Structure structure : structures) {
            Optional resourceKey = registry.m_7854_((Object)structure);
            if (resourceKey.isEmpty() || !((ResourceKey)resourceKey.get()).equals(key)) continue;
            return true;
        }
        return false;
    }

    private static Component createLightDescription(MinMaxBounds.Ints bounds) {
        if (bounds.m_55305_() != null && bounds.m_55326_() != null) {
            return Component.m_237110_((String)"axolootl.modifier_condition.location.light.range", (Object[])new Object[]{bounds.m_55305_(), bounds.m_55326_()});
        }
        if (bounds.m_55305_() != null) {
            return Component.m_237110_((String)"axolootl.modifier_condition.location.light.min", (Object[])new Object[]{bounds.m_55305_()});
        }
        if (bounds.m_55326_() != null) {
            return Component.m_237110_((String)"axolootl.modifier_condition.location.light.max", (Object[])new Object[]{bounds.m_55326_()});
        }
        return Component.m_237119_();
    }

    public DoublesPosition getPosition() {
        return this.position;
    }

    public Vec3i getOffset() {
        return new Vec3i(this.offset.m_123341_(), this.offset.m_123342_(), this.offset.m_123343_());
    }

    public Optional<ResourceKey<Biome>> getBiome() {
        return Optional.ofNullable(this.biome);
    }

    public Optional<ResourceKey<Structure>> getStructure() {
        return Optional.ofNullable(this.structure);
    }

    public Optional<ResourceKey<Level>> getDimension() {
        return Optional.ofNullable(this.dimension);
    }

    public Optional<Boolean> getSmokey() {
        return Optional.ofNullable(this.smokey);
    }

    public LightPredicate getLight() {
        return this.light;
    }

    public FluidPredicate getFluid() {
        return this.fluid;
    }

    public BlockPredicate getBlock() {
        return this.block;
    }

    public static final class DoublesPosition {
        public static final Codec<MinMaxBounds.Doubles> DOUBLES_DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("min").forGetter(o -> Optional.ofNullable((Double)o.m_55305_())), (App)Codec.DOUBLE.optionalFieldOf("max").forGetter(o -> Optional.ofNullable((Double)o.m_55326_()))).apply((Applicative)instance, (p1, p2) -> {
            if (p1.isPresent() && p2.isEmpty()) {
                return MinMaxBounds.Doubles.m_154804_((double)((Double)p1.get()));
            }
            if (p1.isEmpty() && p2.isPresent()) {
                return MinMaxBounds.Doubles.m_154808_((double)((Double)p2.get()));
            }
            if (p1.isEmpty() && p2.isEmpty()) {
                return MinMaxBounds.Doubles.f_154779_;
            }
            return MinMaxBounds.Doubles.m_154788_((double)((Double)p1.get()), (double)((Double)p2.get()));
        }));
        public static final Codec<MinMaxBounds.Doubles> DOUBLES_CODEC = Codec.either((Codec)Codec.DOUBLE, DOUBLES_DIRECT_CODEC).xmap(either -> (MinMaxBounds.Doubles)either.map(MinMaxBounds.Doubles::m_154786_, Function.identity()), o -> o.m_55305_() != null && o.m_55326_() != null && ((Double)o.m_55305_()).equals(o.m_55326_()) ? Either.left((Object)((Double)o.m_55305_())) : Either.right((Object)o));
        public static final Codec<DoublesPosition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DOUBLES_CODEC.optionalFieldOf("x").forGetter(o -> Optional.of(o.x)), (App)DOUBLES_CODEC.optionalFieldOf("y").forGetter(o -> Optional.of(o.y)), (App)DOUBLES_CODEC.optionalFieldOf("z").forGetter(o -> Optional.of(o.z))).apply((Applicative)instance, DoublesPosition::new));
        public static final DoublesPosition ANY = new DoublesPosition(Optional.empty(), Optional.empty(), Optional.empty());
        private final MinMaxBounds.Doubles x;
        private final MinMaxBounds.Doubles y;
        private final MinMaxBounds.Doubles z;
        private final List<Component> description;

        public DoublesPosition(Optional<MinMaxBounds.Doubles> x, Optional<MinMaxBounds.Doubles> y, Optional<MinMaxBounds.Doubles> z) {
            this.x = x.orElse(MinMaxBounds.Doubles.f_154779_);
            this.y = y.orElse(MinMaxBounds.Doubles.f_154779_);
            this.z = z.orElse(MinMaxBounds.Doubles.f_154779_);
            ImmutableList.Builder builder = ImmutableList.builder();
            if (!this.x.m_55327_()) {
                builder.add((Object)DoublesPosition.createDescription("x", this.x));
            }
            if (!this.y.m_55327_()) {
                builder.add((Object)DoublesPosition.createDescription("y", this.y));
            }
            if (!this.z.m_55327_()) {
                builder.add((Object)DoublesPosition.createDescription("z", this.z));
            }
            this.description = builder.build();
        }

        private static Component createDescription(String axis, MinMaxBounds.Doubles bounds) {
            MutableComponent axisText = Component.m_237115_((String)("axolootl.modifier_condition.location.position." + axis));
            if (bounds.m_55305_() != null && bounds.m_55326_() != null) {
                return Component.m_237110_((String)"axolootl.modifier_condition.location.position.range", (Object[])new Object[]{axisText, ((Double)bounds.m_55305_()).longValue(), ((Double)bounds.m_55326_()).longValue()});
            }
            if (bounds.m_55305_() != null) {
                return Component.m_237110_((String)"axolootl.modifier_condition.location.position.min", (Object[])new Object[]{axisText, ((Double)bounds.m_55305_()).longValue()});
            }
            if (bounds.m_55326_() != null) {
                return Component.m_237110_((String)"axolootl.modifier_condition.location.position.max", (Object[])new Object[]{axisText, ((Double)bounds.m_55326_()).longValue()});
            }
            return Component.m_237119_();
        }

        public MinMaxBounds.Doubles getX() {
            return this.x;
        }

        public MinMaxBounds.Doubles getY() {
            return this.y;
        }

        public MinMaxBounds.Doubles getZ() {
            return this.z;
        }

        public List<Component> getDescription() {
            return this.description;
        }
    }
}

