/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;

@Immutable
public class OrModifierCondition
extends ModifierCondition {
    public static final Codec<OrModifierCondition> CODEC = LIST_CODEC.xmap(OrModifierCondition::new, OrModifierCondition::getChildren).fieldOf("children").codec();
    private final List<ModifierCondition> children;

    public OrModifierCondition(List<ModifierCondition> children) {
        this.children = ImmutableList.copyOf(children);
    }

    public List<ModifierCondition> getChildren() {
        return this.children;
    }

    @Override
    public boolean test(AquariumModifierContext aquariumModifierContext) {
        for (ModifierCondition child : this.children) {
            if (!child.test(aquariumModifierContext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.OR.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        ArrayList<Component> builder = new ArrayList<Component>();
        for (ModifierCondition child : this.children) {
            for (Component c : child.createDescription(registryAccess)) {
                builder.add((Component)Component.m_237113_((String)"  ").m_7220_(c));
                builder.add((Component)Component.m_237115_((String)"axolootl.modifier_condition.or"));
            }
        }
        if (!builder.isEmpty()) {
            builder.remove(builder.size() - 1);
        }
        return builder;
    }

    public String toString() {
        return "or {" + this.children.toString() + "}";
    }
}

