/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.aquarium_modifier.condition;

import axolootl.AxRegistry;
import axolootl.data.aquarium_modifier.AquariumModifierContext;
import axolootl.data.aquarium_modifier.condition.ModifierCondition;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;

@Immutable
public class RandomChanceModifierCondition
extends ModifierCondition {
    public static final Codec<RandomChanceModifierCondition> CODEC = Codec.doubleRange((double)0.0, (double)1.0).xmap(RandomChanceModifierCondition::new, RandomChanceModifierCondition::getChance).fieldOf("chance").codec();
    private final double chance;

    public RandomChanceModifierCondition(double chance) {
        this.chance = chance;
    }

    public double getChance() {
        return this.chance;
    }

    @Override
    public boolean test(AquariumModifierContext aquariumModifierContext) {
        return this.getChance() > 0.0 && aquariumModifierContext.getLevel().m_213780_().m_188500_() < this.getChance();
    }

    @Override
    public Codec<? extends ModifierCondition> getCodec() {
        return (Codec)AxRegistry.ModifierConditionsReg.EXISTS.get();
    }

    @Override
    public List<Component> createDescription(RegistryAccess registryAccess) {
        String sChance = String.format("%.4f", this.chance * 100.0).replaceAll("0*$", "").replaceAll("\\.$", "");
        return ImmutableList.of((Object)Component.m_237110_((String)"axolootl.modifier_condition.random_chance", (Object[])new Object[]{sChance}));
    }

    public String toString() {
        return "chance {" + this.chance + "}";
    }
}

