/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.axolootl_variant;

import axolootl.AxRegistry;
import axolootl.data.axolootl_variant.AxolootlModelSettings;
import axolootl.data.axolootl_variant.Bonuses;
import axolootl.data.axolootl_variant.BonusesProvider;
import axolootl.data.axolootl_variant.condition.FalseForgeCondition;
import axolootl.data.axolootl_variant.condition.ForgeCondition;
import axolootl.data.axolootl_variant.condition.TrueForgeCondition;
import axolootl.data.resource_generator.EmptyResourceGenerator;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.data.resource_generator.ResourceType;
import axolootl.data.resource_generator.ResourceTypes;
import axolootl.util.AxCodecUtils;
import axolootl.util.DeferredHolderSet;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class AxolootlVariant {
    public static final AxolootlVariant EMPTY = new AxolootlVariant(FalseForgeCondition.INSTANCE, "empty", 0, false, Rarity.COMMON, AxolootlModelSettings.EMPTY, 0, (List<BonusesProvider>)ImmutableList.of(), new DeferredHolderSet<Item>((List<ResourceKey<Item>>)ImmutableList.of()), (Holder<ResourceGenerator>)Holder.m_205709_((Object)EmptyResourceGenerator.INSTANCE));
    public static final Codec<AxolootlVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeCondition.DIRECT_CODEC.optionalFieldOf("condition", (Object)TrueForgeCondition.INSTANCE).forGetter(AxolootlVariant::getCondition), (App)Codec.STRING.fieldOf("translation_key").forGetter(AxolootlVariant::getTranslationKey), (App)ExtraCodecs.f_144628_.optionalFieldOf("tier", (Object)1).forGetter(AxolootlVariant::getTier), (App)Codec.BOOL.optionalFieldOf("fire_immune", (Object)false).forGetter(AxolootlVariant::isFireImmune), (App)AxCodecUtils.RARITY_CODEC.optionalFieldOf("rarity", (Object)Rarity.COMMON).forGetter(AxolootlVariant::getRarity), (App)AxolootlModelSettings.CODEC.optionalFieldOf("model", (Object)AxolootlModelSettings.EMPTY).forGetter(AxolootlVariant::getModelSettings), (App)ExtraCodecs.f_144628_.optionalFieldOf("energy_cost", (Object)0).forGetter(AxolootlVariant::getEnergyCost), (App)BonusesProvider.CODEC.listOf().optionalFieldOf("food", BonusesProvider.FISH_BONUS_PROVIDERS).forGetter(AxolootlVariant::getFoods), (App)DeferredHolderSet.codec(ForgeRegistries.ITEMS.getRegistryKey()).optionalFieldOf("breed_food", new DeferredHolderSet(ImmutableList.of())).forGetter(AxolootlVariant::getBreedFood), (App)ResourceGenerator.HOLDER_CODEC.optionalFieldOf("resource_generator", (Object)Holder.m_205709_((Object)EmptyResourceGenerator.INSTANCE)).forGetter(AxolootlVariant::getResourceGenerator)).apply((Applicative)instance, AxolootlVariant::new));
    public static final Codec<ResourceKey<AxolootlVariant>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(AxRegistry.Keys.AXOLOOTL_VARIANTS);
    public static final Codec<Holder<AxolootlVariant>> HOLDER_CODEC = RegistryFileCodec.m_135592_(AxRegistry.Keys.AXOLOOTL_VARIANTS, CODEC, (boolean)false);
    public static final Codec<HolderSet<AxolootlVariant>> HOLDER_SET_CODEC = RegistryCodecs.m_206279_(AxRegistry.Keys.AXOLOOTL_VARIANTS, CODEC);
    private final ForgeCondition condition;
    private final String translationKey;
    private final int tier;
    private final boolean isFireImmune;
    private final Rarity rarity;
    private final AxolootlModelSettings axolootlModelSettings;
    private final int energyCost;
    private final List<BonusesProvider> foods;
    private final DeferredHolderSet<Item> breedFood;
    private final Holder<ResourceGenerator> resourceGenerator;
    private Component description;
    private Component tierDescription;
    private ResourceLocation id;
    private Holder<AxolootlVariant> holder;

    public AxolootlVariant(ForgeCondition condition, String translationKey, int tier, boolean isFireImmune, Rarity rarity, AxolootlModelSettings axolootlModelSettings, int energyCost, List<BonusesProvider> foods, DeferredHolderSet<Item> breedFood, Holder<ResourceGenerator> resourceGenerator) {
        this.condition = condition;
        this.translationKey = translationKey;
        this.tier = tier;
        this.isFireImmune = isFireImmune;
        this.rarity = rarity;
        this.axolootlModelSettings = axolootlModelSettings;
        this.energyCost = energyCost;
        this.foods = ImmutableList.copyOf(foods);
        this.breedFood = breedFood;
        this.resourceGenerator = resourceGenerator;
    }

    public static Registry<AxolootlVariant> getRegistry(RegistryAccess access) {
        return AxRegistry.AXOLOOTL_VARIANTS_REGISTRY_SUPPLIER.apply(access);
    }

    public boolean is(RegistryAccess registryAccess, TagKey<AxolootlVariant> tagKey) {
        return this.getHolder(registryAccess).m_203656_(tagKey);
    }

    public ResourceLocation getRegistryName(RegistryAccess registryAccess) {
        if (null == this.id) {
            this.id = Optional.ofNullable(AxolootlVariant.getRegistry(registryAccess).m_7981_((Object)this)).orElseThrow(() -> new IllegalStateException("Missing key in Axolootl Variant registry for object " + this.toString()));
        }
        return this.id;
    }

    public Holder<AxolootlVariant> getHolder(RegistryAccess registryAccess) {
        if (null == this.holder) {
            this.holder = AxolootlVariant.getRegistry(registryAccess).m_206081_(ResourceKey.m_135785_(AxRegistry.Keys.AXOLOOTL_VARIANTS, (ResourceLocation)this.getRegistryName(registryAccess)));
        }
        return this.holder;
    }

    public boolean hasResourceGeneratorOfType(ResourceType type) {
        return ((ResourceGenerator)this.getResourceGenerator().m_203334_()).is(type);
    }

    public boolean hasMobResources() {
        return this.hasResourceGeneratorOfType(ResourceTypes.MOB);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public ForgeCondition getCondition() {
        return this.condition;
    }

    public int getTier() {
        return this.tier;
    }

    public boolean isFireImmune() {
        return this.isFireImmune;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public AxolootlModelSettings getModelSettings() {
        return this.axolootlModelSettings;
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    public List<BonusesProvider> getFoods() {
        return this.foods;
    }

    public Optional<Bonuses> getFoodBonuses(ItemLike item) {
        Optional holder = ForgeRegistries.ITEMS.getHolder((Object)item.m_5456_());
        if (holder.isPresent()) {
            for (BonusesProvider provider : this.getFoods()) {
                if (!provider.getFoods().get((Registry<Item>)Registry.f_122827_).m_203333_((Holder)holder.get())) continue;
                return Optional.of(provider.getBonuses());
            }
        }
        return Optional.empty();
    }

    public DeferredHolderSet<Item> getBreedFood() {
        return this.breedFood;
    }

    public Holder<ResourceGenerator> getResourceGenerator() {
        return this.resourceGenerator;
    }

    public Component getDescription() {
        if (null == this.description) {
            this.description = Component.m_237115_((String)this.getTranslationKey());
        }
        return this.description;
    }

    public Component getTierDescription() {
        if (null == this.tierDescription) {
            this.tierDescription = AxolootlVariant.createTierDescription(this.getTier());
        }
        return this.tierDescription;
    }

    public boolean isEnabled(RegistryAccess registryAccess) {
        return AxRegistry.AxolootlVariantsReg.isValid(registryAccess, this);
    }

    private static Component createTierDescription(int tier) {
        int value;
        MutableComponent builder = Component.m_237119_();
        for (value = Math.abs(tier); value >= 100; value -= 100) {
            builder.m_7220_((Component)Component.m_237115_((String)"axolootl.tier.100"));
        }
        while (value >= 90) {
            builder.m_7220_((Component)Component.m_237115_((String)"axolootl.tier.90"));
            value -= 90;
        }
        while (value >= 50) {
            builder.m_7220_((Component)Component.m_237115_((String)"axolootl.tier.50"));
            value -= 50;
        }
        while (value >= 40) {
            builder.m_7220_((Component)Component.m_237115_((String)"axolootl.tier.40"));
            value -= 40;
        }
        while (value >= 10) {
            builder.m_7220_((Component)Component.m_237115_((String)"axolootl.tier.10"));
            value -= 10;
        }
        if (value > 0 || tier <= 0) {
            builder.m_7220_((Component)Component.m_237115_((String)("axolootl.tier." + value)));
        }
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AxolootlVariant{");
        builder.append(" name=" + this.translationKey);
        builder.append(" model=" + this.axolootlModelSettings);
        builder.append(" food_bonuses=" + this.foods.toString());
        builder.append(" breed_food=" + this.breedFood.toString());
        builder.append(" generators=" + this.resourceGenerator.toString());
        builder.append("}");
        return super.toString();
    }
}

