/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.breeding;

import axolootl.AxRegistry;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.util.AxCodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.Level;

public class AxolootlBreeding {
    public static final Codec<AxolootlBreeding> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AxolootlVariant.RESOURCE_KEY_CODEC.fieldOf("first").forGetter(AxolootlBreeding::getFirst), (App)AxolootlVariant.RESOURCE_KEY_CODEC.fieldOf("second").forGetter(AxolootlBreeding::getSecond), (App)AxCodecUtils.weightedListOrElementCodec(AxolootlVariant.RESOURCE_KEY_CODEC).fieldOf("result").forGetter(AxolootlBreeding::getResult)).apply((Applicative)instance, AxolootlBreeding::new));
    public static final Codec<Holder<AxolootlBreeding>> HOLDER_CODEC = RegistryFileCodec.m_135589_(AxRegistry.Keys.AXOLOOTL_BREEDING, CODEC);
    public static final Codec<HolderSet<AxolootlBreeding>> HOLDER_SET_CODEC = RegistryCodecs.m_206279_(AxRegistry.Keys.AXOLOOTL_BREEDING, CODEC);
    private final ResourceKey<AxolootlVariant> first;
    private final ResourceKey<AxolootlVariant> second;
    private final SimpleWeightedRandomList<ResourceKey<AxolootlVariant>> result;

    public AxolootlBreeding(ResourceKey<AxolootlVariant> first, ResourceKey<AxolootlVariant> second, SimpleWeightedRandomList<ResourceKey<AxolootlVariant>> result) {
        this.first = first;
        this.second = second;
        this.result = result;
    }

    public static Registry<AxolootlBreeding> getRegistry(RegistryAccess access) {
        return AxRegistry.AXOLOOTL_BREEDING_REGISTRY_SUPPLIER.apply(access);
    }

    public boolean matches(Level level, AxolootlVariant aFirst, AxolootlVariant aSecond) {
        ResourceLocation idFirst = aFirst.getRegistryName(level.m_5962_());
        ResourceLocation idSecond = aSecond.getRegistryName(level.m_5962_());
        return this.first.m_135782_().equals((Object)idFirst) && this.second.m_135782_().equals((Object)idSecond) || this.first.m_135782_().equals((Object)idSecond) && this.second.m_135782_().equals((Object)idFirst);
    }

    public AxolootlVariant getFirst(RegistryAccess access) {
        return (AxolootlVariant)AxolootlVariant.getRegistry(access).m_7745_(this.first.m_135782_());
    }

    public AxolootlVariant getSecond(RegistryAccess access) {
        return (AxolootlVariant)AxolootlVariant.getRegistry(access).m_7745_(this.second.m_135782_());
    }

    public ResourceKey<AxolootlVariant> getFirst() {
        return this.first;
    }

    public ResourceKey<AxolootlVariant> getSecond() {
        return this.second;
    }

    public SimpleWeightedRandomList<ResourceKey<AxolootlVariant>> getResult() {
        return this.result;
    }
}

