/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.breeding_modifier;

import axolootl.AxRegistry;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.data.breeding_modifier.AddAxolootlBreedingModifier;
import axolootl.data.breeding_modifier.AxolootlBreedingModifier;
import axolootl.data.breeding_modifier.RemoveAxolootlBreedingModifier;
import axolootl.data.breeding_modifier.WeightedEntryPredicate;
import axolootl.util.AxCodecUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;

@Immutable
public class SequenceAxolootlBreedingModifier
extends AxolootlBreedingModifier {
    public static final Codec<SequenceAxolootlBreedingModifier> CODEC = RecordCodecBuilder.create(instance -> SequenceAxolootlBreedingModifier.codecStart(instance).and((App)AxCodecUtils.listOrElementCodec(WeightedEntry.Wrapper.m_146305_(AxolootlVariant.RESOURCE_KEY_CODEC)).fieldOf(AxolootlBreedingModifier.Phase.ADD.m_7912_()).forGetter(SequenceAxolootlBreedingModifier::getAdd)).and((App)AxCodecUtils.listOrElementCodec(WeightedEntryPredicate.CODEC).fieldOf(AxolootlBreedingModifier.Phase.REMOVE.m_7912_()).forGetter(SequenceAxolootlBreedingModifier::getRemove)).apply((Applicative)instance, SequenceAxolootlBreedingModifier::new));
    private final List<WeightedEntry.Wrapper<ResourceKey<AxolootlVariant>>> add;
    private final List<WeightedEntryPredicate> remove;
    private final Map<AxolootlBreedingModifier.Phase, List<AxolootlBreedingModifier>> values;

    public SequenceAxolootlBreedingModifier(ResourceLocation target, List<WeightedEntry.Wrapper<ResourceKey<AxolootlVariant>>> add, List<WeightedEntryPredicate> remove) {
        super(target);
        this.add = add;
        this.remove = remove;
        this.values = Collections.unmodifiableMap(this.buildValues());
    }

    private Map<AxolootlBreedingModifier.Phase, List<AxolootlBreedingModifier>> buildValues() {
        EnumMap<AxolootlBreedingModifier.Phase, List<AxolootlBreedingModifier>> builder = new EnumMap<AxolootlBreedingModifier.Phase, List<AxolootlBreedingModifier>>(AxolootlBreedingModifier.Phase.class);
        for (AxolootlBreedingModifier.Phase phase : AxolootlBreedingModifier.Phase.values()) {
            builder.put(phase, this.buildModifiers(phase));
        }
        return builder;
    }

    private List<AxolootlBreedingModifier> buildModifiers(AxolootlBreedingModifier.Phase phase) {
        switch (phase) {
            case ADD: {
                return ImmutableList.of((Object)new AddAxolootlBreedingModifier(this.getTarget(), this.add));
            }
            case REMOVE: {
                return ImmutableList.copyOf(this.remove.stream().map(p -> new RemoveAxolootlBreedingModifier(this.getTarget(), (WeightedEntryPredicate)p)).toList());
            }
        }
        return new ArrayList<AxolootlBreedingModifier>();
    }

    @Override
    public void apply(List<WeightedEntry.Wrapper<ResourceKey<AxolootlVariant>>> list, AxolootlBreedingModifier.Phase phase) {
        this.getValues().getOrDefault((Object)phase, (List<AxolootlBreedingModifier>)ImmutableList.of()).forEach(entry -> entry.apply(list, phase));
    }

    @Override
    public Codec<? extends AxolootlBreedingModifier> getCodec() {
        return (Codec)AxRegistry.AxolootlBreedingModifierReg.SEQUENCE.get();
    }

    public List<WeightedEntry.Wrapper<ResourceKey<AxolootlVariant>>> getAdd() {
        return this.add;
    }

    public List<WeightedEntryPredicate> getRemove() {
        return this.remove;
    }

    public Map<AxolootlBreedingModifier.Phase, List<AxolootlBreedingModifier>> getValues() {
        return this.values;
    }
}

