/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.AxRegistry;
import axolootl.data.resource_generator.ResourceDescriptionGroup;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.data.resource_generator.ResourceTypes;
import axolootl.data.resource_generator.SimpleResourceGenerator;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

@Immutable
public class ItemTagResourceGenerator
extends SimpleResourceGenerator {
    public static final Codec<ItemTagResourceGenerator> CODEC = TagKey.m_203877_((ResourceKey)ForgeRegistries.Keys.ITEMS).xmap(ItemTagResourceGenerator::new, ItemTagResourceGenerator::getTag).fieldOf("tag").codec();
    private final TagKey<Item> tag;

    public ItemTagResourceGenerator(TagKey<Item> tag) {
        super(ResourceTypes.ITEM);
        this.tag = tag;
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    @Override
    public Collection<ItemStack> getRandomEntries(LivingEntity entity, RandomSource random) {
        MinecraftServer server = entity.m_20194_();
        if (null == server) {
            return ImmutableList.of();
        }
        ITag itag = ForgeRegistries.ITEMS.tags().getTag(this.getTag());
        ImmutableList.Builder builder = new ImmutableList.Builder();
        itag.getRandomElement(random).ifPresent(item -> builder.add((Object)item.m_7968_()));
        return builder.build();
    }

    @Override
    public Codec<? extends ResourceGenerator> getCodec() {
        return (Codec)AxRegistry.ResourceGeneratorsReg.TAG.get();
    }

    @Override
    public List<ResourceDescriptionGroup> createDescription() {
        return ImmutableList.of((Object)ResourceDescriptionGroup.builder().ofTag(this.getTag()));
    }

    public String toString() {
        return "ItemTag: " + this.getTag().f_203868_().toString();
    }
}

