/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.Axolootl;
import axolootl.data.resource_generator.ResourceType;
import axolootl.data.resource_generator.SimpleResourceGenerator;
import axolootl.util.AxCodecUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;

@Immutable
public abstract class LootContextResourceGenerator
extends SimpleResourceGenerator {
    protected static final Codec<SimpleWeightedRandomList<Wrapper>> WEIGHTED_LIST_CODEC = Codec.either(Wrapper.CODEC, (Codec)SimpleWeightedRandomList.m_185860_(Wrapper.CODEC)).xmap(either -> (SimpleWeightedRandomList)either.map(SimpleWeightedRandomList::m_185862_, Function.identity()), list -> list.m_146338_().size() == 1 ? Either.left((Object)((Wrapper)((WeightedEntry.Wrapper)list.m_146338_().get(0)).m_146310_())) : Either.right((Object)list));
    private final SimpleWeightedRandomList<Wrapper> list;

    public LootContextResourceGenerator(ResourceType resourceType, SimpleWeightedRandomList<Wrapper> list) {
        super(resourceType);
        this.list = list;
    }

    public SimpleWeightedRandomList<Wrapper> getList() {
        return this.list;
    }

    @Override
    public Collection<ItemStack> getRandomEntries(LivingEntity entity, RandomSource random) {
        MinecraftServer server = entity.m_20194_();
        if (null == server) {
            return ImmutableList.of();
        }
        Optional oLootTableId = this.getList().m_216820_(random);
        if (oLootTableId.isEmpty()) {
            return ImmutableList.of();
        }
        LootTable lootTable = server.m_129898_().m_79217_(((Wrapper)oLootTableId.get()).getId());
        if (lootTable == LootTable.f_79105_) {
            Axolootl.LOGGER.warn("[ResourceGenerator#getRandomEntries] Failed to load loot table " + oLootTableId.get());
            return ImmutableList.of();
        }
        LootContext context = this.createContext(entity, random);
        return lootTable.m_230922_(context);
    }

    protected abstract LootContext createContext(LivingEntity var1, RandomSource var2);

    public String toString() {
        return "LootTable: " + this.list.toString();
    }

    public static class Wrapper {
        protected static final Codec<Wrapper> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(Wrapper::getId), (App)AxCodecUtils.ITEM_OR_STACK_CODEC.optionalFieldOf("display", (Object)new ItemStack((ItemLike)Items.f_42425_)).forGetter(Wrapper::getDisplay)).apply((Applicative)instance, Wrapper::new));
        protected static final Codec<Wrapper> CODEC = Codec.either((Codec)ResourceLocation.f_135803_, DIRECT_CODEC).xmap(either -> (Wrapper)either.map(id -> new Wrapper((ResourceLocation)id, ItemStack.f_41583_), Function.identity()), wrapper -> wrapper.getDisplay().m_41619_() ? Either.left((Object)wrapper.getId()) : Either.right((Object)wrapper));
        private final ResourceLocation id;
        private final ItemStack display;

        public Wrapper(ResourceLocation id, ItemStack display) {
            this.id = id;
            this.display = display;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public ItemStack getDisplay() {
            return this.display;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Wrapper)) {
                return false;
            }
            Wrapper wrapper = (Wrapper)o;
            return Objects.equals(this.id, wrapper.id) && Objects.equals(this.display, wrapper.display);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.display);
        }
    }
}

