/*
 * Decompiled with CFR 0.152.
 */
package axolootl.data.resource_generator;

import axolootl.AxRegistry;
import axolootl.data.resource_generator.ResourceDescriptionGroup;
import axolootl.data.resource_generator.ResourceType;
import axolootl.util.AxCodecUtils;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

@Immutable
public abstract class ResourceGenerator {
    public static final Codec<ResourceGenerator> DIRECT_CODEC = ExtraCodecs.m_184415_(() -> AxRegistry.RESOURCE_GENERATOR_SERIALIZERS_SUPPLIER.get().getCodec()).dispatch(ResourceGenerator::getCodec, Function.identity());
    public static final Codec<Holder<ResourceGenerator>> HOLDER_CODEC = RegistryFileCodec.m_135589_(AxRegistry.Keys.RESOURCE_GENERATORS, DIRECT_CODEC);
    public static final Codec<HolderSet<ResourceGenerator>> HOLDER_SET_CODEC = RegistryCodecs.m_206279_(AxRegistry.Keys.RESOURCE_GENERATORS, DIRECT_CODEC);
    public static final Codec<List<ResourceGenerator>> DIRECT_LIST_CODEC = AxCodecUtils.listOrElementCodec(DIRECT_CODEC);
    public static final Codec<SimpleWeightedRandomList<ResourceGenerator>> WEIGHTED_LIST_CODEC = Codec.either(DIRECT_CODEC, (Codec)SimpleWeightedRandomList.m_185860_(DIRECT_CODEC)).xmap(either -> (SimpleWeightedRandomList)either.map(SimpleWeightedRandomList::m_185862_, Function.identity()), ResourceGenerator::eitherSimpleList);
    private final Supplier<List<ResourceDescriptionGroup>> description = Suppliers.memoize(this::createDescription);

    public abstract Set<ResourceType> getResourceTypes();

    public boolean is(ResourceType type) {
        return this.getResourceTypes().contains(type);
    }

    public List<ResourceDescriptionGroup> getDescription() {
        return this.description.get();
    }

    public abstract Collection<ItemStack> getRandomEntries(LivingEntity var1, RandomSource var2);

    public abstract Codec<? extends ResourceGenerator> getCodec();

    protected abstract List<ResourceDescriptionGroup> createDescription();

    public static int calculateTotalWeight(WeightedRandomList<?> list) {
        return list.m_146338_().stream().map(e -> e.m_142631_().m_146281_()).reduce(Integer::sum).orElse(1);
    }

    public static Component getItemDisplayName(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return Component.m_237115_((String)"axolootl.resource_generator.nothing");
        }
        return itemStack.m_41786_();
    }

    public static <T> List<WeightedEntry.Wrapper<T>> createSortedWeightedList(WeightedRandomList<WeightedEntry.Wrapper<T>> list) {
        Comparator<WeightedEntry.Wrapper> comparator = Comparator.comparingInt(e -> e.m_142631_().m_146281_());
        return ResourceGenerator.createSortedWeightedList(list, comparator.reversed());
    }

    public static <T> List<WeightedEntry.Wrapper<T>> createSortedWeightedList(WeightedRandomList<WeightedEntry.Wrapper<T>> list, Comparator<WeightedEntry.Wrapper<T>> comparator) {
        ArrayList<WeightedEntry.Wrapper<T>> entries = new ArrayList<WeightedEntry.Wrapper<T>>(list.m_146338_());
        entries.sort(comparator);
        return entries;
    }

    public static Registry<ResourceGenerator> getRegistry(RegistryAccess access) {
        return access.m_175515_(AxRegistry.Keys.RESOURCE_GENERATORS);
    }

    public static <T> SimpleWeightedRandomList<T> createSimpleList(List<T> list) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        list.forEach(t -> builder.m_146271_(t, 1));
        return builder.m_146270_();
    }

    public static <T> Either<T, SimpleWeightedRandomList<T>> eitherSimpleList(SimpleWeightedRandomList<T> list) {
        if (list.m_146338_().size() == 1) {
            return Either.left((Object)((WeightedEntry.Wrapper)list.m_146338_().get(0)).m_146310_());
        }
        return Either.right(list);
    }
}

