/*
 * Decompiled with CFR 0.152.
 */
package axolootl.entity;

import axolootl.AxRegistry;
import axolootl.Axolootl;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.block.entity.IAquariumControllerProvider;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.data.axolootl_variant.Bonuses;
import axolootl.data.breeding.AxolootlBreedingWrapper;
import axolootl.entity.IAxolootl;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class AxolootlEntity
extends Axolotl
implements IAnimatable,
IAxolootl,
IAquariumControllerProvider {
    public static final EntityDataSerializer<Optional<ResourceLocation>> OPTIONAL_RESOURCE_LOCATION = EntityDataSerializer.m_238098_(FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130281_);
    public static final int BABY_AGE = -24000;
    private static final EntityDataAccessor<Optional<ResourceLocation>> DATA_VARIANT_ID = SynchedEntityData.m_135353_(AxolootlEntity.class, OPTIONAL_RESOURCE_LOCATION);
    private static final EntityDataAccessor<Boolean> DATA_ACTIVE_BONUS = SynchedEntityData.m_135353_(AxolootlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private AxolootlVariant cachedVariant;
    @Nullable
    private BlockPos controllerPos;
    @Nullable
    private ControllerBlockEntity controller;
    private Bonuses bonuses = Bonuses.EMPTY;
    private long bonusDuration;
    private static final FoodProperties EMPTY_FOOD_PROPERTIES = new FoodProperties.Builder().m_38767_();
    private Component displayName;
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final AnimationBuilder ANIM_IDLE = new AnimationBuilder().loop("animation.axolootl.idle");
    private final AnimationBuilder ANIM_WALK = new AnimationBuilder().loop("animation.axolootl.walk");
    private final AnimationBuilder ANIM_SWIM = new AnimationBuilder().loop("animation.axolootl.swim");
    private final AnimationBuilder ANIM_SWIM_IDLE = new AnimationBuilder().loop("animation.axolootl.swim_idle");
    private final AnimationBuilder ANIM_PLAY_DEAD = new AnimationBuilder().loop("animation.axolootl.play_dead");
    private static final String KEY_BONUSES = "Bonuses";
    private static final String KEY_BONUS_DURATION = "BonusDuration";
    public static final String KEY_AGE = "Age";

    public AxolootlEntity(EntityType<? extends Axolotl> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Axolotl.m_149176_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVE_BONUS, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, Optional.empty());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData data = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (pDataTag != null && pDataTag.m_128425_("Axolootl", 8)) {
            this.setAxolootlVariantId(new ResourceLocation(pDataTag.m_128461_("Axolootl")));
        }
        return data;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.bonusDuration > 0L && --this.bonusDuration <= 0L) {
            this.setBonuses(null);
        }
        this.getController();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_() && this.isActiveBonus() && this.m_217043_().m_188503_(10) == 0) {
            Vec3 vec = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
            double radius = 0.25;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, vec.m_7096_() + (this.m_217043_().m_188500_() - 0.5) * 2.0 * 0.25, vec.m_7098_() + (this.m_217043_().m_188500_() - 0.5) * 2.0 * 0.25, vec.m_7094_() + (this.m_217043_().m_188500_() - 0.5) * 2.0 * 0.25, 0.0, 0.0, 0.0);
        }
    }

    protected Component m_5677_() {
        if (null == this.displayName) {
            Optional oVariant = this.getAxolootlVariant(this.f_19853_.m_5962_());
            this.displayName = oVariant.isPresent() ? Component.m_237110_((String)(this.m_6095_().m_20675_() + ".description"), (Object[])new Object[]{super.m_5677_(), ((AxolootlVariant)oVariant.get()).getDescription()}) : super.m_5677_();
        }
        return this.displayName;
    }

    protected void m_142075_(Player pPlayer, InteractionHand pHand, ItemStack pStack) {
        Optional<Bonuses> oBonuses = this.getUseFoodResult(pStack);
        oBonuses.ifPresent(bonuses -> this.setBonuses((Bonuses)bonuses));
        super.m_142075_(pPlayer, pHand, pStack);
    }

    private Optional<Bonuses> getUseFoodResult(ItemStack pStack) {
        AxolootlVariant variant = this.getAxolootlVariant(this.f_19853_.m_5962_()).orElse(AxolootlVariant.EMPTY);
        if (this.bonusDuration <= 0L) {
            return variant.getFoodBonuses((ItemLike)pStack.m_41720_());
        }
        return Optional.empty();
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (pKey == DATA_VARIANT_ID) {
            this.displayName = null;
            this.clearCachedVariant();
            this.getAxolootlVariant(this.f_19853_.m_5962_());
        }
    }

    public ItemStack m_142340_() {
        return this.asItemStack();
    }

    public boolean m_5825_() {
        Optional oVariant = this.getAxolootlVariant(this.f_19853_.m_5962_());
        return oVariant.isPresent() && ((AxolootlVariant)oVariant.get()).isFireImmune() || super.m_5825_();
    }

    public boolean m_5957_() {
        return this.controller != null && super.m_5957_();
    }

    public boolean m_35506_() {
        if (this.m_6162_()) {
            return false;
        }
        AxolootlVariant variant = this.getAxolootlVariant(this.f_19853_.m_5962_()).orElse(AxolootlVariant.EMPTY);
        return null != this.controller && (!variant.hasMobResources() || this.controller.enableMobBreeding());
    }

    public boolean m_6898_(ItemStack pStack) {
        AxolootlVariant variant = this.getAxolootlVariant(this.f_19853_.m_5962_()).orElse(AxolootlVariant.EMPTY);
        return variant.getFoodBonuses((ItemLike)pStack.m_41720_()).isPresent();
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        if (pLevel.m_8055_(pPos).m_60713_((Block)AxRegistry.BlockReg.AQUARIUM_AIRLOCK.get())) {
            return -10.0f;
        }
        return super.m_5610_(pPos, pLevel);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        AxolootlEntity baby = (AxolootlEntity)((EntityType)AxRegistry.EntityReg.AXOLOOTL.get()).m_20615_((Level)pLevel);
        if (baby != null) {
            baby.setAxolootlVariantId(this.getAxolootlVariantId().orElse(null));
        }
        return baby;
    }

    public Optional<IAxolootl> spawnAxolootlFromBreeding(ServerLevel pLevel, Animal pMate, AxolootlVariant variant) {
        ResourceLocation variantId = variant.getRegistryName(pLevel.m_5962_());
        AgeableMob ageablemob = this.m_142606_(pLevel, (AgeableMob)pMate);
        if (!(ageablemob instanceof IAxolootl)) {
            return Optional.empty();
        }
        IAxolootl iaxolootl = (IAxolootl)ageablemob;
        iaxolootl.setAxolootlVariantId(variantId);
        ageablemob.m_6863_(true);
        ageablemob.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)this, (Mob)pMate, ageablemob);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        this.m_146762_(6000);
        pMate.m_146762_(6000);
        this.m_27594_();
        pMate.m_27594_();
        if (cancelled) {
            return Optional.empty();
        }
        pLevel.m_47205_((Entity)ageablemob);
        ageablemob.m_6518_((ServerLevelAccessor)pLevel, pLevel.m_6436_(this.m_20183_()), MobSpawnType.BREEDING, null, null);
        pLevel.m_7605_((Entity)this, (byte)18);
        pLevel.m_7605_((Entity)pMate, (byte)18);
        return Optional.of(iaxolootl);
    }

    public boolean m_27487_() {
        return true;
    }

    public void m_27497_(boolean pFromBucket) {
    }

    public boolean m_8023_() {
        return true;
    }

    public void m_6872_(ItemStack pStack) {
        super.m_6872_(pStack);
        this.getAxolootlVariantId().ifPresent(id -> pStack.m_41783_().m_128359_("Axolootl", id.toString()));
    }

    public void m_142278_(CompoundTag pTag) {
        super.m_142278_(pTag);
        if (pTag.m_128425_("Axolootl", 8)) {
            ResourceLocation id = new ResourceLocation(pTag.m_128461_("Axolootl"));
            this.setAxolootlVariantId(id);
        }
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get());
    }

    @Override
    public void setController(Level level, BlockPos pos, ControllerBlockEntity blockEntity) {
        this.controllerPos = pos;
        this.controller = blockEntity;
    }

    @Override
    public void clearController() {
        this.controllerPos = null;
        this.controller = null;
    }

    @Override
    public Optional<ControllerBlockEntity> getController() {
        if (this.controllerPos != null && null == this.controller) {
            BlockEntity blockEntity = this.f_19853_.m_7702_(this.controllerPos);
            if (blockEntity instanceof ControllerBlockEntity) {
                ControllerBlockEntity controller = (ControllerBlockEntity)blockEntity;
                this.setController(this.f_19853_, this.controllerPos, controller);
            } else {
                this.clearController();
            }
        }
        return Optional.ofNullable(this.controller);
    }

    @Override
    public LivingEntity getEntity() {
        return this;
    }

    @Override
    public boolean isEntityPlayingDead() {
        return this.m_149175_();
    }

    @Override
    public ItemStack asItemStack() {
        ItemStack stack = this.m_28282_();
        this.m_6872_(stack);
        return stack;
    }

    @Override
    public void setAxolootlVariantId(@Nullable ResourceLocation id) {
        this.m_20088_().m_135381_(DATA_VARIANT_ID, Optional.ofNullable(id));
        this.clearCachedVariant();
    }

    @Override
    public Optional<AxolootlVariant> getAxolootlVariant(RegistryAccess registryAccess, boolean includeAll) {
        if (null == this.cachedVariant) {
            this.cachedVariant = IAxolootl.super.getAxolootlVariant(registryAccess, includeAll).orElse(null);
        }
        return Optional.ofNullable(this.cachedVariant);
    }

    public void clearCachedVariant() {
        this.cachedVariant = null;
    }

    @Override
    public Optional<ResourceLocation> getAxolootlVariantId() {
        return (Optional)this.m_20088_().m_135370_(DATA_VARIANT_ID);
    }

    @Override
    public boolean isFeedCandidate(ServerLevel level) {
        return this.bonusDuration <= 0L;
    }

    @Override
    public boolean isResourceGenerationCandidate(ServerLevel level) {
        return !this.m_6162_();
    }

    @Override
    public InteractionResult feed(ServerLevel level, ItemStack food) {
        Optional<Bonuses> oBonuses = this.getUseFoodResult(food);
        if (oBonuses.isPresent()) {
            this.setBonuses(oBonuses.get());
            if (food.m_41614_()) {
                for (Pair pair : Optional.ofNullable(food.getFoodProperties((LivingEntity)this)).orElse(EMPTY_FOOD_PROPERTIES).m_38749_()) {
                    if (pair.getFirst() == null || !(this.m_217043_().m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    this.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isBreedCandidate(ServerLevel level, Optional<IAxolootl> other) {
        if (!this.m_5957_() || !this.m_35506_()) {
            return false;
        }
        if (other.isPresent()) {
            AxolootlVariant selfVariant = this.getAxolootlVariant(level.m_5962_()).orElse(AxolootlVariant.EMPTY);
            AxolootlVariant otherVariant = other.get().getAxolootlVariant(level.m_5962_()).orElse(AxolootlVariant.EMPTY);
            return AxolootlBreedingWrapper.getBreedingRecipe((Level)level, selfVariant, otherVariant).isPresent();
        }
        return true;
    }

    @Override
    public Optional<IAxolootl> breed(ServerLevel level, IAxolootl other, boolean enableMobBreeding) {
        AxolootlEntity axolootlEntity;
        AxolootlVariant otherVariant;
        AxolootlVariant selfVariant = this.getAxolootlVariant(level.m_5962_()).orElse(AxolootlVariant.EMPTY);
        Optional<AxolootlBreedingWrapper> oRecipe = AxolootlBreedingWrapper.getBreedingRecipe((Level)level, selfVariant, otherVariant = other.getAxolootlVariant(level.m_5962_()).orElse(AxolootlVariant.EMPTY));
        if (oRecipe.isEmpty()) {
            return Optional.empty();
        }
        AxolootlVariant result = oRecipe.get().getBreedResult((Level)level, selfVariant, otherVariant, this.m_217043_());
        if (!result.isEnabled(level.m_5962_()) || result.hasMobResources() && !enableMobBreeding) {
            return Optional.empty();
        }
        LivingEntity livingEntity = other.getEntity();
        if (livingEntity instanceof Animal) {
            Animal animal = (Animal)livingEntity;
            axolootlEntity = animal;
        } else {
            axolootlEntity = this;
        }
        AxolootlEntity parent = axolootlEntity;
        return this.spawnAxolootlFromBreeding(level, (Animal)parent, result);
    }

    @Override
    public double getGenerationSpeed() {
        return this.bonuses.getGenerationBonus();
    }

    @Override
    public double getFeedSpeed() {
        return this.bonuses.getFeedBonus();
    }

    @Override
    public double getBreedSpeed() {
        return this.bonuses.getBreedBonus();
    }

    public void setBonuses(@Nullable Bonuses bonuses) {
        if (this.bonuses.equals(bonuses)) {
            return;
        }
        if (null == bonuses) {
            this.bonuses = Bonuses.EMPTY;
            this.bonusDuration = 0L;
            this.m_20088_().m_135381_(DATA_ACTIVE_BONUS, (Object)false);
            return;
        }
        this.bonuses = bonuses;
        this.bonusDuration = bonuses.getDuration();
        this.m_20088_().m_135381_(DATA_ACTIVE_BONUS, (Object)true);
        this.getController().ifPresent(c -> c.forceCalculateBonuses());
    }

    public Bonuses getBonuses() {
        return this.bonuses;
    }

    public boolean isActiveBonus() {
        return (Boolean)this.m_20088_().m_135370_(DATA_ACTIVE_BONUS);
    }

    protected PlayState animationPredicate(AnimationEvent<AxolootlEntity> event) {
        if (this.m_149175_()) {
            event.getController().setAnimation(this.ANIM_PLAY_DEAD);
            return PlayState.CONTINUE;
        }
        boolean isMoving = event.isMoving();
        if (this.m_20072_()) {
            if (isMoving) {
                event.getController().setAnimation(this.ANIM_SWIM);
            } else {
                event.getController().setAnimation(this.ANIM_SWIM_IDLE);
            }
        } else if (this.m_20096_()) {
            if (isMoving) {
                event.getController().setAnimation(this.ANIM_WALK);
            } else {
                event.getController().setAnimation(this.ANIM_IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::animationPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.writeAxolootlVariant(pCompound);
        this.writeControllerPos(this.controllerPos, pCompound);
        pCompound.m_128356_(KEY_BONUS_DURATION, this.bonusDuration);
        pCompound.m_128365_(KEY_BONUSES, (Tag)Bonuses.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.bonuses).resultOrPartial(s -> Axolootl.LOGGER.error("Failed to write entity bonuses! " + s)).orElse(new CompoundTag()));
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readAxolootlVariant(pCompound);
        this.controllerPos = this.readControllerPos(pCompound);
        this.bonusDuration = pCompound.m_128454_(KEY_BONUS_DURATION);
        this.bonuses = Bonuses.DIRECT_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)pCompound.m_128469_(KEY_BONUSES)).resultOrPartial(s -> Axolootl.LOGGER.error("Failed to read entity bonuses! " + s)).orElse(Bonuses.EMPTY);
        this.m_20088_().m_135381_(DATA_ACTIVE_BONUS, (Object)(this.bonusDuration > 0L ? 1 : 0));
    }
}

