/*
 * Decompiled with CFR 0.152.
 */
package axolootl.entity;

import axolootl.AxRegistry;
import axolootl.data.axolootl_variant.AxolootlVariant;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface IAxolootl {
    public static final String KEY_VARIANT_ID = "Axolootl";

    public LivingEntity getEntity();

    public ItemStack asItemStack();

    public boolean isFeedCandidate(ServerLevel var1);

    public boolean isResourceGenerationCandidate(ServerLevel var1);

    public InteractionResult feed(ServerLevel var1, ItemStack var2);

    public boolean isBreedCandidate(ServerLevel var1, Optional<IAxolootl> var2);

    public Optional<IAxolootl> breed(ServerLevel var1, IAxolootl var2, boolean var3);

    public void setAxolootlVariantId(@Nullable ResourceLocation var1);

    public Optional<ResourceLocation> getAxolootlVariantId();

    public boolean isEntityPlayingDead();

    default public double getGenerationSpeed() {
        return 0.0;
    }

    default public double getFeedSpeed() {
        return 0.0;
    }

    default public double getBreedSpeed() {
        return 0.0;
    }

    default public Optional<AxolootlVariant> getAxolootlVariant(RegistryAccess registryAccess) {
        return this.getAxolootlVariant(registryAccess, false);
    }

    default public Optional<AxolootlVariant> getAxolootlVariant(RegistryAccess registryAccess, boolean includeAll) {
        Optional<ResourceLocation> oId = this.getAxolootlVariantId();
        if (oId.isEmpty()) {
            return Optional.empty();
        }
        if (!includeAll && !AxRegistry.AxolootlVariantsReg.isValid(oId.get())) {
            return Optional.empty();
        }
        return AxolootlVariant.getRegistry(registryAccess).m_6612_(oId.get());
    }

    default public void writeAxolootlVariant(CompoundTag pCompound) {
        this.getAxolootlVariantId().ifPresent(id -> pCompound.m_128359_(KEY_VARIANT_ID, id.toString()));
    }

    default public void readAxolootlVariant(CompoundTag pCompound) {
        if (pCompound.m_128425_(KEY_VARIANT_ID, 8)) {
            this.setAxolootlVariantId(new ResourceLocation(pCompound.m_128461_(KEY_VARIANT_ID)));
        }
    }
}

