/*
 * Decompiled with CFR 0.152.
 */
package axolootl.integration;

import axolootl.AxRegistry;
import axolootl.integration.JeiAddon;
import axolootl.integration.JeiBreedingRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class JeiBreedingCategory
implements IRecipeCategory<JeiBreedingRecipe> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("axolootl", "textures/gui/jei/breeding.png");
    protected static final int ITEM_WIDTH = 30;
    protected static final int ITEM_HEIGHT = 16;
    protected static final int INPUTS_WIDTH = 103;
    protected static final int INPUTS_HEIGHT = 45;
    protected static final int OUTPUT_ITEM_HEIGHT = 26;
    protected static final int ITEM_COUNT_PER_ROW = 5;
    protected static final int TEXTURE_WIDTH = 150;
    protected static final int TEXTURE_HEIGHT = 123;
    protected static final int INPUTS_X = 23;
    protected static final int SECOND_INPUTS_X = 90;
    protected static final int INPUTS_Y = 1;
    protected static final int OUTPUT_X = 0;
    protected static final int OUTPUT_Y = 45;
    protected final IDrawable background;
    protected final IDrawable inputs;
    protected final IDrawable icon;
    protected final Component title;
    protected final Component monsteriumTooltip;
    protected final Component foodTooltip;
    protected final ItemStack monsteriumItem;

    public JeiBreedingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 45, 150, 123);
        this.inputs = guiHelper.createDrawable(TEXTURE, 0, 0, 103, 45);
        this.icon = guiHelper.createDrawableItemStack(Items.f_151057_.m_7968_());
        this.title = Component.m_237115_((String)"jei.recipe_category.breeding");
        this.foodTooltip = Component.m_237115_((String)"jei.recipe_category.breeding.food");
        MutableComponent monsterium = Component.m_237115_((String)((Block)AxRegistry.BlockReg.MONSTERIUM.get()).m_7705_());
        this.monsteriumTooltip = Component.m_237110_((String)"jei.recipe_category.breeding.monsterium", (Object[])new Object[]{monsterium});
        this.monsteriumItem = new ItemStack((ItemLike)AxRegistry.BlockReg.MONSTERIUM.get());
    }

    public RecipeType<JeiBreedingRecipe> getRecipeType() {
        return JeiAddon.BREEDING_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, JeiBreedingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 23, 1).addItemStacks(recipe.getFirst());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 41, 1).addItemStacks(recipe.getFirstFood())).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(0, this.foodTooltip));
        builder.addSlot(RecipeIngredientRole.INPUT, 90, 1).addItemStacks(recipe.getSecond());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 108, 1).addItemStacks(recipe.getSecondFood())).addTooltipCallback((recipeSlotView, tooltip) -> tooltip.add(0, this.foodTooltip));
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int resultCount = 0;
        int outputOffsetX = 75 - this.getOutputOffsetX(recipe) - 2;
        for (Map.Entry<ItemStack, Double> entry : recipe.getSortedResult()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 0 + resultCount % 5 * 30 + 8 + outputOffsetX, 45 + resultCount / 5 * 26).addItemStack(entry.getKey());
            ++resultCount;
        }
        if (recipe.requiresMonsterium()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST, 3, 1).addItemStack(this.monsteriumItem)).addTooltipCallback((recipeSlotView, tooltip) -> {
                tooltip.clear();
                tooltip.add(this.monsteriumTooltip);
            });
        }
    }

    public void draw(JeiBreedingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        this.inputs.draw(stack, 22, 0);
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        int outputOffsetX = 75 - this.getOutputOffsetX(recipe);
        int n = recipeSlotsView.getSlotViews(RecipeIngredientRole.OUTPUT).size();
        for (int i = 0; i < n && recipe.getSortedResult().size() >= i; ++i) {
            double chance = recipe.getSortedResult().get(i).getValue();
            PercentChanceOverlay overlay = new PercentChanceOverlay(font, chance);
            overlay.draw(stack, 0 + i % 5 * 30 + 15 + outputOffsetX, 45 + i / 5 * 26 + 16 + 2);
        }
    }

    public int getOutputOffsetX(JeiBreedingRecipe recipe) {
        return Math.min(5, recipe.getResult().size()) * 30 / 2;
    }

    protected static class PercentChanceOverlay
    implements IDrawable {
        private final Font font;
        private final double value;
        private final Component text;
        private final int width;

        public PercentChanceOverlay(Font font, double value) {
            this.font = font;
            this.value = value;
            String formatted = "%.1f".formatted(value * 100.0).replaceAll("0*$", "").replaceAll("\\.$", "");
            this.text = Component.m_237113_((String)(formatted + "%")).m_130940_(ChatFormatting.DARK_GRAY);
            this.width = this.font.m_92852_((FormattedText)this.text);
        }

        public int getWidth() {
            return this.font.m_92852_((FormattedText)this.text);
        }

        public int getHeight() {
            Objects.requireNonNull(this.font);
            return 9;
        }

        public void draw(PoseStack poseStack, int xOffset, int yOffset) {
            this.font.m_92889_(poseStack, this.text, (float)xOffset - (float)this.width / 2.0f, (float)yOffset, 0);
        }
    }
}

