/*
 * Decompiled with CFR 0.152.
 */
package axolootl.integration;

import axolootl.AxRegistry;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.data.breeding.AxolootlBreedingWrapper;
import axolootl.data.resource_generator.ResourceGenerator;
import axolootl.integration.JeiAddon;
import axolootl.item.AxolootlBucketItem;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class JeiBreedingRecipe {
    private final AxolootlBreedingWrapper wrapper;
    private final boolean requiresMonsterium;
    private final List<ItemStack> first;
    private final List<ItemStack> firstFood;
    private final List<ItemStack> second;
    private final List<ItemStack> secondFood;
    private final Map<ItemStack, Double> result;
    private final List<Map.Entry<ItemStack, Double>> sortedResult;

    public JeiBreedingRecipe(AxolootlBreedingWrapper wrapper) {
        RegistryAccess access = JeiAddon.getRegistryAccess();
        Registry<AxolootlVariant> variants = AxolootlVariant.getRegistry(access);
        this.wrapper = wrapper;
        this.requiresMonsterium = wrapper.getResult().m_146338_().stream().anyMatch(w -> ((AxolootlVariant)variants.m_7745_(((ResourceKey)w.m_146310_()).m_135782_())).hasMobResources());
        this.first = ImmutableList.of((Object)JeiBreedingRecipe.getStack(wrapper.getBreeding().getFirst(), false));
        this.second = ImmutableList.of((Object)JeiBreedingRecipe.getStack(wrapper.getBreeding().getSecond(), false));
        this.firstFood = JeiBreedingRecipe.getFood(wrapper.getBreeding().getFirst(access));
        this.secondFood = JeiBreedingRecipe.getFood(wrapper.getBreeding().getSecond(access));
        double totalWeight = ResourceGenerator.calculateTotalWeight(wrapper.getResult());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (WeightedEntry.Wrapper entry : wrapper.getResult().m_146338_()) {
            builder.put((Object)JeiBreedingRecipe.getStack((ResourceKey<AxolootlVariant>)((ResourceKey)entry.m_146310_()), true), (Object)((double)entry.m_142631_().m_146281_() / totalWeight));
        }
        this.result = builder.build();
        ArrayList list = new ArrayList(this.getResult().entrySet().stream().toList());
        Comparator comparator = Map.Entry.comparingByValue();
        list.sort(comparator.reversed());
        this.sortedResult = ImmutableList.copyOf(list);
    }

    public AxolootlBreedingWrapper getWrapper() {
        return this.wrapper;
    }

    public boolean requiresMonsterium() {
        return this.requiresMonsterium;
    }

    public List<ItemStack> getFirst() {
        return this.first;
    }

    public List<ItemStack> getSecond() {
        return this.second;
    }

    public List<ItemStack> getFirstFood() {
        return this.firstFood;
    }

    public List<ItemStack> getSecondFood() {
        return this.secondFood;
    }

    public Map<ItemStack, Double> getResult() {
        return this.result;
    }

    public List<Map.Entry<ItemStack, Double>> getSortedResult() {
        return this.sortedResult;
    }

    private static List<ItemStack> getFood(AxolootlVariant variant) {
        return ImmutableList.copyOf(variant.getBreedFood().get((Registry<Item>)Registry.f_122827_).m_203614_().map(h -> ((Item)h.get()).m_7968_()).toList());
    }

    private static ItemStack getStack(ResourceKey<AxolootlVariant> key, boolean baby) {
        return JeiBreedingRecipe.getStack(key.m_135782_(), baby);
    }

    private static ItemStack getStack(ResourceLocation key, boolean baby) {
        ItemStack stack = AxolootlBucketItem.getWithVariant(new ItemStack((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get()), key);
        if (baby) {
            stack.m_41784_().m_128405_("Age", -24000);
        }
        return stack;
    }
}

