/*
 * Decompiled with CFR 0.152.
 */
package axolootl.item;

import axolootl.AxRegistry;
import axolootl.client.ClientUtil;
import axolootl.client.item.AxolootlBucketItemRenderer;
import axolootl.data.axolootl_variant.AxolootlVariant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class AxolootlBucketItem
extends MobBucketItem {
    private static final Map<ResourceLocation, Rarity> RARITY_CACHE = new HashMap<ResourceLocation, Rarity>();

    public AxolootlBucketItem(Supplier<? extends EntityType<?>> entitySupplier, Supplier<? extends Fluid> fluidSupplier, Supplier<? extends SoundEvent> soundSupplier, Item.Properties properties) {
        super(entitySupplier, fluidSupplier, soundSupplier, properties);
    }

    public void m_6787_(CreativeModeTab pCategory, NonNullList<ItemStack> pItems) {
        if (this.m_220152_(pCategory)) {
            pItems.addAll(AxolootlBucketItem.createSubtypes());
        }
    }

    public static List<ItemStack> createSubtypes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        RegistryAccess access = AxolootlBucketItem.registryAccess();
        if (access != null) {
            ArrayList<Map.Entry> variants = new ArrayList<Map.Entry>(AxolootlVariant.getRegistry(access).m_6579_());
            variants.removeIf(e -> !((AxolootlVariant)e.getValue()).isEnabled(access));
            Comparator<Map.Entry> comparator = Comparator.comparingInt(e -> ((AxolootlVariant)e.getValue()).getTier());
            variants.sort(comparator.thenComparing(e -> ((AxolootlVariant)e.getValue()).getDescription().getString()));
            for (Map.Entry variantId : variants) {
                ItemStack itemStack = new ItemStack((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get());
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("Axolootl", ((ResourceKey)variantId.getKey()).m_135782_().toString());
                itemStack.m_41751_(tag);
                list.add(itemStack);
                ItemStack babyItemStack = itemStack.m_41777_();
                babyItemStack.m_41783_().m_128405_("Age", -24000);
                list.add(babyItemStack);
            }
        } else {
            list.add(new ItemStack((ItemLike)AxRegistry.ItemReg.AXOLOOTL_BUCKET.get()));
        }
        return list;
    }

    public String m_5671_(ItemStack pStack) {
        if (AxolootlBucketItem.isBaby(pStack)) {
            return super.m_5671_(pStack) + ".baby";
        }
        return super.m_5671_(pStack);
    }

    public Rarity m_41460_(ItemStack pStack) {
        if (pStack.m_41782_() && pStack.m_41783_().m_128425_("Axolootl", 8)) {
            return AxolootlBucketItem.getCachedRarity(new ResourceLocation(pStack.m_41783_().m_128461_("Axolootl")));
        }
        return super.m_41460_(pStack);
    }

    private static Rarity getCachedRarity(ResourceLocation id) {
        RegistryAccess access;
        if (!RARITY_CACHE.containsKey(id) && (access = AxolootlBucketItem.registryAccess()) != null) {
            AxolootlVariant.getRegistry(access).m_6612_(id).ifPresent(variant -> RARITY_CACHE.put(id, variant.getRarity()));
        }
        return RARITY_CACHE.getOrDefault(id, Rarity.COMMON);
    }

    public static void clearRarityCache() {
        RARITY_CACHE.clear();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        Level level;
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        Level level2 = level = pLevel != null ? pLevel : (Level)ClientUtil.getClientLevel().orElse(null);
        if (level != null) {
            AxolootlBucketItem.getVariant(level.m_5962_(), pStack).ifPresentOrElse(a -> {
                ResourceLocation id = a.getRegistryName(level.m_5962_());
                MutableComponent tier = Component.m_237110_((String)"item.axolootl.axolootl_bucket.tooltip.tier", (Object[])new Object[]{a.getTierDescription()}).m_130940_(ChatFormatting.GRAY);
                MutableComponent description = a.getDescription().m_6881_().m_130940_(ChatFormatting.AQUA).m_130946_(" ").m_7220_((Component)tier);
                pTooltipComponents.add((Component)description);
                if (pIsAdvanced.m_7050_()) {
                    pTooltipComponents.add((Component)Component.m_237113_((String)id.toString()).m_130940_(ChatFormatting.GRAY));
                    if (a.hasMobResources()) {
                        pTooltipComponents.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.mob_resource_generator")).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    }
                    pTooltipComponents.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltip.primary_color"), (Object[])new Object[]{Integer.toHexString(a.getModelSettings().getPrimaryColor())}).m_130940_(ChatFormatting.GRAY));
                    pTooltipComponents.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltip.secondary_color"), (Object[])new Object[]{Integer.toHexString(a.getModelSettings().getSecondaryColor())}).m_130940_(ChatFormatting.GRAY));
                }
            }, () -> pTooltipComponents.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.unknown")).m_130940_(ChatFormatting.RED)));
            if (pIsAdvanced.m_7050_() && pStack.m_41782_() && pStack.m_41783_().m_128425_("Age", 3)) {
                pTooltipComponents.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltip.age"), (Object[])new Object[]{pStack.m_41783_().m_128451_("Age")}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            final LazyOptional<AxolootlBucketItemRenderer> renderer = LazyOptional.of(() -> new AxolootlBucketItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_(), Minecraft.m_91087_().m_91291_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Optional oRenderer = this.renderer.resolve();
                if (oRenderer.isPresent()) {
                    return (BlockEntityWithoutLevelRenderer)oRenderer.get();
                }
                return super.getCustomRenderer();
            }
        });
    }

    @Nullable
    private static RegistryAccess registryAccess() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return server.m_206579_();
        }
        Optional<Level> oLevel = ClientUtil.getClientLevel();
        if (oLevel.isPresent()) {
            return oLevel.get().m_5962_();
        }
        return null;
    }

    public static Optional<AxolootlVariant> getVariant(RegistryAccess registryAccess, ItemStack itemStack) {
        return AxolootlBucketItem.getVariant(registryAccess, itemStack, false);
    }

    public static Optional<AxolootlVariant> getVariant(RegistryAccess registryAccess, ItemStack itemStack, boolean includeAll) {
        if (!itemStack.m_41782_() || !itemStack.m_41783_().m_128425_("Axolootl", 8)) {
            return Optional.empty();
        }
        ResourceLocation id = new ResourceLocation(itemStack.m_41783_().m_128461_("Axolootl"));
        if (!includeAll && !AxRegistry.AxolootlVariantsReg.isValid(id)) {
            return Optional.empty();
        }
        return AxolootlVariant.getRegistry(registryAccess).m_6612_(id);
    }

    public static ItemStack getWithVariant(RegistryAccess registryAccess, ItemStack itemStack, AxolootlVariant variant) {
        return AxolootlBucketItem.getWithVariant(itemStack, variant.getRegistryName(registryAccess));
    }

    public static ItemStack getWithVariant(ItemStack itemStack, ResourceLocation variant) {
        itemStack.m_41784_().m_128359_("Axolootl", variant.toString());
        return itemStack;
    }

    public static boolean isBaby(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128425_("Age", 3) && itemStack.m_41783_().m_128451_("Age") < 0;
    }
}

