/*
 * Decompiled with CFR 0.152.
 */
package axolootl.menu;

import axolootl.AxRegistry;
import axolootl.block.entity.AxolootlInterfaceBlockEntity;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.data.axolootl_variant.AxolootlVariant;
import axolootl.item.AxolootlBucketItem;
import axolootl.menu.AbstractControllerMenu;
import axolootl.network.AxNetwork;
import axolootl.network.ServerBoundExtractAxolootlPacket;
import axolootl.network.ServerBoundInsertAxolootlPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AxolootlInterfaceMenu
extends AbstractControllerMenu {
    public static final int INV_X = 30;
    public static final int INV_Y = 108;
    public static int INV_SIZE = 5;
    private Container container;
    private Map<AxolootlVariant, Integer> variantCountMap = new HashMap<AxolootlVariant, Integer>();
    private int totalCount;

    public AxolootlInterfaceMenu(int windowId, Inventory inv, BlockPos controllerPos, ControllerBlockEntity blockEntity, BlockPos blockPos, int tab, int cycle) {
        super((MenuType)AxRegistry.MenuReg.AXOLOOTL.get(), windowId, inv, controllerPos, blockEntity, blockPos, tab, cycle);
        Container c;
        BlockEntity blockEntity2 = blockEntity.m_58904_().m_7702_(blockPos);
        this.container = blockEntity2 instanceof Container && (c = (Container)blockEntity2).m_6643_() == INV_SIZE ? c : new SimpleContainer(INV_SIZE);
        AxolootlInterfaceMenu.m_38869_((Container)this.container, (int)INV_SIZE);
        for (int i = 0; i < INV_SIZE; ++i) {
            this.m_38897_(new AxolootlSlot(this.container, i, 30 + i * 18, 108));
        }
        this.addPlayerSlots(inv, 30, 140);
        this.updateVariantMaps();
    }

    public void updateVariantMaps() {
        if (null == this.controller) {
            return;
        }
        HashMap<UUID, AxolootlVariant> variantMap = new HashMap<UUID, AxolootlVariant>();
        variantMap.putAll(this.controller.resolveAxolootlVariants(this.getInventory().f_35978_.f_19853_.m_5962_()));
        this.variantCountMap.clear();
        for (Map.Entry entry : variantMap.entrySet()) {
            int count = this.variantCountMap.getOrDefault(entry.getValue(), 0);
            this.variantCountMap.put((AxolootlVariant)entry.getValue(), count + 1);
        }
        this.totalCount = this.variantCountMap.values().stream().reduce(Integer::sum).orElse(0);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public Map<AxolootlVariant, Integer> getVariantCountMap() {
        return this.variantCountMap;
    }

    public void extract(AxolootlVariant variant) {
        if (variant == AxolootlVariant.EMPTY) {
            return;
        }
        if (this.getInventory().f_35978_.f_19853_.m_5776_()) {
            AxNetwork.CHANNEL.sendToServer((Object)new ServerBoundExtractAxolootlPacket(variant.getRegistryName(this.getInventory().f_35978_.f_19853_.m_5962_())));
            int count = this.variantCountMap.getOrDefault(variant, 0);
            if (count > 1) {
                this.variantCountMap.put(variant, Math.max(0, count - 1));
            } else {
                this.variantCountMap.remove(variant);
            }
            this.totalCount = this.variantCountMap.values().stream().reduce(Integer::sum).orElse(0);
        }
    }

    public void insert() {
        if (this.getInventory().f_35978_.f_19853_.m_5776_()) {
            AxNetwork.CHANNEL.sendToServer((Object)new ServerBoundInsertAxolootlPacket());
            if (this.controller != null) {
                int n = this.container.m_6643_();
                for (int i = 0; i < n; ++i) {
                    ItemStack itemStack = this.container.m_8020_(i);
                    Optional<AxolootlVariant> oVariant = AxolootlBucketItem.getVariant(this.getInventory().f_35978_.f_19853_.m_5962_(), itemStack);
                    oVariant.ifPresent(v -> this.variantCountMap.put((AxolootlVariant)v, this.variantCountMap.getOrDefault(v, 0) + 1));
                }
            }
            this.totalCount = this.variantCountMap.values().stream().reduce(Integer::sum).orElse(0);
        }
    }

    @Override
    public boolean hasPlayerSlots() {
        return true;
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return this.quickMoveStack(pPlayer, pIndex, INV_SIZE);
    }

    public boolean m_6875_(Player pPlayer) {
        return this.container.m_6542_(pPlayer);
    }

    public Container getContainer() {
        return this.container;
    }

    public void m_6877_(Player pPlayer) {
        if (this.container != null) {
            this.m_150411_(pPlayer, this.container);
            this.container.m_6596_();
        }
        super.m_6877_(pPlayer);
    }

    private static class AxolootlSlot
    extends Slot {
        public AxolootlSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack pStack) {
            return pStack.m_204117_(AxolootlInterfaceBlockEntity.ITEM_WHITELIST);
        }
    }
}

