/*
 * Decompiled with CFR 0.152.
 */
package axolootl.network;

import axolootl.block.entity.ControllerBlockEntity;
import axolootl.util.TankMultiblock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundActivateControllerPacket {
    private BlockPos pos;

    public ServerBoundActivateControllerPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static ServerBoundActivateControllerPacket fromBytes(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        return new ServerBoundActivateControllerPacket(pos);
    }

    public static void toBytes(ServerBoundActivateControllerPacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
    }

    public static void handlePacket(ServerBoundActivateControllerPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER && context.getSender() != null) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                BlockPos controllerPos = message.pos;
                BlockEntity patt2766$temp = player.f_19853_.m_7702_(controllerPos);
                if (!(patt2766$temp instanceof ControllerBlockEntity)) {
                    return;
                }
                ControllerBlockEntity controller = (ControllerBlockEntity)patt2766$temp;
                controller.setSize(TankMultiblock.AQUARIUM.hasTankStructure((LevelAccessor)player.m_9236_(), controllerPos).orElse(null));
            });
        }
        context.setPacketHandled(true);
    }
}

