/*
 * Decompiled with CFR 0.152.
 */
package axolootl.network;

import axolootl.AxRegistry;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.data.aquarium_tab.IAquariumTab;
import axolootl.data.aquarium_tab.WorldlyMenuProvider;
import axolootl.menu.AbstractControllerMenu;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class ServerBoundControllerTabPacket {
    private int tab;
    private int cycle;

    public ServerBoundControllerTabPacket(int tab) {
        this(tab, -1);
    }

    public ServerBoundControllerTabPacket(int tab, int cycle) {
        this.tab = tab;
        this.cycle = cycle;
    }

    public static ServerBoundControllerTabPacket fromBytes(FriendlyByteBuf buf) {
        int tab = buf.readInt();
        int cycle = buf.readInt();
        return new ServerBoundControllerTabPacket(tab, cycle);
    }

    public static void toBytes(ServerBoundControllerTabPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.tab);
        buf.writeInt(msg.cycle);
    }

    public static void handlePacket(ServerBoundControllerTabPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER && context.getSender() != null) {
            context.enqueueWork(() -> {
                AbstractControllerMenu menu;
                ServerPlayer player = context.getSender();
                AbstractContainerMenu patt2814$temp = player.f_36096_;
                if (!(patt2814$temp instanceof AbstractControllerMenu) || (menu = (AbstractControllerMenu)patt2814$temp).getController().isEmpty()) {
                    return;
                }
                BlockPos pos = menu.getControllerPos();
                ControllerBlockEntity controller = (ControllerBlockEntity)player.f_19853_.m_7702_(pos);
                if (null == controller) {
                    return;
                }
                IAquariumTab tab = AxRegistry.AquariumTabsReg.getSortedTabs().get(menu.validateTab(message.tab));
                if (!tab.isAvailable(controller)) {
                    return;
                }
                if (message.cycle >= menu.getSortedCycleList().size()) {
                    return;
                }
                Optional<WorldlyMenuProvider> oProvider = tab.getMenuProvider(controller, null);
                if (oProvider.isEmpty()) {
                    return;
                }
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)oProvider.get().getProvider(), AxRegistry.MenuReg.writeControllerMenu(pos, oProvider.get().getPos(), message.tab, message.cycle));
            });
        }
        context.setPacketHandled(true);
    }
}

