/*
 * Decompiled with CFR 0.152.
 */
package axolootl.network;

import axolootl.block.entity.AxolootlInterfaceBlockEntity;
import axolootl.block.entity.ControllerBlockEntity;
import axolootl.menu.AxolootlInterfaceMenu;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundExtractAxolootlPacket {
    private ResourceLocation id;

    public ServerBoundExtractAxolootlPacket(ResourceLocation id) {
        this.id = id;
    }

    public static ServerBoundExtractAxolootlPacket fromBytes(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        return new ServerBoundExtractAxolootlPacket(id);
    }

    public static void toBytes(ServerBoundExtractAxolootlPacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.id);
    }

    public static void handlePacket(ServerBoundExtractAxolootlPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER && context.getSender() != null) {
            context.enqueueWork(() -> {
                AxolootlInterfaceMenu menu;
                ServerPlayer player = context.getSender();
                AbstractContainerMenu patt2654$temp = player.f_36096_;
                if (!(patt2654$temp instanceof AxolootlInterfaceMenu) || (menu = (AxolootlInterfaceMenu)patt2654$temp).getController().isEmpty()) {
                    return;
                }
                BlockPos controllerPos = menu.getController().get().m_58899_();
                ControllerBlockEntity controller = (ControllerBlockEntity)player.f_19853_.m_7702_(controllerPos);
                if (null == controller) {
                    return;
                }
                BlockPos blockPos = menu.getBlockPos();
                AxolootlInterfaceBlockEntity axolootlInterface = (AxolootlInterfaceBlockEntity)player.f_19853_.m_7702_(blockPos);
                if (null == axolootlInterface) {
                    return;
                }
                Optional oHandler = axolootlInterface.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve();
                if (oHandler.isEmpty()) {
                    return;
                }
                IItemHandler handler = (IItemHandler)oHandler.get();
                int bucketSlot = -1;
                int n = handler.getSlots();
                for (int i = 0; i < n; ++i) {
                    if (!handler.extractItem(i, 1, true).m_150930_(Items.f_42446_)) continue;
                    bucketSlot = i;
                    break;
                }
                if (bucketSlot < 0) {
                    return;
                }
                UUID uuid = null;
                for (Map.Entry<UUID, ResourceLocation> entry : controller.getTrackedAxolootls().entrySet()) {
                    if (!entry.getValue().equals((Object)message.id)) continue;
                    uuid = entry.getKey();
                    break;
                }
                if (null == uuid) {
                    return;
                }
                ItemStack itemStack = controller.removeAxolootl(player.m_9236_(), uuid);
                if (itemStack.m_41619_()) {
                    return;
                }
                handler.extractItem(bucketSlot, 1, false);
                int n2 = handler.getSlots();
                for (int i = 0; i < n2 && !(itemStack = handler.insertItem(i, itemStack, false)).m_41619_(); ++i) {
                }
                if (!itemStack.m_41619_() && !player.m_150109_().m_36054_(itemStack)) {
                    player.m_36176_(itemStack, false);
                }
                controller.m_6596_();
                player.f_19853_.m_7260_(controllerPos, controller.m_58900_(), controller.m_58900_(), 2);
            });
        }
        context.setPacketHandled(true);
    }
}

