/*
 * Decompiled with CFR 0.152.
 */
package axolootl.util;

import axolootl.util.AxCodecUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class DeferredHolderSet<T> {
    private final Either<TagKey<T>, List<ResourceKey<T>>> either;
    private HolderSet<T> holderSet;

    public DeferredHolderSet(TagKey<T> tagKey) {
        this(Either.left(tagKey));
    }

    public DeferredHolderSet(ResourceKey<T> list) {
        this((List<ResourceKey<T>>)ImmutableList.of(list));
    }

    public DeferredHolderSet(List<ResourceKey<T>> list) {
        this(Either.right(list));
    }

    public DeferredHolderSet(Either<TagKey<T>, List<ResourceKey<T>>> either) {
        this.either = either;
    }

    public Either<TagKey<T>, List<ResourceKey<T>>> unwrap() {
        return this.either;
    }

    public HolderSet<T> get(Registry<T> registry) {
        if (null == this.holderSet) {
            this.holderSet = DeferredHolderSet.build(registry, this.unwrap());
        }
        return this.holderSet;
    }

    public static <T> Codec<DeferredHolderSet<T>> codec(ResourceKey<? extends Registry<T>> registry) {
        return DeferredHolderSet.eitherCodec(registry).xmap(DeferredHolderSet::new, DeferredHolderSet::unwrap);
    }

    public static <T> Codec<Either<TagKey<T>, List<ResourceKey<T>>>> eitherCodec(ResourceKey<? extends Registry<T>> registry) {
        return Codec.either((Codec)TagKey.m_203886_(registry), AxCodecUtils.listOrElementCodec(ResourceKey.m_195966_(registry)));
    }

    private static <T> HolderSet<T> build(Registry<T> registry, Either<TagKey<T>, List<ResourceKey<T>>> either) {
        if (either.left().isPresent()) {
            return registry.m_203561_((TagKey)either.left().get());
        }
        if (either.right().isPresent()) {
            ArrayList<Holder> list = new ArrayList<Holder>();
            for (ResourceKey key : (List)either.right().get()) {
                Optional oHolder = registry.m_203636_(key);
                if (!oHolder.isPresent()) continue;
                list.add((Holder)oHolder.get());
            }
            return HolderSet.m_205800_(list);
        }
        throw new IllegalStateException("[ModifierCondition#asHolderSet] Either has neither left nor right! " + either);
    }
}

