/*
 * Decompiled with CFR 0.152.
 */
package axolootl.util;

import axolootl.AxRegistry;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;

public class NbtPredicate
implements BlockPredicate {
    public static final NbtPredicate ANY = new NbtPredicate(null);
    public static final Codec<NbtPredicate> CODEC = Codec.STRING.flatXmap(NbtPredicate::parse, o -> DataResult.success((Object)o.getTagString()));
    @Nullable
    private final CompoundTag tag;
    @Nullable
    private final String tagString;

    public NbtPredicate(@Nullable CompoundTag pTag) {
        this.tag = pTag;
        this.tagString = pTag != null ? pTag.m_7916_() : "";
    }

    public Optional<CompoundTag> getTag() {
        return Optional.ofNullable(this.tag);
    }

    public boolean matches(BlockEntity blockEntity) {
        return this == ANY || this.matches((Tag)blockEntity.m_187482_());
    }

    public boolean matches(@Nullable Tag pTag) {
        if (pTag == null) {
            return this == ANY;
        }
        return this.tag == null || NbtUtils.m_129235_((Tag)this.tag, (Tag)pTag, (boolean)true);
    }

    public BlockPredicateType<?> m_183575_() {
        return (BlockPredicateType)AxRegistry.BlockPredicateTypesReg.MATCHING_TAG.get();
    }

    public boolean test(WorldGenLevel level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (null == blockEntity) {
            return false;
        }
        return this.matches(blockEntity);
    }

    public String getTagString() {
        return this.tagString;
    }

    public static DataResult<NbtPredicate> parse(@Nullable String tagString) {
        CompoundTag compoundTag;
        if (null == tagString || tagString.isEmpty()) {
            return DataResult.success((Object)ANY);
        }
        try {
            compoundTag = TagParser.m_129359_((String)tagString);
        }
        catch (CommandSyntaxException e) {
            return DataResult.error((String)("Invalid nbt tag: " + e.getMessage()));
        }
        return DataResult.success((Object)new NbtPredicate(compoundTag));
    }
}

