/*
 * Decompiled with CFR 0.152.
 */
package axolootl.util;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class ShapeUtils {
    public static final double MAX_ENTITY_SIZE = 0.62;
    public static final double MAX_VOLUME = 0.238328;

    private ShapeUtils() {
    }

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.m_83148_((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.f_82695_);
    }

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.orUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimized(from, to, shape).m_83296_();
    }

    public static VoxelShape rotateShapeUnoptimized(Direction from, Direction to, VoxelShape shape) {
        if (from.m_122434_().m_122478_() || to.m_122434_().m_122478_()) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.m_83299_();
        VoxelShape rotatedShape = Shapes.m_83040_();
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.m_83064_((AABB)box));
        }
        return rotatedShape;
    }

    public static Map<Direction, VoxelShape> rotateShapesUnoptimized(Direction from, VoxelShape shape) {
        if (from.m_122434_().m_122478_()) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        EnumMap<Direction, VoxelShape> rotatedShapes = new EnumMap<Direction, VoxelShape>(Direction.class);
        rotatedShapes.put(from, shape);
        List sourceBoxes = shape.m_83299_();
        Function<Direction, VoxelShape> computeShapeIfAbsent = d -> Shapes.m_83040_();
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < 3; ++i) {
                Direction direction = Direction.m_122407_((int)(from.m_122416_() + i + 1));
                box = new AABB(1.0 - box.f_82293_, box.f_82289_, box.f_82288_, 1.0 - box.f_82290_, box.f_82292_, box.f_82291_);
                rotatedShapes.put(direction, ShapeUtils.orUnoptimized(rotatedShapes.computeIfAbsent(direction, computeShapeIfAbsent), Shapes.m_83064_((AABB)box)));
            }
        }
        return rotatedShapes;
    }

    public static Map<Direction, VoxelShape> rotateShapes(Direction from, VoxelShape shape) {
        Map<Direction, VoxelShape> rotatedShapes = ShapeUtils.rotateShapesUnoptimized(from, shape);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            rotatedShapes.put(direction, rotatedShapes.get(direction).m_83296_());
        }
        return rotatedShapes;
    }

    public static boolean canEntityPass(Entity entity) {
        return entity != null && !(ShapeUtils.volume(entity.m_20191_()) > 0.238328);
    }

    public static double volume(AABB aabb) {
        return aabb.m_82362_() * aabb.m_82376_() * aabb.m_82385_();
    }
}

