/*
 * Decompiled with CFR 0.152.
 */
package axolootl.util;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

@Immutable
public class TankMultiblock {
    public static final TagKey<Block> AQUARIUM_BLOCKS = ForgeRegistries.BLOCKS.tags().createTagKey(new ResourceLocation("axolootl", "aquarium"));
    public static TankMultiblock AQUARIUM = new TankMultiblock(new Vec3i(3, 3, 3), new Vec3i(64, 64, 64), AQUARIUM_BLOCKS);
    public final BlockPos minSize;
    public final BlockPos maxSize;
    public final TagKey<Block> blocks;
    public final long minVolume;
    public final long maxVolume;

    public TankMultiblock(Vec3i minSize, Vec3i maxSize, TagKey<Block> blocks) {
        if (minSize.m_123341_() < 1 || minSize.m_123342_() < 1 || minSize.m_123343_() < 1 || maxSize.m_123341_() < 1 || maxSize.m_123342_() < 1 || maxSize.m_123343_() < 1) {
            throw new IllegalArgumentException("[TankMultiblock] Invalid size bounds! All values must be greater than zero. min=" + minSize + " max=" + maxSize);
        }
        this.minSize = new BlockPos(Math.max(0, minSize.m_123341_() - 1), Math.max(0, minSize.m_123342_() - 1), Math.max(0, minSize.m_123343_() - 1));
        this.maxSize = new BlockPos(Math.max(this.minSize.m_123341_(), maxSize.m_123341_() - 1), Math.max(this.minSize.m_123341_(), maxSize.m_123342_() - 1), Math.max(this.minSize.m_123343_(), maxSize.m_123343_() - 1));
        this.blocks = blocks;
        this.minVolume = (long)minSize.m_123341_() * (long)minSize.m_123342_() * (long)minSize.m_123343_();
        this.maxVolume = (long)maxSize.m_123341_() * (long)maxSize.m_123342_() * (long)maxSize.m_123343_();
    }

    public Optional<Size> hasTankStructure(LevelAccessor level, BlockPos pos) {
        BlockPos origin = this.calculateOrigin(level, pos);
        BlockPos end = this.calculateEnd(level, pos);
        BlockPos dimensions = end.m_121996_((Vec3i)origin);
        int volume = dimensions.m_123341_() * dimensions.m_123342_() * dimensions.m_123343_();
        if ((long)volume < this.minVolume || (long)volume > this.maxVolume || dimensions.m_123341_() < this.minSize.m_123341_() || dimensions.m_123342_() < this.minSize.m_123342_() || dimensions.m_123343_() < this.minSize.m_123343_() || dimensions.m_123341_() > this.maxSize.m_123341_() || dimensions.m_123342_() > this.maxSize.m_123342_() || dimensions.m_123343_() > this.maxSize.m_123343_()) {
            return Optional.empty();
        }
        Size size = new Size(origin, (Vec3i)dimensions);
        for (BlockPos p : size.outerPositions()) {
            if (this.isTankBlock(level, p)) continue;
            return Optional.empty();
        }
        return Optional.of(size);
    }

    public Optional<Boolean> hasTankStructure(LevelAccessor level, Size size) {
        if (!size.isAreaLoaded(level)) {
            return Optional.empty();
        }
        for (BlockPos p : size.outerPositions()) {
            if (this.isTankBlock(level, p)) continue;
            return Optional.of(false);
        }
        return Optional.of(true);
    }

    public boolean isTankBlock(LevelAccessor level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(this.blocks);
    }

    public Optional<Size> isInsideTankStructure(LevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos cursor = pos.m_122032_();
        int offsetY = 0;
        while (!level.m_151570_((BlockPos)cursor) && !this.isTankBlock(level, (BlockPos)cursor) && offsetY++ < this.maxSize.m_123342_()) {
            cursor.m_122173_(Direction.DOWN);
        }
        return this.hasTankStructure(level, (BlockPos)cursor);
    }

    public BlockPos calculateOrigin(LevelAccessor level, BlockPos pos) {
        return this.trace(level, pos, Direction.AxisDirection.NEGATIVE);
    }

    public BlockPos calculateEnd(LevelAccessor level, BlockPos pos) {
        return this.trace(level, pos, Direction.AxisDirection.POSITIVE);
    }

    public BlockPos trace(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis) {
        Direction axisZ;
        Direction axisY;
        Direction axisX;
        if (axis == Direction.AxisDirection.NEGATIVE) {
            axisX = Direction.WEST;
            axisY = Direction.DOWN;
            axisZ = Direction.NORTH;
        } else {
            axisX = Direction.EAST;
            axisY = Direction.UP;
            axisZ = Direction.SOUTH;
        }
        BlockPos.MutableBlockPos cursor = pos.m_122032_();
        BlockPos.MutableBlockPos next = pos.m_122032_();
        int offsetY = 0;
        while (!level.m_151570_((BlockPos)next) && this.isTankBlock(level, (BlockPos)next.m_122173_(axisY)) && offsetY++ < this.maxSize.m_123342_()) {
            cursor.m_122190_((Vec3i)next);
        }
        next.m_122190_((Vec3i)cursor);
        int offsetX = 0;
        while (this.isTankBlock(level, (BlockPos)next.m_122173_(axisX)) && offsetX++ < this.maxSize.m_123341_()) {
            cursor.m_122190_((Vec3i)next);
        }
        next.m_122190_((Vec3i)cursor);
        int offsetZ = 0;
        while (this.isTankBlock(level, (BlockPos)next.m_122173_(axisZ)) && offsetZ++ < this.maxSize.m_123343_()) {
            cursor.m_122190_((Vec3i)next);
        }
        next.m_122190_((Vec3i)cursor);
        while (!level.m_151570_((BlockPos)next) && this.isTankBlock(level, (BlockPos)next.m_122173_(axisY)) && offsetY++ < this.maxSize.m_123342_()) {
            cursor.m_122190_((Vec3i)next);
        }
        return cursor.m_7949_();
    }

    @Immutable
    public static class Size {
        public static final Size EMPTY = new Size(BlockPos.f_121853_, Vec3i.f_123288_);
        public static final Codec<Size> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("origin").forGetter(Size::getOrigin), (App)Vec3i.f_123287_.fieldOf("dimensions").forGetter(Size::getDimensions)).apply((Applicative)instance, Size::new));
        private final BlockPos origin;
        private final Vec3i dimensions;
        private final long volume;
        private final long innerVolume;
        private final BoundingBox boundingBox;
        private final AABB aabb;
        private final ChunkPos minChunk;
        private final ChunkPos maxChunk;

        public Size(BlockPos origin, Vec3i dimensions) {
            this.origin = origin.m_7949_();
            this.dimensions = new Vec3i(Math.abs(dimensions.m_123341_()), Math.abs(dimensions.m_123342_()), Math.abs(dimensions.m_123343_()));
            this.volume = ((long)dimensions.m_123341_() + 1L) * ((long)dimensions.m_123342_() + 1L) * ((long)dimensions.m_123343_() + 1L);
            this.innerVolume = Math.max(0L, (long)dimensions.m_123341_() - 1L) * Math.max(0L, (long)dimensions.m_123342_() - 1L) * Math.max(0L, (long)dimensions.m_123343_() - 1L);
            this.boundingBox = BoundingBox.m_162375_((Vec3i)this.origin, (Vec3i)this.origin.m_121955_(this.dimensions));
            this.aabb = AABB.m_82321_((BoundingBox)this.boundingBox);
            this.minChunk = new ChunkPos(this.origin);
            this.maxChunk = new ChunkPos(this.origin.m_121955_(this.dimensions));
        }

        public Iterable<BlockPos> outerPositions() {
            Iterable floor = BlockPos.m_121940_((BlockPos)this.origin, (BlockPos)this.origin.m_7918_(this.dimensions.m_123341_(), 0, this.dimensions.m_123343_()));
            Iterable roof = BlockPos.m_121940_((BlockPos)this.origin.m_7918_(0, this.dimensions.m_123342_(), 0), (BlockPos)this.origin.m_7918_(this.dimensions.m_123341_(), this.dimensions.m_123342_(), this.dimensions.m_123343_()));
            Iterable west = BlockPos.m_121940_((BlockPos)this.origin.m_7918_(1, 1, 0), (BlockPos)this.origin.m_7918_(this.dimensions.m_123341_() - 1, this.dimensions.m_123342_() - 1, 0));
            Iterable east = BlockPos.m_121940_((BlockPos)this.origin.m_7918_(1, 1, this.dimensions.m_123343_()), (BlockPos)this.origin.m_7918_(this.dimensions.m_123341_() - 1, this.dimensions.m_123342_() - 1, this.dimensions.m_123343_()));
            Iterable north = BlockPos.m_121940_((BlockPos)this.origin.m_7918_(0, 1, 0), (BlockPos)this.origin.m_7918_(0, this.dimensions.m_123342_() - 1, this.dimensions.m_123343_()));
            Iterable south = BlockPos.m_121940_((BlockPos)this.origin.m_7918_(this.dimensions.m_123341_(), 1, 0), (BlockPos)this.origin.m_7918_(this.dimensions.m_123341_(), this.dimensions.m_123342_() - 1, this.dimensions.m_123343_()));
            return Iterables.concat((Iterable[])new Iterable[]{floor, roof, west, east, north, south});
        }

        public Iterable<BlockPos> innerPositions() {
            BlockPos start = this.origin.m_7918_(1, 1, 1);
            BlockPos end = this.origin.m_121955_(this.dimensions).m_7918_(-1, -1, -1);
            return BlockPos.m_121940_((BlockPos)start, (BlockPos)end);
        }

        public boolean isAreaLoaded(LevelAccessor level) {
            return level.m_46832_(this.origin, this.origin.m_121955_(this.dimensions));
        }

        public String toString() {
            return "Size {origin=" + this.origin + " dimensions=" + this.dimensions + "}";
        }

        public BlockPos getOrigin() {
            return this.origin;
        }

        public Vec3i getDimensions() {
            return new Vec3i(this.dimensions.m_123341_(), this.dimensions.m_123342_(), this.dimensions.m_123343_());
        }

        public Vec3i getFullDimensions() {
            return new Vec3i(this.dimensions.m_123341_() + 1, this.dimensions.m_123342_() + 1, this.dimensions.m_123343_() + 1);
        }

        public long getVolume() {
            return this.volume;
        }

        public long getInnerVolume() {
            return this.innerVolume;
        }

        public BoundingBox boundingBox() {
            return this.boundingBox;
        }

        public AABB aabb() {
            return this.aabb;
        }

        public ChunkPos getMinChunk() {
            return this.minChunk;
        }

        public ChunkPos getMaxChunk() {
            return this.maxChunk;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Size)) {
                return false;
            }
            Size size = (Size)o;
            return this.origin.equals((Object)size.origin) && this.dimensions.equals((Object)size.dimensions);
        }

        public int hashCode() {
            return Objects.hash(this.origin, this.dimensions);
        }
    }
}

