/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import me.fzzyhmstrs.fzzy_config.util.Expression;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedExpression;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u0006\n\u0002\b\b\b\u00e7\u0080\u0001\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bJ#\u0010\u0006\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H'\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\t\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0003"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/Expression;", "", "", "", "", "vars", "eval", "(Ljava/util/Map;)D", "fallback", "evalSafe", "(Ljava/util/Map;D)D", "Impl", "fzzy_config"})
public interface Expression {
    @NotNull
    public static final Impl Impl = me.fzzyhmstrs.fzzy_config.util.Expression$Impl.$$INSTANCE;

    @Deprecated(message="Where possible use safeEval() to avoid throwing exceptions on evaluation failure")
    public double eval(@NotNull Map<Character, Double> var1);

    default public double evalSafe(@NotNull Map<Character, Double> vars, double fallback) {
        double d;
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        try {
            d = this.eval(vars);
        }
        catch (Exception e) {
            d = fallback;
        }
        return d;
    }

    @JvmStatic
    @NotNull
    public static Expression parse(@NotNull String str) {
        return Impl.parse(str);
    }

    @JvmStatic
    @Deprecated(message="Consider using parse(str) to automatically pass the string expression as it's own context")
    @NotNull
    public static Expression parse(@NotNull String str, @NotNull String context) {
        return Impl.parse(str, context);
    }

    @JvmStatic
    @NotNull
    public static ValidationResult<Expression> tryParse(@NotNull String str) {
        return Impl.tryParse(str);
    }

    @JvmStatic
    @NotNull
    public static ValidationResult<Expression> tryTest(@NotNull String str, @NotNull Set<Character> vars) {
        return Impl.tryTest(str, vars);
    }

    @JvmStatic
    @NotNull
    public static ValidatedExpression validated(@NotNull String str, @NotNull Set<Character> vars) {
        return Impl.validated(str, vars);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @java.lang.Deprecated
        public static double evalSafe(@NotNull Expression $this, @NotNull Map<Character, Double> vars, double fallback) {
            Intrinsics.checkNotNullParameter(vars, (String)"vars");
            return $this.evalSafe(vars, fallback);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001XB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u0007J\u001f\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0007J\u001f\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0007J\u001f\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000fJ\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0007J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0007J)\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u000fJ\u001f\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u000fJ\u0017\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b \u0010\u0007J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\"\u0010$J;\u0010)\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010&\u001a\u00020%2\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040'\"\u00020\u0004H\u0002\u00a2\u0006\u0004\b)\u0010*J)\u0010-\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b-\u0010.J/\u00100\u001a\b\u0012\u0004\u0012\u00020\u00040/2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b0\u00101J\u001f\u00102\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b2\u0010\u000fJ\u001f\u00103\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b3\u0010\u000fJ\u0017\u00104\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b4\u0010\u0007J\u0017\u00105\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b5\u0010\u0007J\u0017\u00106\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b6\u0010\u0007J\u001f\u00107\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b7\u0010\u000fJ\u001f\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004082\u0006\u0010!\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b9\u0010:J-\u0010>\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004082\u0006\u0010!\u001a\u00020\u00192\f\u0010=\u001a\b\u0012\u0004\u0012\u00020<0;H\u0007\u00a2\u0006\u0004\b>\u0010?J'\u0010A\u001a\u00020@2\u0006\u0010!\u001a\u00020\u00192\u000e\b\u0002\u0010=\u001a\b\u0012\u0004\u0012\u00020<0;H\u0007\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010C\u001a\u00020\u00042\u0006\u0010C\u001a\u00020<H\u0002\u00a2\u0006\u0004\bC\u0010DR;\u0010G\u001a&\u0012\f\u0012\n F*\u0004\u0018\u00010\u00040\u0004 F*\u0012\u0012\f\u0012\n F*\u0004\u0018\u00010\u00040\u0004\u0018\u00010E0E8\u0006\u00a2\u0006\f\n\u0004\bG\u0010H\u001a\u0004\bI\u0010JR\u0014\u0010L\u001a\u00020K8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bL\u0010MR \u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020O0N8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u001c\u0010S\u001a\n F*\u0004\u0018\u00010R0R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0016\u0010V\u001a\u0004\u0018\u00010U8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010W\u00a8\u0006Y"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/Expression$Impl;", "", "<init>", "()V", "Lme/fzzyhmstrs/fzzy_config/util/Expression;", "e1", "abs", "(Lme/fzzyhmstrs/fzzy_config/util/Expression;)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "ceil", "", "constant", "(D)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "cos", "e2", "divide", "(Lme/fzzyhmstrs/fzzy_config/util/Expression;Lme/fzzyhmstrs/fzzy_config/util/Expression;)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "floor", "incr", "ln", "power", "log", "log10", "log2", "Lcom/mojang/brigadier/StringReader;", "reader", "", "context", "chunk", "mathHelper", "(Lcom/mojang/brigadier/StringReader;Ljava/lang/String;Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "minus", "mod", "parentheses", "str", "parse", "(Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "(Ljava/lang/String;Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "", "order", "", "inputs", "parseExpression", "(Lcom/mojang/brigadier/StringReader;Ljava/lang/String;I[Lme/fzzyhmstrs/fzzy_config/util/Expression;)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "", "read", "parseParentheses", "(Lcom/mojang/brigadier/StringReader;Ljava/lang/String;Z)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "", "parseParenthesesMultiple", "(Lcom/mojang/brigadier/StringReader;Ljava/lang/String;Z)Ljava/util/List;", "plus", "pow", "round", "sin", "sqrt", "times", "Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "tryParse", "(Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "", "", "vars", "tryTest", "(Ljava/lang/String;Ljava/util/Set;)Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedExpression;", "validated", "(Ljava/lang/String;Ljava/util/Set;)Lme/fzzyhmstrs/fzzy_config/validation/misc/ValidatedExpression;", "variable", "(C)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "Lcom/mojang/serialization/Codec;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "Lkotlin/reflect/KType;", "doubleType", "Lkotlin/reflect/KType;", "", "Lme/fzzyhmstrs/fzzy_config/util/Expression$Impl$NamedExpression;", "expressions", "Ljava/util/Map;", "Lnet/minecraft/class_5819;", "random", "Lnet/minecraft/class_5819;", "Lkotlin/reflect/KClassifier;", "randomClassifier", "Lkotlin/reflect/KClassifier;", "NamedExpression", "fzzy_config"})
    @SourceDebugExtension(value={"SMAP\nExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Expression.kt\nme/fzzyhmstrs/fzzy_config/util/Expression$Impl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,700:1\n1179#2,2:701\n1253#2,4:703\n1549#2:707\n1620#2,3:708\n288#2:711\n1603#2,9:712\n1855#2:721\n1856#2:723\n1612#2:724\n289#2:725\n1#3:722\n*S KotlinDebug\n*F\n+ 1 Expression.kt\nme/fzzyhmstrs/fzzy_config/util/Expression$Impl\n*L\n165#1:701,2\n165#1:703,4\n410#1:707\n410#1:708,3\n637#1:711\n638#1:712,9\n638#1:721\n638#1:723\n638#1:724\n637#1:725\n638#1:722\n*E\n"})
    public static final class Impl {
        static final /* synthetic */ Impl $$INSTANCE;
        private static final Codec<Expression> CODEC;
        @NotNull
        private static final Map<String, NamedExpression> expressions;
        @NotNull
        private static final KType doubleType;
        @Nullable
        private static final KClassifier randomClassifier;
        private static final class_5819 random;

        private Impl() {
        }

        public final Codec<Expression> getCODEC() {
            return CODEC;
        }

        @JvmStatic
        @NotNull
        public final Expression parse(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            return this.parse(str, str);
        }

        @JvmStatic
        @Deprecated(message="Consider using parse(str) to automatically pass the string expression as it's own context")
        @NotNull
        public final Expression parse(@NotNull String str, @NotNull String context) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                StringReader reader = new StringReader(str);
                return this.parseExpression(reader, context, 1000, new Expression[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error parsing math equation [" + context + "]: " + e.getLocalizedMessage());
            }
        }

        @JvmStatic
        @NotNull
        public final ValidationResult<Expression> tryParse(@NotNull String str) {
            ValidationResult<Object> validationResult;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            try {
                StringReader reader = new StringReader(str);
                validationResult = ValidationResult.Companion.success(this.parseExpression(reader, str, 1000, new Expression[0]));
            }
            catch (Exception e) {
                String string = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
                validationResult = ValidationResult.Companion.error(null, string);
            }
            return validationResult;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ValidationResult<Expression> tryTest(@NotNull String str, @NotNull Set<Character> vars) {
            ValidationResult<Expression> validationResult;
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter(vars, (String)"vars");
            ValidationResult<Expression> result = this.tryParse(str);
            if (result.isError() || vars.isEmpty()) {
                return result;
            }
            Iterable $this$associate$iv = vars;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                char it = ((Character)element$iv$iv).charValue();
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)Character.valueOf(it), (Object)0.0);
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map varMap = destination$iv$iv;
            try {
                Expression expression = result.get();
                if (expression != null) {
                    expression.eval(varMap);
                }
                validationResult = result;
            }
            catch (Exception e) {
                validationResult = ValidationResult.Companion.error(null, "Incorrect variables used in expression: [" + str + "], available: [" + vars + "]");
            }
            return validationResult;
        }

        @JvmStatic
        @NotNull
        public final ValidatedExpression validated(@NotNull String str, @NotNull Set<Character> vars) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Intrinsics.checkNotNullParameter(vars, (String)"vars");
            this.parse(str);
            return new ValidatedExpression(str, vars, null, 4, null);
        }

        public static /* synthetic */ ValidatedExpression validated$default(Impl impl, String string, Set set, int n, Object object) {
            if ((n & 2) != 0) {
                set = SetsKt.emptySet();
            }
            return impl.validated(string, set);
        }

        private final Expression parseExpression(StringReader reader, String context, int order, Expression ... inputs) {
            String string = reader.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (((CharSequence)string).length() == 0) {
                throw new IllegalStateException("Empty Expression found in math equation [" + context + "]");
            }
            reader.skipWhitespace();
            if (StringReader.isAllowedNumber((char)reader.peek())) {
                Expression expression;
                if (reader.peek() == '-') {
                    if (reader.canRead(1) && (CharsKt.isWhitespace((char)reader.peek(1)) || !StringReader.isAllowedNumber((char)reader.peek(1)))) {
                        if (3 > order) {
                            return inputs[0];
                        }
                        reader.read();
                        Expression expression1 = inputs[0];
                        Expression expression2 = this.parseExpression(reader, context, 3, new Expression[0]);
                        return this.minus(expression1, expression2);
                    }
                    if (reader.canRead(1)) {
                        Expression expression2;
                        double number1 = reader.readDouble();
                        if (reader.canRead()) {
                            Expression[] expressionArray = new Expression[]{this.constant(number1)};
                            expression2 = this.parseExpression(reader, context, order, expressionArray);
                        } else {
                            expression2 = this.constant(number1);
                        }
                        return expression2;
                    }
                    CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType(() -> Impl.parseExpression$lambda$15(context)).createWithContext((ImmutableStringReader)reader);
                    Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"createWithContext(...)");
                    throw (Throwable)commandSyntaxException;
                }
                double number1 = reader.readDouble();
                if (reader.canRead()) {
                    Expression[] expressionArray = new Expression[]{this.constant(number1)};
                    expression = this.parseExpression(reader, context, order, expressionArray);
                } else {
                    expression = this.constant(number1);
                }
                return expression;
            }
            if (reader.peek() == '(') {
                Expression expression;
                Expression parentheses2 = me.fzzyhmstrs.fzzy_config.util.Expression$Impl.parseParentheses$default(this, reader, context, false, 4, null);
                if (reader.canRead()) {
                    Expression[] expression2 = new Expression[]{parentheses2};
                    expression = this.parseExpression(reader, context, 1000, expression2);
                } else {
                    expression = parentheses2;
                }
                return expression;
            }
            if (reader.peek() == '^') {
                Expression expression;
                if (1 > order) {
                    return inputs[0];
                }
                reader.read();
                Expression expression1 = inputs[0];
                Expression expression2 = this.parseExpression(reader, context, 1, new Expression[0]);
                if (reader.canRead()) {
                    Expression[] expressionArray = new Expression[]{this.pow(expression1, expression2)};
                    expression = this.parseExpression(reader, context, 1000, expressionArray);
                } else {
                    expression = this.pow(expression1, expression2);
                }
                return expression;
            }
            if (reader.peek() == '*') {
                if (2 > order) {
                    return inputs[0];
                }
                reader.read();
                Expression expression1 = inputs[0];
                Expression expression2 = this.parseExpression(reader, context, 2, new Expression[0]);
                return this.times(expression1, expression2);
            }
            if (reader.peek() == '/') {
                if (2 > order) {
                    return inputs[0];
                }
                reader.read();
                Expression expression1 = inputs[0];
                Expression expression2 = this.parseExpression(reader, context, 2, new Expression[0]);
                return this.divide(expression1, expression2);
            }
            if (reader.peek() == '%') {
                if (2 > order) {
                    return inputs[0];
                }
                reader.read();
                Expression expression1 = inputs[0];
                Expression expression2 = this.parseExpression(reader, context, 3, new Expression[0]);
                return this.mod(expression1, expression2);
            }
            if (reader.peek() == '+') {
                if (3 > order) {
                    return inputs[0];
                }
                reader.read();
                Expression expression1 = inputs[0];
                Expression expression2 = this.parseExpression(reader, context, 3, new Expression[0]);
                return this.plus(expression1, expression2);
            }
            if (reader.peek() == '-') {
                if (3 > order) {
                    return inputs[0];
                }
                reader.read();
                Expression expression1 = inputs[0];
                Expression expression2 = this.parseExpression(reader, context, 3, new Expression[0]);
                return this.minus(expression1, expression2);
            }
            if (Character.isLetter(reader.peek()) && !reader.canRead(2)) {
                return this.variable(reader.peek());
            }
            if (Character.isLetter(reader.peek()) && reader.canRead(2)) {
                Object object;
                if (!Character.isLetter(reader.peek(1))) {
                    Expression variable2 = this.variable(reader.peek());
                    reader.read();
                    Expression[] expressionArray = new Expression[]{variable2};
                    object = this.parseExpression(reader, context, order, expressionArray);
                } else {
                    String string2 = reader.readStringUntil('(');
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readStringUntil(...)");
                    String chunk = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
                    object = expressions.get(chunk);
                    if ((object == null || (object = object.get(reader, context, chunk)) == null) && (object = this.mathHelper(reader, context, chunk)) == null) {
                        CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType(() -> Impl.parseExpression$lambda$16(chunk, context)).createWithContext((ImmutableStringReader)reader);
                        Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"createWithContext(...)");
                        throw (Throwable)commandSyntaxException;
                    }
                }
                return object;
            }
            CommandSyntaxException commandSyntaxException = new SimpleCommandExceptionType(() -> Impl.parseExpression$lambda$17(reader, context)).createWithContext((ImmutableStringReader)reader);
            Intrinsics.checkNotNullExpressionValue((Object)commandSyntaxException, (String)"createWithContext(...)");
            throw (Throwable)commandSyntaxException;
        }

        private final Expression parseParentheses(StringReader reader, String context, boolean read) {
            StringBuilder builder = new StringBuilder();
            if (read) {
                reader.read();
            }
            int count = 1;
            while (count != 0 && reader.canRead()) {
                char c = reader.read();
                if (c == '(') {
                    ++count;
                } else if (c == ')') {
                    --count;
                }
                if (count == 0) continue;
                builder.append(c);
            }
            if (count != 0) {
                throw new IllegalStateException("Unclosed parentheses found in equation [" + context + "] from string " + builder);
            }
            return this.parentheses(this.parseExpression(new StringReader(builder.toString()), context, 1000, new Expression[0]));
        }

        static /* synthetic */ Expression parseParentheses$default(Impl impl, StringReader stringReader, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return impl.parseParentheses(stringReader, string, bl);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Expression> parseParenthesesMultiple(StringReader reader, String context, boolean read) {
            void $this$mapTo$iv$iv;
            StringBuilder builder = new StringBuilder();
            if (read) {
                reader.read();
            }
            int count = 1;
            while (count != 0 && reader.canRead()) {
                char c = reader.read();
                if (c == '(') {
                    ++count;
                } else if (c == ')') {
                    --count;
                }
                if (count == 0) continue;
                builder.append(c);
            }
            if (count != 0) {
                throw new IllegalStateException("Unclosed parentheses found in equation [" + context + "] from string " + builder);
            }
            List str = new ArrayList();
            int splitIndex = 0;
            int count2 = 0;
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String toEat = string;
            int n = toEat.length();
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                char c = toEat.charAt(i);
                char c2 = c;
                if (c2 == '(') {
                    ++count2;
                    continue;
                }
                if (c2 == ')') {
                    --count2;
                    continue;
                }
                if (c2 != ',' || count2 != 0) continue;
                String string2 = toEat.substring(splitIndex, i2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                str.add(string2);
                splitIndex = i2 + 1;
            }
            String string3 = toEat.substring(splitIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            str.add(string3);
            Iterable $this$map$iv = str;
            boolean $i$f$map = false;
            Iterable i2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add($$INSTANCE.parseExpression(new StringReader((String)it), context, 1000, new Expression[0]));
            }
            return (List)destination$iv$iv;
        }

        static /* synthetic */ List parseParenthesesMultiple$default(Impl impl, StringReader stringReader, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return impl.parseParenthesesMultiple(stringReader, string, bl);
        }

        private final Expression constant(double constant2) {
            return new Expression(constant2){
                final /* synthetic */ double $constant;
                {
                    this.$constant = $constant;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return this.$constant;
                }

                @NotNull
                public String toString() {
                    return String.valueOf(this.$constant);
                }
            };
        }

        private final Expression parentheses(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return this.$e1.eval(vars);
                }

                @NotNull
                public String toString() {
                    return "(" + this.$e1 + ")";
                }
            };
        }

        private final Expression variable(char variable2) {
            return new Expression(variable2){
                final /* synthetic */ char $variable;
                {
                    this.$variable = $variable;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    Double d = vars.get(Character.valueOf(this.$variable));
                    if (d == null) {
                        throw new IllegalStateException("Expected variable '" + this.$variable + "', didn't find");
                    }
                    return d;
                }

                @NotNull
                public String toString() {
                    return String.valueOf(this.$variable);
                }
            };
        }

        private final Expression plus(Expression e1, Expression e2) {
            return new Expression(e1, e2){
                final /* synthetic */ Expression $e1;
                final /* synthetic */ Expression $e2;
                {
                    this.$e1 = $e1;
                    this.$e2 = $e2;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return this.$e1.eval(vars) + this.$e2.eval(vars);
                }

                @NotNull
                public String toString() {
                    return this.$e1 + " + " + this.$e2;
                }
            };
        }

        private final Expression minus(Expression e1, Expression e2) {
            return new Expression(e1, e2){
                final /* synthetic */ Expression $e1;
                final /* synthetic */ Expression $e2;
                {
                    this.$e1 = $e1;
                    this.$e2 = $e2;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return this.$e1.eval(vars) - this.$e2.eval(vars);
                }

                @NotNull
                public String toString() {
                    return this.$e1 + " - " + this.$e2;
                }
            };
        }

        private final Expression times(Expression e1, Expression e2) {
            return new Expression(e1, e2){
                final /* synthetic */ Expression $e1;
                final /* synthetic */ Expression $e2;
                {
                    this.$e1 = $e1;
                    this.$e2 = $e2;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return this.$e1.eval(vars) * this.$e2.eval(vars);
                }

                @NotNull
                public String toString() {
                    return this.$e1 + " * " + this.$e2;
                }
            };
        }

        private final Expression divide(Expression e1, Expression e2) {
            return new Expression(e1, e2){
                final /* synthetic */ Expression $e1;
                final /* synthetic */ Expression $e2;
                {
                    this.$e1 = $e1;
                    this.$e2 = $e2;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return this.$e1.eval(vars) / this.$e2.eval(vars);
                }

                @NotNull
                public String toString() {
                    return this.$e1 + " / " + this.$e2;
                }
            };
        }

        private final Expression mod(Expression e1, Expression e2) {
            return new Expression(e1, e2){
                final /* synthetic */ Expression $e1;
                final /* synthetic */ Expression $e2;
                {
                    this.$e1 = $e1;
                    this.$e2 = $e2;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return this.$e1.eval(vars) % this.$e2.eval(vars);
                }

                @NotNull
                public String toString() {
                    return this.$e1 + " % " + this.$e2;
                }
            };
        }

        private final Expression pow(Expression e1, Expression e2) {
            return new Expression(e1, e2){
                final /* synthetic */ Expression $e1;
                final /* synthetic */ Expression $e2;
                {
                    this.$e1 = $e1;
                    this.$e2 = $e2;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.pow(this.$e1.eval(vars), this.$e2.eval(vars));
                }

                @NotNull
                public String toString() {
                    return this.$e1 + " ^ " + this.$e2;
                }
            };
        }

        private final Expression sqrt(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.sqrt(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "sqrt" + this.$e1;
                }
            };
        }

        private final Expression ceil(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.ceil(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "ceil" + this.$e1;
                }
            };
        }

        private final Expression floor(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.floor(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "floor" + this.$e1;
                }
            };
        }

        private final Expression round(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.rint(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "round" + this.$e1;
                }
            };
        }

        private final Expression log(Expression e1, Expression power) {
            return new Expression(e1, power){
                final /* synthetic */ Expression $e1;
                final /* synthetic */ Expression $power;
                {
                    this.$e1 = $e1;
                    this.$power = $power;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return MathKt.log((double)this.$e1.eval(vars), (double)this.$power.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "log[" + this.$power + "]" + this.$e1;
                }
            };
        }

        private final Expression log10(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.log10(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "log10" + this.$e1;
                }
            };
        }

        private final Expression log2(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return MathKt.log2((double)this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "log2" + this.$e1;
                }
            };
        }

        private final Expression ln(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.log(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "ln" + this.$e1;
                }
            };
        }

        private final Expression abs(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.abs(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "abs" + this.$e1;
                }
            };
        }

        private final Expression sin(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.sin(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "sin" + this.$e1;
                }
            };
        }

        private final Expression cos(Expression e1) {
            return new Expression(e1){
                final /* synthetic */ Expression $e1;
                {
                    this.$e1 = $e1;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    return Math.cos(this.$e1.eval(vars));
                }

                @NotNull
                public String toString() {
                    return "cos" + this.$e1;
                }
            };
        }

        private final Expression incr(Expression e1, Expression e2) {
            return new Expression(e1, e2){
                final /* synthetic */ Expression $e1;
                final /* synthetic */ Expression $e2;
                {
                    this.$e1 = $e1;
                    this.$e2 = $e2;
                }

                public double eval(@NotNull Map<Character, Double> vars) {
                    Intrinsics.checkNotNullParameter(vars, (String)"vars");
                    double base = this.$e1.eval(vars);
                    double increment = this.$e2.eval(vars);
                    return base - base % increment;
                }

                @NotNull
                public String toString() {
                    return "incr(" + this.$e1 + "," + this.$e2 + ")";
                }
            };
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final Expression mathHelper(StringReader reader, String context, String chunk) {
            KParameter param;
            KCallable member;
            Object object;
            Object v0;
            Object element$iv;
            block11: {
                boolean bl;
                Iterable $this$firstOrNull$iv = Reflection.getOrCreateKotlinClass(class_3532.class).getMembers();
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                do {
                    block13: {
                        Iterator iterator2;
                        Collection destination$iv$iv;
                        block14: {
                            block12: {
                                void $this$mapNotNullTo$iv$iv;
                                if (!iterator.hasNext()) break block12;
                                element$iv = iterator.next();
                                KCallable it = (KCallable)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)chunk)) break block13;
                                Iterable $this$mapNotNull$iv = it.getParameters();
                                boolean $i$f$mapNotNull = false;
                                Iterable iterable = $this$mapNotNull$iv;
                                destination$iv$iv = new ArrayList();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                iterator2 = $this$forEach$iv$iv$iv.iterator();
                                break block14;
                            }
                            v0 = null;
                            break block11;
                        }
                        while (iterator2.hasNext()) {
                            Boolean it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                            boolean bl3 = false;
                            KParameter p = (KParameter)element$iv$iv;
                            boolean bl4 = false;
                            if ((Intrinsics.areEqual((Object)p.getType(), (Object)doubleType) || Intrinsics.areEqual((Object)p.getType().getClassifier(), (Object)randomClassifier) ? Boolean.valueOf(true) : null) == null) continue;
                            it$iv$iv = it$iv$iv;
                            boolean bl5 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        if (!((Collection)((List)destination$iv$iv)).isEmpty()) {
                            bl = true;
                            continue;
                        }
                    }
                    bl = false;
                } while (!bl);
                v0 = element$iv;
            }
            if ((object = (member = (KCallable)v0)) == null || (object = object.getParameters()) == null) {
                return null;
            }
            Object params = object;
            int numCount = 0;
            List inputs = new ArrayList();
            element$iv = params.iterator();
            while (element$iv.hasNext()) {
                param = (KParameter)element$iv.next();
                if (!Intrinsics.areEqual((Object)param.getType(), (Object)doubleType)) continue;
                ++numCount;
            }
            if (numCount <= 0) {
                Iterator iterator = params.iterator();
                while (iterator.hasNext()) {
                    param = (KParameter)iterator.next();
                    class_5819 class_58192 = random;
                    Intrinsics.checkNotNullExpressionValue((Object)class_58192, (String)"random");
                    inputs.add(class_58192);
                }
                if (reader.peek() != '(') return new Expression(member, (List<? extends KParameter>)params, inputs, chunk){
                    final /* synthetic */ KCallable<?> $member;
                    final /* synthetic */ List<KParameter> $params;
                    final /* synthetic */ List<Object> $inputs;
                    final /* synthetic */ String $chunk;
                    {
                        this.$member = $member;
                        this.$params = $params;
                        this.$inputs = $inputs;
                        this.$chunk = $chunk;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public double eval(@NotNull Map<Character, Double> vars) {
                        void $this$mapIndexedTo$iv$iv;
                        void $this$mapIndexed$iv;
                        Intrinsics.checkNotNullParameter(vars, (String)"vars");
                        Iterable iterable = this.$params;
                        List<Object> list = this.$inputs;
                        KCallable<?> kCallable = this.$member;
                        boolean $i$f$mapIndexed = false;
                        void var6_8 = $this$mapIndexed$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                        boolean $i$f$mapIndexedTo = false;
                        int index$iv$iv = 0;
                        for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                            Object object;
                            void kParameter;
                            int n;
                            if ((n = index$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            KParameter kParameter2 = (KParameter)item$iv$iv;
                            int n2 = n;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)kParameter.getType().getClassifier(), (Object)me.fzzyhmstrs.fzzy_config.util.Expression$Impl.access$getRandomClassifier$p())) {
                                object = list.get((int)index);
                            } else {
                                Object object2 = list.get((int)index);
                                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type me.fzzyhmstrs.fzzy_config.util.Expression");
                                object = ((Expression)object2).eval(vars);
                            }
                            collection.add(object);
                        }
                        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                        Object object = kCallable.call(Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                        return (Double)object;
                    }

                    @NotNull
                    public String toString() {
                        return this.$chunk + StringsKt.replace$default((String)StringsKt.replace$default((String)this.$inputs.toString(), (char)'[', (char)'(', (boolean)false, (int)4, null), (char)']', (char)')', (boolean)false, (int)4, null);
                    }
                };
                reader.read();
                return new /* invalid duplicate definition of identical inner class */;
            }
            List<Expression> expressions = this.parseParenthesesMultiple(reader, context, false);
            int j = 0;
            Iterator iterator = params.iterator();
            while (iterator.hasNext()) {
                KParameter param2 = (KParameter)iterator.next();
                if (Intrinsics.areEqual((Object)param2.getType(), (Object)doubleType)) {
                    inputs.add(expressions.get(j));
                    ++j;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)param2.getType().getClassifier(), (Object)randomClassifier)) continue;
                class_5819 class_58193 = random;
                Intrinsics.checkNotNullExpressionValue((Object)class_58193, (String)"random");
                inputs.add(class_58193);
            }
            if (expressions.size() == numCount) return new /* invalid duplicate definition of identical inner class */;
            throw new IllegalStateException("Incorrect number of parameters passed to [" + chunk + "], expected [" + numCount + "] found [" + expressions.size() + "]");
        }

        private static final DataResult CODEC$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (DataResult)$tmp0.invoke(p0);
        }

        private static final String CODEC$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (String)$tmp0.invoke(p0);
        }

        private static final Expression expressions$lambda$3(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression parentheses2 = $$INSTANCE.parseParentheses(reader, context, false);
            Expression sqrt2 = $$INSTANCE.sqrt(parentheses2);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{sqrt2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = sqrt2;
            }
            return expression;
        }

        private static final Expression expressions$lambda$4(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression parentheses2 = $$INSTANCE.parseParentheses(reader, context, false);
            Expression ceil2 = $$INSTANCE.ceil(parentheses2);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{ceil2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = ceil2;
            }
            return expression;
        }

        private static final Expression expressions$lambda$5(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression parentheses2 = $$INSTANCE.parseParentheses(reader, context, false);
            Expression floor2 = $$INSTANCE.floor(parentheses2);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{floor2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = floor2;
            }
            return expression;
        }

        private static final Expression expressions$lambda$6(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression parentheses2 = $$INSTANCE.parseParentheses(reader, context, false);
            Expression round2 = $$INSTANCE.round(parentheses2);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{round2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = round2;
            }
            return expression;
        }

        private static final Expression expressions$lambda$7(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression parentheses2 = $$INSTANCE.parseParentheses(reader, context, false);
            Expression ln2 = $$INSTANCE.ln(parentheses2);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{ln2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = ln2;
            }
            return expression;
        }

        private static final Expression expressions$lambda$8(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            List<Expression> params = $$INSTANCE.parseParenthesesMultiple(reader, context, false);
            if (params.size() != 2) {
                throw new IllegalStateException("Improper number of log arguments in equation [" + context + "]");
            }
            Expression log3 = $$INSTANCE.log(params.get(0), params.get(1));
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{log3};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = log3;
            }
            return expression;
        }

        private static final Expression expressions$lambda$9(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression param = $$INSTANCE.parseParentheses(reader, context, false);
            Expression log3 = $$INSTANCE.log10(param);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{log3};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = log3;
            }
            return expression;
        }

        private static final Expression expressions$lambda$10(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression param = $$INSTANCE.parseParentheses(reader, context, false);
            Expression log3 = $$INSTANCE.log2(param);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{log3};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = log3;
            }
            return expression;
        }

        private static final Expression expressions$lambda$11(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression parentheses2 = $$INSTANCE.parseParentheses(reader, context, false);
            Expression abs2 = $$INSTANCE.abs(parentheses2);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{abs2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = abs2;
            }
            return expression;
        }

        private static final Expression expressions$lambda$12(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression parentheses2 = $$INSTANCE.parseParentheses(reader, context, false);
            Expression sin2 = $$INSTANCE.sin(parentheses2);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{sin2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = sin2;
            }
            return expression;
        }

        private static final Expression expressions$lambda$13(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            Expression parentheses2 = $$INSTANCE.parseParentheses(reader, context, false);
            Expression cos2 = $$INSTANCE.cos(parentheses2);
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{cos2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = cos2;
            }
            return expression;
        }

        private static final Expression expressions$lambda$14(StringReader reader, String context, String string) {
            Expression expression;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 2>");
            List<Expression> parentheses2 = $$INSTANCE.parseParenthesesMultiple(reader, context, false);
            Expression incr2 = $$INSTANCE.incr(parentheses2.get(0), parentheses2.get(1));
            if (reader.canRead()) {
                Expression[] expressionArray = new Expression[]{incr2};
                expression = $$INSTANCE.parseExpression(reader, context, 1000, expressionArray);
            } else {
                expression = incr2;
            }
            return expression;
        }

        private static final String parseExpression$lambda$15(String $context) {
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            return "trailing '-' found in expression [" + $context + "]";
        }

        private static final String parseExpression$lambda$16(String $chunk, String $context) {
            Intrinsics.checkNotNullParameter((Object)$chunk, (String)"$chunk");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            return "Unknown expression '" + $chunk + "' in equation [" + $context + "]";
        }

        private static final String parseExpression$lambda$17(StringReader $reader, String $context) {
            Intrinsics.checkNotNullParameter((Object)$reader, (String)"$reader");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            return "Unknown expression '" + $reader.getRemaining() + "' in equation [" + $context + "]";
        }

        public static final /* synthetic */ KClassifier access$getRandomClassifier$p() {
            return randomClassifier;
        }

        static {
            $$INSTANCE = new Impl();
            CODEC = Codec.STRING.comapFlatMap(arg_0 -> Impl.CODEC$lambda$0(CODEC.1.INSTANCE, arg_0), arg_0 -> Impl.CODEC$lambda$1(CODEC.2.INSTANCE, arg_0));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"sqrt", Impl::expressions$lambda$3), TuplesKt.to((Object)"ceil", Impl::expressions$lambda$4), TuplesKt.to((Object)"floor", Impl::expressions$lambda$5), TuplesKt.to((Object)"round", Impl::expressions$lambda$6), TuplesKt.to((Object)"ln", Impl::expressions$lambda$7), TuplesKt.to((Object)"log", Impl::expressions$lambda$8), TuplesKt.to((Object)"log10", Impl::expressions$lambda$9), TuplesKt.to((Object)"log2", Impl::expressions$lambda$10), TuplesKt.to((Object)"abs", Impl::expressions$lambda$11), TuplesKt.to((Object)"sin", Impl::expressions$lambda$12), TuplesKt.to((Object)"cos", Impl::expressions$lambda$13), TuplesKt.to((Object)"incr", Impl::expressions$lambda$14)};
            expressions = MapsKt.mapOf((Pair[])pairArray);
            doubleType = Reflection.typeOf(Double.TYPE);
            randomClassifier = Reflection.typeOf(class_5819.class).getClassifier();
            random = class_5819.method_43053();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J'\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/Expression$Impl$NamedExpression;", "", "Lcom/mojang/brigadier/StringReader;", "reader", "", "context", "chunk", "Lme/fzzyhmstrs/fzzy_config/util/Expression;", "get", "(Lcom/mojang/brigadier/StringReader;Ljava/lang/String;Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/util/Expression;", "fzzy_config"})
        public static interface NamedExpression {
            @NotNull
            public Expression get(@NotNull StringReader var1, @NotNull String var2, @NotNull String var3);
        }
    }
}

