/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.block;

import com.manchick.surface.block.entity.SurfaceBlockEntities;
import com.manchick.surface.block.entity.WitchCauldronBlockEntity;
import com.manchick.surface.util.SurfaceUtil;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class WitchCauldronBlock
extends class_2237
implements class_2343 {
    public static final class_2758 LEVEL = class_2758.method_11867((String)"level", (int)0, (int)3);
    public static final class_2758 CONTENTS = class_2758.method_11867((String)"contents", (int)0, (int)2);
    public static final class_2753 FACING = class_2741.field_12525;
    public static final class_2746 IS_BOILING = class_2746.method_11825((String)"is_boiling");
    private static final class_265 RAYCAST_SHAPE = class_2275.method_9541((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final class_265 OUTLINE_SHAPE = class_259.method_1072((class_265)class_259.method_1077(), (class_265)class_259.method_17786((class_265)class_2275.method_9541((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (class_265[])new class_265[]{class_2275.method_9541((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), class_2275.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), RAYCAST_SHAPE}), (class_247)class_247.field_16886);
    int displayTicks = 0;

    public WitchCauldronBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)CONTENTS, (Comparable)Integer.valueOf(0))).method_11657((class_2769)IS_BOILING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.checkForFill(world, state, pos, player, hand)) {
            world.method_8413(pos, state, state, 2);
            return class_1269.field_21466;
        }
        if (this.checkForArrow(world, state, pos, player, hand)) {
            world.method_8413(pos, state, state, 2);
            return class_1269.field_21466;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042());
    }

    private boolean checkForFill(class_1937 world, class_2680 state, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31574(class_1802.field_8705) && !this.isFull(state)) {
            player.method_6104(hand);
            world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(3))).method_11657((class_2769)CONTENTS, (Comparable)Integer.valueOf(1)));
            world.method_8396(player, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_7337()) {
                player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550));
            }
            return true;
        }
        if (stack.method_31574(class_1802.field_8550) && this.isFull(state)) {
            if (!this.hasWater(state)) {
                return false;
            }
            player.method_6104(hand);
            world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)CONTENTS, (Comparable)Integer.valueOf(0)));
            world.method_8396(player, pos, class_3417.field_15126, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_7337()) {
                player.method_6122(hand, new class_1799((class_1935)class_1802.field_8705));
            }
            return true;
        }
        if (stack.method_31574(class_1802.field_8574) && !this.isFull(state)) {
            if (class_1844.method_8063((class_1799)stack) != class_1847.field_8991) {
                return this.checkForPotionFill(world, state, pos, player, hand);
            }
            player.method_6104(hand);
            class_2680 blockState = (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL) + 1))).method_11657((class_2769)CONTENTS, (Comparable)Integer.valueOf(1));
            world.method_8501(pos, blockState);
            world.method_8396(player, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_7337()) {
                player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8469));
                stack.method_7934(1);
            }
            return true;
        }
        if (stack.method_31574(class_1802.field_8469) && (Integer)state.method_11654((class_2769)LEVEL) > 0) {
            if (this.hasPotion(state)) {
                return this.checkForPotionFill(world, state, pos, player, hand);
            }
            player.method_6104(hand);
            if ((Integer)state.method_11654((class_2769)LEVEL) == 1) {
                class_2680 blockState = (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL) - 1))).method_11657((class_2769)CONTENTS, (Comparable)Integer.valueOf(0));
                world.method_8501(pos, blockState);
            } else {
                class_2680 blockState = (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL) - 1));
                world.method_8501(pos, blockState);
            }
            world.method_8396(player, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_7337()) {
                stack.method_7934(1);
                player.method_31548().method_7398(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991));
            }
            return true;
        }
        return false;
    }

    private boolean checkForPotionFill(class_1937 world, class_2680 state, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.hasWater(state)) {
            return false;
        }
        WitchCauldronBlockEntity entity = (WitchCauldronBlockEntity)world.method_8321(pos);
        if (entity == null) {
            return false;
        }
        if (stack.method_31574(class_1802.field_8574) && !this.isFull(state)) {
            class_1842 pot = class_1844.method_8063((class_1799)stack);
            if (pot == class_1847.field_8991) {
                return false;
            }
            if ((Integer)state.method_11654((class_2769)LEVEL) > 0 && pot != entity.getPotion()) {
                return false;
            }
            if (!class_7923.field_41179.method_10221((Object)pot).toString().contains("minecraft:")) {
                return false;
            }
            player.method_6104(hand);
            class_2680 blockState = (class_2680)((class_2680)state.method_11657((class_2769)CONTENTS, (Comparable)Integer.valueOf(2))).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL) + 1));
            world.method_8501(pos, blockState);
            entity.setPotion(pot);
            entity.method_5431();
            world.method_8396(player, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_7337()) {
                player.method_31548().method_7398(new class_1799((class_1935)class_1802.field_8469));
                stack.method_7934(1);
            }
            return true;
        }
        if (stack.method_31574(class_1802.field_8469) && (Integer)state.method_11654((class_2769)LEVEL) > 0) {
            player.method_6104(hand);
            if ((Integer)state.method_11654((class_2769)LEVEL) == 1) {
                class_2680 blockState = (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL) - 1))).method_11657((class_2769)CONTENTS, (Comparable)Integer.valueOf(0));
                world.method_8501(pos, blockState);
            } else {
                class_2680 blockState = (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL) - 1));
                world.method_8501(pos, blockState);
            }
            world.method_8396(player, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_7337()) {
                stack.method_7934(1);
                player.method_31548().method_7398(class_1844.method_8061((class_1799)new class_1799((class_1935)class_1802.field_8574), (class_1842)entity.getPotion()));
            }
            return true;
        }
        return false;
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        builder = builder.method_51872(new class_2960("surface", "cauldron"), lootConsumer -> {
            lootConsumer.accept(new class_1799((class_1935)class_1802.field_8398));
            lootConsumer.accept(new class_1799((class_1935)class_1802.field_8638));
        });
        return super.method_9560(state, builder);
    }

    private boolean checkForArrow(class_1937 world, class_2680 state, class_2338 pos, class_1657 player, class_1268 hand) {
        WitchCauldronBlockEntity entity = (WitchCauldronBlockEntity)world.method_8321(pos);
        if (entity == null) {
            return false;
        }
        if ((Integer)state.method_11654((class_2769)CONTENTS) != 2) {
            return false;
        }
        class_1842 currentPotion = entity.getPotion();
        if (currentPotion == class_1847.field_8991 || currentPotion == class_1847.field_8984) {
            return false;
        }
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_31574(class_1802.field_8107)) {
            return false;
        }
        int amount = 16;
        if ((Integer)state.method_11654((class_2769)LEVEL) == 2) {
            amount = 32;
        } else if ((Integer)state.method_11654((class_2769)LEVEL) == 3) {
            amount = 64;
        }
        int count = SurfaceUtil.clamp(stack.method_7947(), 0, amount);
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8087);
        itemStack.method_7939(count);
        class_1844.method_8061((class_1799)itemStack, (class_1842)currentPotion);
        if (!player.method_7337()) {
            stack.method_7934(count);
        }
        if (count <= 32 && count > 16) {
            if ((Integer)state.method_11654((class_2769)LEVEL) == 3) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(1)));
            } else {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
            }
        } else if (count > 32 && this.isFull(state)) {
            world.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0))).method_11657((class_2769)CONTENTS, (Comparable)Integer.valueOf(0)));
        } else {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)LEVEL) - 1)));
        }
        player.method_6104(hand);
        player.method_31548().method_7398(itemStack);
        world.method_8396(player, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
        return true;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (type != SurfaceBlockEntities.WITCH_CAULDRON) {
            return null;
        }
        return WitchCauldronBlockEntity::tick;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        double d = pos.method_10263();
        double e = pos.method_10264();
        double f = pos.method_10260();
        float i = class_3532.method_32751((class_5819)random, (int)-25, (int)25);
        float j = class_3532.method_32751((class_5819)random, (int)-25, (int)25);
        i /= 100.0f;
        j /= 100.0f;
        if (((Boolean)state.method_11654((class_2769)IS_BOILING)).booleanValue()) {
            world.method_8494((class_2394)class_2398.field_11241, d + 0.5 + (double)i, e + this.getParticleY(state), f + 0.5 + (double)j, 0.0, 0.04, 0.0);
            if (this.shouldPlaySound(random)) {
                world.method_8486(d, e, f, class_3417.field_15161, class_3419.field_15245, 0.2f + random.method_43057() * 0.2f, 0.9f + random.method_43057() * 0.15f, false);
            }
            ++this.displayTicks;
        } else {
            this.displayTicks = 0;
        }
    }

    private boolean shouldPlaySound(class_5819 random) {
        if (this.displayTicks == 0) {
            return true;
        }
        if (this.displayTicks % 10 == 0) {
            return random.method_43048(1) == 0;
        }
        return false;
    }

    private double getParticleY(class_2680 state) {
        int i = (Integer)state.method_11654((class_2769)LEVEL);
        switch (i) {
            case 3: {
                return 0.9;
            }
            case 2: {
                return 0.7;
            }
        }
        return 0.5;
    }

    private boolean hasWater(class_2680 state) {
        return (Integer)state.method_11654((class_2769)CONTENTS) == 1;
    }

    public boolean isEmpty(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == 0;
    }

    private boolean hasPotion(class_2680 state) {
        return (Integer)state.method_11654((class_2769)CONTENTS) == 2;
    }

    public boolean isFull(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == 3;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return OUTLINE_SHAPE;
    }

    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return RAYCAST_SHAPE;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WitchCauldronBlockEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LEVEL, CONTENTS, IS_BOILING, FACING});
    }
}

