/*
 * Decompiled with CFR 0.152.
 */
package com.manchick.surface.client.gui.screen.tome.page;

import com.manchick.surface.client.gui.screen.tome.page.TomePage;
import com.manchick.surface.client.gui.screen.tome.render.ItemPreview;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public class CategoryTomePage
extends TomePage {
    List<ItemPreview> previews;
    HashMap<Integer, HashMap<ScreenBox, ItemPreview>> previewBoxes = new HashMap();

    public CategoryTomePage(List<ItemPreview> categorizedItems, @Nullable TomePage parent) {
        super(parent, categorizedItems.size() / 10 + 1);
        this.previews = categorizedItems;
    }

    @Override
    public void render(class_310 client, class_332 context, int width, int height, double mouseX, double mouseY, float delta) {
        super.render(client, context, width, height, mouseX, mouseY, delta);
        HashMap<Integer, List<ItemPreview>> organizedConvertibles = this.sort(this.previews);
        List<ItemPreview> previews = organizedConvertibles.get(this.currentIndex);
        if (previews == null || previews.isEmpty()) {
            return;
        }
        TomePage.ScreenPosition position = this.addItemPreview(context, client, previews.get(0), this.getStartingPosition(width, height, true), mouseY, mouseX, delta);
        for (int i = 1; i < previews.size(); ++i) {
            ItemPreview preview = previews.get(i);
            position = this.addItemPreview(context, client, preview, position, mouseY, mouseX, delta);
            if (position.height() + 23 <= height / 2 + 70) continue;
            position = this.getStartingPosition(width, height, false);
        }
    }

    private TomePage.ScreenPosition addItemPreview(class_332 context, class_310 client, ItemPreview preview, TomePage.ScreenPosition position, double mouseY, double mouseX, float delta) {
        TomePage.ScreenPosition screenPosition = this.renderItemPreview(context, client.field_1772, preview, position.width(), position.height(), mouseY, mouseX, delta);
        ScreenBox box = new ScreenBox(position.width(), position.height(), screenPosition.width() + 104, screenPosition.height());
        this.assignHashMap(box, preview);
        return screenPosition;
    }

    private void assignHashMap(ScreenBox key, ItemPreview value) {
        boolean containsKey = this.previewBoxes.containsKey(this.currentIndex);
        HashMap<ScreenBox, ItemPreview> map = containsKey ? this.previewBoxes.get(this.currentIndex) : new HashMap<ScreenBox, ItemPreview>();
        map.put(key, value);
        if (!containsKey) {
            this.previewBoxes.put(this.currentIndex, map);
        }
    }

    public ScreenBox getHovering(double mouseX, double mouseY) {
        if (!this.previewBoxes.containsKey(this.currentIndex)) {
            return null;
        }
        for (ScreenBox box : this.previewBoxes.get(this.currentIndex).keySet()) {
            boolean blY;
            boolean blX = mouseX > (double)box.startX && mouseX < (double)box.endX;
            boolean bl = blY = mouseY > (double)box.startY && mouseY < (double)box.endY;
            if (!blX || !blY) continue;
            return box;
        }
        return null;
    }

    @Override
    public void onMouseClicked(class_310 client, double mouseX, double mouseY, int width, int height) {
        super.onMouseClicked(client, mouseX, mouseY, width, height);
        ScreenBox box = this.getHovering(mouseX, mouseY);
        if (box == null) {
            return;
        }
        ItemPreview preview = this.previewBoxes.get(this.currentIndex).get(box);
        preview.openLinkedPage(client, this);
    }

    public List<ItemPreview> getPreviews() {
        return this.previews;
    }

    protected HashMap<Integer, List<ItemPreview>> sort(List<ItemPreview> previews) {
        HashMap<Integer, List<ItemPreview>> hashMap = new HashMap<Integer, List<ItemPreview>>();
        ArrayList<ItemPreview> currentList = new ArrayList<ItemPreview>();
        int index = 0;
        for (ItemPreview preview : previews) {
            currentList.add(preview);
            if (++index < 10) continue;
            hashMap.put(hashMap.size(), currentList);
            currentList = new ArrayList();
            index = 0;
        }
        if (!currentList.isEmpty()) {
            hashMap.put(hashMap.size(), currentList);
        }
        return hashMap;
    }

    private record ScreenBox(int startX, int startY, int endX, int endY) {
    }
}

